/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.ChainedTransformer;
import org.apache.commons.collections.functors.CloneTransformer;
import org.apache.commons.collections.functors.ClosureTransformer;
import org.apache.commons.collections.functors.ConstantTransformer;
import org.apache.commons.collections.functors.ExceptionTransformer;
import org.apache.commons.collections.functors.FactoryTransformer;
import org.apache.commons.collections.functors.InstantiateTransformer;
import org.apache.commons.collections.functors.InvokerTransformer;
import org.apache.commons.collections.functors.MapTransformer;
import org.apache.commons.collections.functors.NOPTransformer;
import org.apache.commons.collections.functors.PredicateTransformer;
import org.apache.commons.collections.functors.StringValueTransformer;
import org.apache.commons.collections.functors.SwitchTransformer;

public class TransformerUtils {
    public static Transformer exceptionTransformer() {
        return ExceptionTransformer.INSTANCE;
    }

    public static Transformer nullTransformer() {
        return ConstantTransformer.NULL_INSTANCE;
    }

    public static Transformer nopTransformer() {
        return NOPTransformer.INSTANCE;
    }

    public static Transformer cloneTransformer() {
        return CloneTransformer.INSTANCE;
    }

    public static Transformer constantTransformer(Object object) {
        return ConstantTransformer.getInstance(object);
    }

    public static Transformer asTransformer(Closure closure) {
        return ClosureTransformer.getInstance(closure);
    }

    public static Transformer asTransformer(Predicate predicate) {
        return PredicateTransformer.getInstance(predicate);
    }

    public static Transformer asTransformer(Factory factory) {
        return FactoryTransformer.getInstance(factory);
    }

    public static Transformer chainedTransformer(Transformer transformer, Transformer transformer2) {
        return ChainedTransformer.getInstance(transformer, transformer2);
    }

    public static Transformer chainedTransformer(Transformer[] transformerArray) {
        return ChainedTransformer.getInstance(transformerArray);
    }

    public static Transformer chainedTransformer(Collection collection) {
        return ChainedTransformer.getInstance(collection);
    }

    public static Transformer switchTransformer(Predicate predicate, Transformer transformer, Transformer transformer2) {
        return SwitchTransformer.getInstance(new Predicate[]{predicate}, new Transformer[]{transformer}, transformer2);
    }

    public static Transformer switchTransformer(Predicate[] predicateArray, Transformer[] transformerArray) {
        return SwitchTransformer.getInstance(predicateArray, transformerArray, null);
    }

    public static Transformer switchTransformer(Predicate[] predicateArray, Transformer[] transformerArray, Transformer transformer) {
        return SwitchTransformer.getInstance(predicateArray, transformerArray, transformer);
    }

    public static Transformer switchTransformer(Map map) {
        return SwitchTransformer.getInstance(map);
    }

    public static Transformer switchMapTransformer(Map map) {
        Transformer[] transformerArray = null;
        Predicate[] predicateArray = null;
        if (map == null) {
            throw new IllegalArgumentException("The object and transformer map must not be null");
        }
        Transformer transformer = (Transformer)map.remove(null);
        int n = map.size();
        transformerArray = new Transformer[n];
        predicateArray = new Predicate[n];
        int n2 = 0;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            predicateArray[n2] = PredicateUtils.equalPredicate(entry.getKey());
            transformerArray[n2] = (Transformer)entry.getValue();
            ++n2;
        }
        return TransformerUtils.switchTransformer(predicateArray, transformerArray, transformer);
    }

    public static Transformer instantiateTransformer() {
        return InstantiateTransformer.NO_ARG_INSTANCE;
    }

    public static Transformer instantiateTransformer(Class[] classArray, Object[] objectArray) {
        return InstantiateTransformer.getInstance(classArray, objectArray);
    }

    public static Transformer mapTransformer(Map map) {
        return MapTransformer.getInstance(map);
    }

    public static Transformer invokerTransformer(String string) {
        return InvokerTransformer.getInstance(string, null, null);
    }

    public static Transformer invokerTransformer(String string, Class[] classArray, Object[] objectArray) {
        return InvokerTransformer.getInstance(string, classArray, objectArray);
    }

    public static Transformer stringValueTransformer() {
        return StringValueTransformer.INSTANCE;
    }
}

