/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.collections.FunctorException;
import org.apache.commons.collections.Transformer;

public class InstantiateTransformer
implements Transformer,
Serializable {
    static final long serialVersionUID = 3786388740793356347L;
    public static final Transformer NO_ARG_INSTANCE = new InstantiateTransformer();
    private final Class[] iParamTypes;
    private final Object[] iArgs;

    public static Transformer getInstance(Class[] classArray, Object[] objectArray) {
        if (classArray == null && objectArray != null || classArray != null && objectArray == null || classArray != null && objectArray != null && classArray.length != objectArray.length) {
            throw new IllegalArgumentException("Parameter types must match the arguments");
        }
        if (classArray == null || classArray.length == 0) {
            return NO_ARG_INSTANCE;
        }
        classArray = (Class[])classArray.clone();
        objectArray = (Object[])objectArray.clone();
        return new InstantiateTransformer(classArray, objectArray);
    }

    private InstantiateTransformer() {
        this.iParamTypes = null;
        this.iArgs = null;
    }

    public InstantiateTransformer(Class[] classArray, Object[] objectArray) {
        this.iParamTypes = classArray;
        this.iArgs = objectArray;
    }

    public Object transform(Object object) {
        try {
            if (!(object instanceof Class)) {
                throw new FunctorException("InstantiateTransformer: Input object was not an instanceof Class, it was a " + (object == null ? "null object" : object.getClass().getName()));
            }
            Constructor constructor = ((Class)object).getConstructor(this.iParamTypes);
            return constructor.newInstance(this.iArgs);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new FunctorException("InstantiateTransformer: The constructor must exist and be public ");
        }
        catch (InstantiationException instantiationException) {
            throw new FunctorException("InstantiateTransformer: InstantiationException", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new FunctorException("InstantiateTransformer: Constructor must be public", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new FunctorException("InstantiateTransformer: Constructor threw an exception", invocationTargetException);
        }
    }
}

