/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.collections.FunctorException;
import org.apache.commons.collections.Transformer;

public class InvokerTransformer
implements Transformer,
Serializable {
    static final long serialVersionUID = -8653385846894047688L;
    private final String iMethodName;
    private final Class[] iParamTypes;
    private final Object[] iArgs;

    public static Transformer getInstance(String string, Class[] classArray, Object[] objectArray) {
        if (string == null) {
            throw new IllegalArgumentException("The method to invoke must not be null");
        }
        if (classArray == null && objectArray != null || classArray != null && objectArray == null || classArray != null && objectArray != null && classArray.length != objectArray.length) {
            throw new IllegalArgumentException("The parameter types must match the arguments");
        }
        if (classArray == null || classArray.length == 0) {
            return new InvokerTransformer(string);
        }
        classArray = (Class[])classArray.clone();
        objectArray = (Object[])objectArray.clone();
        return new InvokerTransformer(string, classArray, objectArray);
    }

    private InvokerTransformer(String string) {
        this.iMethodName = string;
        this.iParamTypes = null;
        this.iArgs = null;
    }

    public InvokerTransformer(String string, Class[] classArray, Object[] objectArray) {
        this.iMethodName = string;
        this.iParamTypes = classArray;
        this.iArgs = objectArray;
    }

    public Object transform(Object object) {
        if (object == null) {
            return null;
        }
        try {
            Class<?> clazz = object.getClass();
            Method method = clazz.getMethod(this.iMethodName, this.iParamTypes);
            return method.invoke(object, this.iArgs);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new FunctorException("InvokerTransformer: The method '" + this.iMethodName + "' on '" + object.getClass() + "' does not exist");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new FunctorException("InvokerTransformer: The method '" + this.iMethodName + "' on '" + object.getClass() + "' cannot be accessed");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new FunctorException("InvokerTransformer: The method '" + this.iMethodName + "' on '" + object.getClass() + "' threw an exception", invocationTargetException);
        }
    }
}

