/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.lang.reflect.Array;
import java.util.NoSuchElementException;
import org.apache.commons.collections.ResettableIterator;

public class ArrayIterator
implements ResettableIterator {
    protected Object array;
    protected int startIndex = 0;
    protected int endIndex = 0;
    protected int index = 0;

    public ArrayIterator() {
    }

    public ArrayIterator(Object object) {
        this.setArray(object);
    }

    public ArrayIterator(Object object, int n) {
        this.setArray(object);
        this.checkBound(n, "start");
        this.startIndex = n;
        this.index = n;
    }

    public ArrayIterator(Object object, int n, int n2) {
        this.setArray(object);
        this.checkBound(n, "start");
        this.checkBound(n2, "end");
        if (n2 < n) {
            throw new IllegalArgumentException("End index must not be less than start index.");
        }
        this.startIndex = n;
        this.endIndex = n2;
        this.index = n;
    }

    protected void checkBound(int n, String string) {
        if (n > this.endIndex) {
            throw new ArrayIndexOutOfBoundsException("Attempt to make an ArrayIterator that " + string + "s beyond the end of the array. ");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Attempt to make an ArrayIterator that " + string + "s before the start of the array. ");
        }
    }

    public boolean hasNext() {
        return this.index < this.endIndex;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return Array.get(this.array, this.index++);
    }

    public void remove() {
        throw new UnsupportedOperationException("remove() method is not supported");
    }

    public Object getArray() {
        return this.array;
    }

    public void setArray(Object object) {
        this.endIndex = Array.getLength(object);
        this.startIndex = 0;
        this.array = object;
        this.index = 0;
    }

    public void reset() {
        this.index = this.startIndex;
    }
}

