/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections.list.UnmodifiableList;

public class CollatingIterator
implements Iterator {
    private Comparator comparator = null;
    private ArrayList iterators = null;
    private ArrayList values = null;
    private BitSet valueSet = null;
    private int lastReturned = -1;

    public CollatingIterator() {
        this(null, 2);
    }

    public CollatingIterator(Comparator comparator) {
        this(comparator, 2);
    }

    public CollatingIterator(Comparator comparator, int n) {
        this.iterators = new ArrayList(n);
        this.setComparator(comparator);
    }

    public CollatingIterator(Comparator comparator, Iterator iterator, Iterator iterator2) {
        this(comparator, 2);
        this.addIterator(iterator);
        this.addIterator(iterator2);
    }

    public CollatingIterator(Comparator comparator, Iterator[] iteratorArray) {
        this(comparator, iteratorArray.length);
        for (int i = 0; i < iteratorArray.length; ++i) {
            this.addIterator(iteratorArray[i]);
        }
    }

    public CollatingIterator(Comparator comparator, Collection collection) {
        this(comparator, collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = (Iterator)iterator.next();
            this.addIterator(iterator2);
        }
    }

    public void addIterator(Iterator iterator) {
        this.checkNotStarted();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iterators.add(iterator);
    }

    public void setIterator(int n, Iterator iterator) {
        this.checkNotStarted();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iterators.set(n, iterator);
    }

    public List getIterators() {
        return UnmodifiableList.decorate(this.iterators);
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.checkNotStarted();
        this.comparator = comparator;
    }

    public boolean hasNext() {
        this.start();
        return this.anyValueSet(this.valueSet) || this.anyHasNext(this.iterators);
    }

    public Object next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int n = this.least();
        if (n == -1) {
            throw new NoSuchElementException();
        }
        Object e = this.values.get(n);
        this.clear(n);
        this.lastReturned = n;
        return e;
    }

    public void remove() {
        if (this.lastReturned == -1) {
            throw new IllegalStateException("No value can be removed at present");
        }
        Iterator iterator = (Iterator)this.iterators.get(this.lastReturned);
        iterator.remove();
    }

    private void start() {
        if (this.values == null) {
            this.values = new ArrayList(this.iterators.size());
            this.valueSet = new BitSet(this.iterators.size());
            for (int i = 0; i < this.iterators.size(); ++i) {
                this.values.add(null);
                this.valueSet.clear(i);
            }
        }
    }

    private boolean set(int n) {
        Iterator iterator = (Iterator)this.iterators.get(n);
        if (iterator.hasNext()) {
            this.values.set(n, iterator.next());
            this.valueSet.set(n);
            return true;
        }
        this.values.set(n, null);
        this.valueSet.clear(n);
        return false;
    }

    private void clear(int n) {
        this.values.set(n, null);
        this.valueSet.clear(n);
    }

    private void checkNotStarted() throws IllegalStateException {
        if (this.values != null) {
            throw new IllegalStateException("Can't do that after next or hasNext has been called.");
        }
    }

    private int least() {
        int n = -1;
        Object t = null;
        for (int i = 0; i < this.values.size(); ++i) {
            if (!this.valueSet.get(i)) {
                this.set(i);
            }
            if (!this.valueSet.get(i)) continue;
            if (n == -1) {
                n = i;
                t = this.values.get(i);
                continue;
            }
            Object e = this.values.get(i);
            if (this.comparator.compare(e, t) >= 0) continue;
            t = e;
            n = i;
        }
        return n;
    }

    private boolean anyValueSet(BitSet bitSet) {
        for (int i = 0; i < bitSet.size(); ++i) {
            if (!bitSet.get(i)) continue;
            return true;
        }
        return false;
    }

    private boolean anyHasNext(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Iterator iterator = (Iterator)arrayList.get(i);
            if (!iterator.hasNext()) continue;
            return true;
        }
        return false;
    }
}

