/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.ResettableIterator;

public class ObjectArrayIterator
implements Iterator,
ResettableIterator {
    protected Object[] array = null;
    protected int startIndex = 0;
    protected int endIndex = 0;
    protected int index = 0;

    public ObjectArrayIterator() {
    }

    public ObjectArrayIterator(Object[] objectArray) {
        this(objectArray, 0, objectArray.length);
    }

    public ObjectArrayIterator(Object[] objectArray, int n) {
        this(objectArray, n, objectArray.length);
    }

    public ObjectArrayIterator(Object[] objectArray, int n, int n2) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Start index must not be less than zero");
        }
        if (n2 > objectArray.length) {
            throw new ArrayIndexOutOfBoundsException("End index must not be greater than the array length");
        }
        if (n > objectArray.length) {
            throw new ArrayIndexOutOfBoundsException("Start index must not be greater than the array length");
        }
        if (n2 < n) {
            throw new IllegalArgumentException("End index must not be less than start index");
        }
        this.array = objectArray;
        this.startIndex = n;
        this.endIndex = n2;
        this.index = n;
    }

    public boolean hasNext() {
        return this.index < this.endIndex;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.array[this.index++];
    }

    public void remove() {
        throw new UnsupportedOperationException("remove() method is not supported for an ObjectArrayIterator");
    }

    public Object[] getArray() {
        return this.array;
    }

    public void setArray(Object[] objectArray) {
        if (this.array != null) {
            throw new IllegalStateException("The array to iterate over has already been set");
        }
        this.array = objectArray;
        this.startIndex = 0;
        this.endIndex = objectArray.length;
        this.index = 0;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void reset() {
        this.index = this.startIndex;
    }
}

