/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections.iterators.AbstractListIteratorDecorator;
import org.apache.commons.collections.list.AbstractListDecorator;
import org.apache.commons.collections.set.UnmodifiableSet;

public class SetUniqueList
extends AbstractListDecorator {
    protected final Set set;

    public static SetUniqueList decorate(List list) {
        if (list == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        if (list.isEmpty()) {
            return new SetUniqueList(list, new HashSet());
        }
        ArrayList arrayList = new ArrayList(list);
        list.clear();
        SetUniqueList setUniqueList = new SetUniqueList(list, new HashSet());
        setUniqueList.addAll((Collection)arrayList);
        return setUniqueList;
    }

    protected SetUniqueList(List list, Set set) {
        super(list);
        if (set == null) {
            throw new IllegalArgumentException("Set must not be null");
        }
        this.set = set;
    }

    public Set asSet() {
        return UnmodifiableSet.decorate(this.set);
    }

    public boolean add(Object object) {
        int n = this.size();
        this.add(this.size(), object);
        return n != this.size();
    }

    public void add(int n, Object object) {
        if (!this.set.contains(object)) {
            super.add(n, object);
            this.set.add(object);
        }
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    public boolean addAll(int n, Collection collection) {
        int n2 = this.size();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return n2 != this.size();
    }

    public Object set(int n, Object object) {
        int n2 = this.indexOf(object);
        Object object2 = super.set(n, object);
        if (n2 == -1 || n2 == n) {
            return object2;
        }
        return this.remove(n2);
    }

    public boolean remove(Object object) {
        boolean bl = super.remove(object);
        this.set.remove(object);
        return bl;
    }

    public Object remove(int n) {
        Object object = super.remove(n);
        this.set.remove(object);
        return object;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = super.removeAll(collection);
        this.set.removeAll(collection);
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = super.retainAll(collection);
        this.set.retainAll(collection);
        return bl;
    }

    public void clear() {
        super.clear();
        this.set.clear();
    }

    public boolean contains(Object object) {
        return this.set.contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.set.containsAll(collection);
    }

    public Iterator iterator() {
        return new SetListIterator(super.iterator(), this.set);
    }

    public ListIterator listIterator() {
        return new SetListListIterator(super.listIterator(), this.set);
    }

    public ListIterator listIterator(int n) {
        return new SetListListIterator(super.listIterator(n), this.set);
    }

    public List subList(int n, int n2) {
        return new SetUniqueList(super.subList(n, n2), this.set);
    }

    static class SetListListIterator
    extends AbstractListIteratorDecorator {
        protected final Set set;
        protected Object last = null;

        protected SetListListIterator(ListIterator listIterator, Set set) {
            super(listIterator);
            this.set = set;
        }

        public Object next() {
            this.last = super.next();
            return this.last;
        }

        public Object previous() {
            this.last = super.previous();
            return this.last;
        }

        public void remove() {
            super.remove();
            this.set.remove(this.last);
            this.last = null;
        }

        public void add(Object object) {
            if (!this.set.contains(object)) {
                super.add(object);
                this.set.add(object);
            }
        }

        public void set(Object object) {
            throw new UnsupportedOperationException("ListIterator does not support set");
        }
    }

    static class SetListIterator
    extends AbstractIteratorDecorator {
        protected final Set set;
        protected Object last = null;

        protected SetListIterator(Iterator iterator, Set set) {
            super(iterator);
            this.set = set;
        }

        public Object next() {
            this.last = super.next();
            return this.last;
        }

        public void remove() {
            super.remove();
            this.set.remove(this.last);
            this.last = null;
        }
    }
}

