/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.BoundedMap;
import org.apache.commons.collections.map.AbstractHashedMap;
import org.apache.commons.collections.map.AbstractLinkedMap;

public class LRUMap
extends AbstractLinkedMap
implements BoundedMap,
Serializable,
Cloneable {
    static final long serialVersionUID = -612114643488955218L;
    protected static final int DEFAULT_MAX_SIZE = 100;
    private transient int maxSize;

    public LRUMap() {
        this(100, 0.75f);
    }

    public LRUMap(int n) {
        this(n, 0.75f);
    }

    public LRUMap(int n, float f) {
        super(n < 1 ? 16 : n, f);
        if (n < 1) {
            throw new IllegalArgumentException("LRUMap max size must be greater than 0");
        }
        this.maxSize = n;
    }

    public LRUMap(Map map) {
        this(map.size(), 0.75f);
        this.putAll(map);
    }

    public Object get(Object object) {
        AbstractLinkedMap.LinkEntry linkEntry = (AbstractLinkedMap.LinkEntry)this.getEntry(object);
        if (linkEntry == null) {
            return null;
        }
        this.moveToMRU(linkEntry);
        return linkEntry.getValue();
    }

    protected void moveToMRU(AbstractLinkedMap.LinkEntry linkEntry) {
        if (linkEntry.after != this.header) {
            ++this.modCount;
            linkEntry.before.after = linkEntry.after;
            linkEntry.after.before = linkEntry.before;
            linkEntry.after = this.header;
            linkEntry.before = this.header.before;
            this.header.before.after = linkEntry;
            this.header.before = linkEntry;
        }
    }

    protected void updateEntry(AbstractHashedMap.HashEntry hashEntry, Object object) {
        this.moveToMRU((AbstractLinkedMap.LinkEntry)hashEntry);
        hashEntry.setValue(object);
    }

    protected void addMapping(int n, int n2, Object object, Object object2) {
        if (this.size >= this.maxSize && this.removeLRU(this.header.before)) {
            this.reuseMapping(this.header.after, n, n2, object, object2);
        } else {
            super.addMapping(n, n2, object, object2);
        }
    }

    protected void reuseMapping(AbstractLinkedMap.LinkEntry linkEntry, int n, int n2, Object object, Object object2) {
        int n3 = this.hashIndex(linkEntry.hashCode, this.data.length);
        AbstractHashedMap.HashEntry hashEntry = this.data[n3];
        AbstractHashedMap.HashEntry hashEntry2 = null;
        while (hashEntry != linkEntry) {
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        ++this.modCount;
        this.removeEntry(linkEntry, n3, hashEntry2);
        this.reuseEntry(linkEntry, n, n2, object, object2);
        this.addEntry(linkEntry, n);
    }

    protected boolean removeLRU(AbstractLinkedMap.LinkEntry linkEntry) {
        return true;
    }

    public boolean isFull() {
        return this.size >= this.maxSize;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        this.doWriteObject(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.doReadObject(objectInputStream);
    }

    protected void doWriteObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.maxSize);
        super.doWriteObject(objectOutputStream);
    }

    protected void doReadObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.maxSize = objectInputStream.readInt();
        super.doReadObject(objectInputStream);
    }
}

