/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.collections.iterators.UnmodifiableIterator;
import org.apache.commons.collections.iterators.UnmodifiableListIterator;
import org.apache.commons.collections.list.UnmodifiableList;
import org.apache.commons.collections.map.AbstractLinkedMap;

public class LinkedMap
extends AbstractLinkedMap
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 9077234323521161066L;

    public LinkedMap() {
        super(16, 0.75f, 12);
    }

    public LinkedMap(int n) {
        super(n);
    }

    public LinkedMap(int n, float f) {
        super(n, f);
    }

    public LinkedMap(Map map) {
        super(map);
    }

    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        this.doWriteObject(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.doReadObject(objectInputStream);
    }

    public Object get(int n) {
        return this.getEntry(n).getKey();
    }

    public Object getValue(int n) {
        return this.getEntry(n).getValue();
    }

    public int indexOf(Object object) {
        object = this.convertKey(object);
        int n = 0;
        AbstractLinkedMap.LinkEntry linkEntry = this.header.after;
        while (linkEntry != this.header) {
            if (this.isEqualKey(object, linkEntry.key)) {
                return n;
            }
            linkEntry = linkEntry.after;
            ++n;
        }
        return -1;
    }

    public Object remove(int n) {
        return this.remove(this.get(n));
    }

    public List asList() {
        return new LinkedMapList(this);
    }

    static class LinkedMapList
    extends AbstractList {
        final LinkedMap parent;

        LinkedMapList(LinkedMap linkedMap) {
            this.parent = linkedMap;
        }

        public int size() {
            return this.parent.size();
        }

        public Object get(int n) {
            return this.parent.get(n);
        }

        public boolean contains(Object object) {
            return this.parent.containsKey(object);
        }

        public int indexOf(Object object) {
            return this.parent.indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return this.parent.indexOf(object);
        }

        public boolean containsAll(Collection collection) {
            return this.parent.keySet().containsAll(collection);
        }

        public Object remove(int n) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object[] toArray() {
            return this.parent.keySet().toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.parent.keySet().toArray(objectArray);
        }

        public Iterator iterator() {
            return UnmodifiableIterator.decorate(this.parent.keySet().iterator());
        }

        public ListIterator listIterator() {
            return UnmodifiableListIterator.decorate(super.listIterator());
        }

        public ListIterator listIterator(int n) {
            return UnmodifiableListIterator.decorate(super.listIterator(n));
        }

        public List subList(int n, int n2) {
            return UnmodifiableList.decorate(super.subList(n, n2));
        }
    }
}

