/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.time;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TimeZone;

public class DateUtils {
    public static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("GMT");
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final int SEMI_MONTH = 1001;
    private static final int[][] fields = new int[][]{{14}, {13}, {12}, {11, 10}, {5, 5, 9}, {2, 1001}, {1}, {0}};
    public static final int RANGE_WEEK_SUNDAY = 1;
    public static final int RANGE_WEEK_MONDAY = 2;
    public static final int RANGE_WEEK_RELATIVE = 3;
    public static final int RANGE_WEEK_CENTER = 4;
    public static final int RANGE_MONTH_SUNDAY = 5;
    public static final int RANGE_MONTH_MONDAY = 6;
    public static final int MILLIS_IN_SECOND = 1000;
    public static final int MILLIS_IN_MINUTE = 60000;
    public static final int MILLIS_IN_HOUR = 3600000;
    public static final int MILLIS_IN_DAY = 86400000;

    public static boolean isSameDay(Date date, Date date2) {
        if (date == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        return DateUtils.isSameDay(calendar, calendar2);
    }

    public static boolean isSameDay(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return calendar.get(0) == calendar2.get(0) && calendar.get(1) == calendar2.get(1) && calendar.get(6) == calendar2.get(6);
    }

    public static boolean isSameInstant(Date date, Date date2) {
        if (date == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return date.getTime() == date2.getTime();
    }

    public static boolean isSameInstant(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return calendar.getTime().getTime() == calendar2.getTime().getTime();
    }

    public static boolean isSameLocalTime(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return calendar.get(14) == calendar2.get(14) && calendar.get(13) == calendar2.get(13) && calendar.get(12) == calendar2.get(12) && calendar.get(10) == calendar2.get(10) && calendar.get(6) == calendar2.get(6) && calendar.get(1) == calendar2.get(1) && calendar.get(0) == calendar2.get(0) && calendar.getClass() == calendar2.getClass();
    }

    public static Date parseDate(String string, String[] stringArray) throws ParseException {
        if (string == null || stringArray == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        SimpleDateFormat simpleDateFormat = null;
        ParsePosition parsePosition = new ParsePosition(0);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == 0) {
                simpleDateFormat = new SimpleDateFormat(stringArray[0]);
            } else {
                simpleDateFormat.applyPattern(stringArray[i]);
            }
            parsePosition.setIndex(0);
            Date date = simpleDateFormat.parse(string, parsePosition);
            if (date == null || parsePosition.getIndex() != string.length()) continue;
            return date;
        }
        throw new ParseException("Unable to parse the date: " + string, -1);
    }

    public static Date round(Date date, int n) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, n, true);
        return calendar.getTime();
    }

    public static Calendar round(Calendar calendar, int n) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        DateUtils.modify(calendar2, n, true);
        return calendar2;
    }

    public static Date round(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (object instanceof Date) {
            return DateUtils.round((Date)object, n);
        }
        if (object instanceof Calendar) {
            return DateUtils.round((Calendar)object, n).getTime();
        }
        throw new ClassCastException("Could not round " + object);
    }

    public static Date truncate(Date date, int n) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, n, false);
        return calendar.getTime();
    }

    public static Calendar truncate(Calendar calendar, int n) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        DateUtils.modify(calendar2, n, false);
        return calendar2;
    }

    public static Date truncate(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (object instanceof Date) {
            return DateUtils.truncate((Date)object, n);
        }
        if (object instanceof Calendar) {
            return DateUtils.truncate((Calendar)object, n).getTime();
        }
        throw new ClassCastException("Could not truncate " + object);
    }

    private static void modify(Calendar calendar, int n, boolean bl) {
        if (calendar.get(1) > 280000000) {
            throw new ArithmeticException("Calendar value too large for accurate calculations");
        }
        boolean bl2 = false;
        for (int i = 0; i < fields.length; ++i) {
            int n2;
            for (n2 = 0; n2 < fields[i].length; ++n2) {
                if (fields[i][n2] != n) continue;
                if (bl && bl2) {
                    if (n == 1001) {
                        if (calendar.get(5) == 1) {
                            calendar.add(5, 15);
                        } else {
                            calendar.add(5, -15);
                            calendar.add(2, 1);
                        }
                    } else {
                        calendar.add(fields[i][0], 1);
                    }
                }
                return;
            }
            n2 = 0;
            boolean bl3 = false;
            switch (n) {
                case 1001: {
                    if (fields[i][0] != 5) break;
                    n2 = calendar.get(5) - 1;
                    if (n2 >= 15) {
                        n2 -= 15;
                    }
                    bl2 = n2 > 7;
                    bl3 = true;
                    break;
                }
                case 9: {
                    if (fields[i][0] != 11) break;
                    n2 = calendar.get(11);
                    if (n2 >= 12) {
                        n2 -= 12;
                    }
                    bl2 = n2 > 6;
                    bl3 = true;
                }
            }
            if (!bl3) {
                int n3 = calendar.getActualMinimum(fields[i][0]);
                int n4 = calendar.getActualMaximum(fields[i][0]);
                n2 = calendar.get(fields[i][0]) - n3;
                bl2 = n2 > (n4 - n3) / 2;
            }
            calendar.set(fields[i][0], calendar.get(fields[i][0]) - n2);
        }
        throw new IllegalArgumentException("The field " + n + " is not supported");
    }

    public static Iterator iterator(Date date, int n) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.iterator(calendar, n);
    }

    public static Iterator iterator(Calendar calendar, int n) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar2 = null;
        Calendar calendar3 = null;
        int n2 = 1;
        int n3 = 7;
        switch (n) {
            case 5: 
            case 6: {
                calendar2 = DateUtils.truncate(calendar, 2);
                calendar3 = (Calendar)calendar2.clone();
                calendar3.add(2, 1);
                calendar3.add(5, -1);
                if (n != 6) break;
                n2 = 2;
                n3 = 1;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                calendar2 = DateUtils.truncate(calendar, 5);
                calendar3 = DateUtils.truncate(calendar, 5);
                switch (n) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        n3 = 1;
                        break;
                    }
                    case 3: {
                        n2 = calendar.get(7);
                        n3 = n2 - 1;
                        break;
                    }
                    case 4: {
                        n2 = calendar.get(7) - 3;
                        n3 = calendar.get(7) + 3;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The range style " + n + " is not valid.");
            }
        }
        if (n2 < 1) {
            n2 += 7;
        }
        if (n2 > 7) {
            n2 -= 7;
        }
        if (n3 < 1) {
            n3 += 7;
        }
        if (n3 > 7) {
            n3 -= 7;
        }
        while (calendar2.get(7) != n2) {
            calendar2.add(5, -1);
        }
        while (calendar3.get(7) != n3) {
            calendar3.add(5, 1);
        }
        return new DateIterator(calendar2, calendar3);
    }

    public static Iterator iterator(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (object instanceof Date) {
            return DateUtils.iterator((Date)object, n);
        }
        if (object instanceof Calendar) {
            return DateUtils.iterator((Calendar)object, n);
        }
        throw new ClassCastException("Could not iterate based on " + object);
    }

    static class DateIterator
    implements Iterator {
        private final Calendar endFinal;
        private final Calendar spot;

        DateIterator(Calendar calendar, Calendar calendar2) {
            this.endFinal = calendar2;
            this.spot = calendar;
            this.spot.add(5, -1);
        }

        public boolean hasNext() {
            return this.spot.before(this.endFinal);
        }

        public Object next() {
            if (this.spot.equals(this.endFinal)) {
                throw new NoSuchElementException();
            }
            this.spot.add(5, 1);
            return this.spot.clone();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

