/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.lang.SystemUtils;
import phex.common.Environment;
import phex.common.ManagerController;
import phex.common.ThreadTracking;
import phex.connection.LoopbackDispatcher;
import phex.connection.NetworkManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.SplashWindow;
import phex.utils.Localizer;
import phex.utils.Logger;
import phex.utils.NLogger;

public class Main {
    public static void main(String[] stringArray) {
        Serializable serializable;
        Object object;
        String string;
        long l = System.currentTimeMillis();
        Main.validateJavaVersion();
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        while ((string = Main.readArgument(iterator)) != null) {
            if (string.equalsIgnoreCase("-c")) {
                object = Main.readArgument(iterator);
                if (object == null) continue;
                serializable = new File((String)object);
                try {
                    Environment.getInstance().setPhexConfigRoot((File)serializable);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                continue;
            }
            if (string.equalsIgnoreCase("-uri")) {
                string3 = Main.readArgument(iterator);
                continue;
            }
            if (string.equalsIgnoreCase("-magma")) {
                string4 = Main.readArgument(iterator);
                continue;
            }
            if (!string.equalsIgnoreCase("-rss")) continue;
            string5 = Main.readArgument(iterator);
        }
        if (string3 != null && LoopbackDispatcher.dispatchUri(string3)) {
            System.exit(0);
        }
        if (string4 != null && LoopbackDispatcher.dispatchMagmaFile(string4)) {
            System.exit(0);
        }
        if (string5 != null && LoopbackDispatcher.dispatchRSSFile(string5)) {
            System.exit(0);
        }
        try {
            object = null;
            try {
                object = new SplashWindow();
                ((SplashWindow)object).showSplash();
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
            Localizer.initialize();
            ThreadTracking.initialize();
            ManagerController.initializeManagers();
            long l2 = System.currentTimeMillis();
            Logger.logMessage(Logger.FINEST, (short)255, "Pre GUI startup time: " + (l2 - l));
            try {
                GUIRegistry.getInstance().initialize();
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                // empty catch block
            }
            if (object != null) {
                ((Window)object).dispose();
            }
            serializable = null;
            serializable = GUIRegistry.getInstance().getMainFrame();
            if (serializable != null) {
                ((Window)serializable).setVisible(true);
            }
            l2 = System.currentTimeMillis();
            Logger.logMessage(Logger.FINEST, (short)255, "Full startup time: " + (l2 - l));
            ManagerController.startupCompletedNotify();
            if (string2 != null) {
                NetworkManager.getInstance().fireIncomingUriDownload(string2);
            }
            if (string3 != null) {
                NetworkManager.getInstance().fireIncomingUriDownload(string3);
            }
            if (string4 != null) {
                NetworkManager.getInstance().fireIncomingMagmaDownload(string4);
            }
            if (string5 != null) {
                NetworkManager.getInstance().fireIncomingRSSDownload(string4);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            NLogger.error("GLOBAL", (Object)throwable, throwable);
            System.exit(1);
        }
    }

    private static String readArgument(Iterator iterator) {
        if (!iterator.hasNext()) {
            return null;
        }
        String string = (String)iterator.next();
        return string;
    }

    private static void validateJavaVersion() {
        if (SystemUtils.isJavaVersionAtLeast(1.4f)) {
            return;
        }
        JFrame jFrame = new JFrame("Wrong Java Version");
        jFrame.setSize(new Dimension(0, 0));
        jFrame.setVisible(true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jFrame.getSize();
        Rectangle rectangle = new Rectangle((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2, dimension2.width, dimension2.height);
        jFrame.setBounds(rectangle);
        JOptionPane.showMessageDialog(jFrame, "Please use a newer Java VM.\nPhex requires at least Java 1.4.0. You are using Java " + SystemUtils.JAVA_VERSION + "\n" + "To get the latest Java release go to http://java.com.", "Wrong Java Version", 2);
        System.exit(1);
    }
}

