/*
 * Decompiled with CFR 0.152.
 */
package phex.chat;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import phex.chat.ChatManager;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.bandwidth.BandwidthManager;
import phex.net.connection.OIOSocketFactory;
import phex.net.presentation.SocketFacade;
import phex.utils.BandwidthInputStream;
import phex.utils.BandwidthOutputStream;
import phex.utils.GnutellaInputStream;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class ChatEngine {
    private boolean isOutgoingConnection;
    private SocketFacade socket;
    private GnutellaInputStream chatReader;
    private BufferedWriter chatWriter;
    private String chatNick;
    private DestAddress hostAddress;

    public ChatEngine(SocketFacade socketFacade, GnutellaInputStream gnutellaInputStream, DestAddress destAddress) throws IOException {
        this.socket = socketFacade;
        this.hostAddress = destAddress;
        this.chatReader = gnutellaInputStream;
        BandwidthOutputStream bandwidthOutputStream = new BandwidthOutputStream(this.socket.getOutputStream(), BandwidthManager.getInstance().getNetworkBandwidthController());
        this.chatWriter = new BufferedWriter(new OutputStreamWriter(bandwidthOutputStream));
        this.chatNick = this.hostAddress.getHostName();
        this.finalizeHandshake();
        this.isOutgoingConnection = false;
    }

    public ChatEngine(DestAddress destAddress) {
        this.hostAddress = destAddress;
        this.isOutgoingConnection = true;
        this.chatNick = this.hostAddress.getHostName();
    }

    public void startChat() {
        ChatReadWorker chatReadWorker = new ChatReadWorker();
        ThreadPool.getInstance().addJob(chatReadWorker, "ChatReadWorker-" + Integer.toHexString(chatReadWorker.hashCode()));
    }

    public void stopChat() {
        if (this.chatReader != null) {
            this.chatReader.close();
            this.chatReader = null;
        }
        IOUtil.closeQuietly(this.chatWriter);
        this.chatWriter = null;
        IOUtil.closeQuietly(this.socket);
        this.socket = null;
        ChatManager.getInstance().chatClosed(this);
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public String getChatNick() {
        return this.chatNick;
    }

    public void sendChatMessage(String string) {
        if (this.chatWriter == null) {
            ChatManager.getInstance().fireChatConnectionFailed(this);
        }
        try {
            this.chatWriter.write(string + "\n");
            this.chatWriter.flush();
        }
        catch (IOException iOException) {
            NLogger.warn(ChatEngine.class, (Object)iOException, (Throwable)iOException);
            this.stopChat();
        }
    }

    private void finalizeHandshake() throws IOException {
        String string;
        this.socket.setSoTimeout(ServiceManager.sCfg.socketConnectTimeout);
        do {
            string = this.chatReader.readLine();
            NLogger.debug(class$phex$chat$ChatEngine == null ? ChatEngine.class$("phex.chat.ChatEngine") : class$phex$chat$ChatEngine, (Object)("Read Chat header: " + string));
            if (string == null) {
                throw new IOException("No handshake response from chat partner.");
            }
            String string2 = string.toUpperCase();
            if (!string2.startsWith("X-NICKNAME:")) continue;
            this.chatNick = string.substring(11).trim();
            NLogger.debug(class$phex$chat$ChatEngine == null ? ChatEngine.class$("phex.chat.ChatEngine") : class$phex$chat$ChatEngine, (Object)("Chat Nick: " + this.chatNick));
        } while (string.length() > 0);
        NLogger.debug(ChatEngine.class, (Object)"Sending: CHAT/0.1 200 OK");
        this.chatWriter.write("CHAT/0.1 200 OK\r\nUser-Agent: " + Environment.getPhexVendor() + "\r\n" + "\r\n");
        this.chatWriter.flush();
        do {
            string = this.chatReader.readLine();
            NLogger.debug(class$phex$chat$ChatEngine == null ? ChatEngine.class$("phex.chat.ChatEngine") : class$phex$chat$ChatEngine, (Object)("Read Chat response: " + string));
            if (string != null) continue;
            throw new IOException("No handshake response from chat partner.");
        } while (string.length() > 0);
        this.socket.setSoTimeout(0);
    }

    private void connectOutgoingChat() throws IOException {
        String string;
        NLogger.debug(ChatEngine.class, (Object)("Connect outgoing to: " + this.hostAddress));
        this.socket = OIOSocketFactory.connect(this.hostAddress, ServiceManager.sCfg.mNetConnectionTimeout);
        BandwidthOutputStream bandwidthOutputStream = new BandwidthOutputStream(this.socket.getOutputStream(), BandwidthManager.getInstance().getNetworkBandwidthController());
        this.chatWriter = new BufferedWriter(new OutputStreamWriter(bandwidthOutputStream));
        String string2 = "CHAT CONNECT/0.1\r\nUser-Agent: " + Environment.getPhexVendor() + "\r\n" + "\r\n";
        NLogger.debug(ChatEngine.class, (Object)("Sending: " + string2));
        this.chatWriter.write(string2);
        this.chatWriter.flush();
        BandwidthInputStream bandwidthInputStream = new BandwidthInputStream(this.socket.getInputStream(), BandwidthManager.getInstance().getNetworkBandwidthController());
        this.chatReader = new GnutellaInputStream(bandwidthInputStream);
        do {
            string = this.chatReader.readLine();
            NLogger.debug(class$phex$chat$ChatEngine == null ? ChatEngine.class$("phex.chat.ChatEngine") : class$phex$chat$ChatEngine, (Object)("Read Chat header: " + string));
            if (string == null) {
                throw new IOException("No handshake response from chat partner.");
            }
            String string3 = string.toUpperCase();
            if (!string3.startsWith("X-NICKNAME:")) continue;
            this.chatNick = string.substring(11).trim();
        } while (string.length() > 0);
        this.chatWriter.write("CHAT/0.1 200 OK\r\nUser-Agent: " + Environment.getPhexVendor() + "\r\n\r\n");
        this.chatWriter.flush();
        this.socket.setSoTimeout(0);
    }

    private class ChatReadWorker
    implements Runnable {
        private ChatReadWorker() {
        }

        public void run() {
            if (ChatEngine.this.isOutgoingConnection) {
                try {
                    ChatEngine.this.connectOutgoingChat();
                }
                catch (IOException iOException) {
                    ChatEngine.this.stopChat();
                    return;
                }
            }
            ChatManager chatManager = ChatManager.getInstance();
            try {
                while (true) {
                    String string;
                    if ((string = ChatEngine.this.chatReader.readLine()) == null) {
                        throw new IOException("Remote host diconnected chat.");
                    }
                    if (string.length() == 0) continue;
                    NLogger.debug(class$phex$chat$ChatEngine == null ? ChatEngine.class$("phex.chat.ChatEngine") : class$phex$chat$ChatEngine, (Object)("Reading chat message: " + string));
                    chatManager.fireChatMessageReceived(ChatEngine.this, string);
                }
            }
            catch (IOException iOException) {
                NLogger.debug(class$phex$chat$ChatEngine == null ? (class$phex$chat$ChatEngine = ChatEngine.class$("phex.chat.ChatEngine")) : class$phex$chat$ChatEngine, (Object)iOException, (Throwable)iOException);
                ChatEngine.this.stopChat();
                return;
            }
        }
    }
}

