/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.collections.SequencedHashMap;
import phex.common.AlternateLocation;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.http.HTTPHeader;
import phex.utils.NLogger;
import phex.xml.sax.share.DAlternateLocation;

public class AltLocContainer {
    public static final int MAX_ALT_LOC_COUNT = 100;
    private static final Object PRESENT;
    private URN urn;
    private SequencedHashMap altLocationMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AltLocContainer(URN uRN) {
        if (uRN == null) {
            throw new NullPointerException("URN must be provided");
        }
        this.urn = uRN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContainer(AltLocContainer altLocContainer) {
        if (altLocContainer.urn == null || !altLocContainer.urn.equals(this.urn)) {
            throw new IllegalArgumentException("Trying to add container with not matching urns");
        }
        if (altLocContainer.altLocationMap == null) {
            return;
        }
        this.initMap();
        SequencedHashMap sequencedHashMap = altLocContainer.altLocationMap;
        synchronized (sequencedHashMap) {
            Iterator iterator = altLocContainer.altLocationMap.keySet().iterator();
            while (iterator.hasNext()) {
                AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                this.addAlternateLocation(alternateLocation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlternateLocation(AlternateLocation alternateLocation) {
        URN uRN = alternateLocation.getURN();
        if (uRN == null || !uRN.equals(this.urn)) {
            NLogger.warn(AltLocContainer.class, (Object)"Cant add alt-location with not matching URN to container.");
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Cant add alt-location with not matching URN to container.");
            }
            return;
        }
        this.initMap();
        SequencedHashMap sequencedHashMap = this.altLocationMap;
        synchronized (sequencedHashMap) {
            this.altLocationMap.put(alternateLocation, PRESENT);
            if (this.altLocationMap.size() > 100) {
                Object object = this.altLocationMap.getFirstKey();
                this.altLocationMap.remove(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlternateLocation(AlternateLocation alternateLocation) {
        URN uRN = alternateLocation.getURN();
        if (uRN == null || !uRN.equals(this.urn)) {
            NLogger.warn(AltLocContainer.class, (Object)"Cant remove alt-location with not matching URN from container.");
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Cant remove alt-location with not matching URN from container.");
            }
            return;
        }
        this.initMap();
        SequencedHashMap sequencedHashMap = this.altLocationMap;
        synchronized (sequencedHashMap) {
            this.altLocationMap.remove(alternateLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAltLocForQueryResponseRecord() {
        if (this.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        SequencedHashMap sequencedHashMap = this.altLocationMap;
        synchronized (sequencedHashMap) {
            Iterator iterator = this.altLocationMap.keySet().iterator();
            HashSet<DestAddress> hashSet = new HashSet<DestAddress>();
            while (iterator.hasNext() && hashSet.size() < 10) {
                AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                DestAddress destAddress = alternateLocation.getHostAddress();
                if (!destAddress.isIpHostName() || !destAddress.isLocalHost()) continue;
                hashSet.add(destAddress);
            }
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPHeader getAltLocHTTPHeaderForAddress(String string, DestAddress destAddress, Set set) {
        if (this.isEmpty()) {
            return null;
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.altLocationMap;
        synchronized (object) {
            Iterator iterator = this.altLocationMap.keySet().iterator();
            while (iterator.hasNext()) {
                AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                if (destAddress.getHostName().equals(alternateLocation.getHostAddress().getHostName()) || set.contains(alternateLocation)) continue;
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(alternateLocation.getHTTPString());
                set.add(alternateLocation);
                if (++n != 10) continue;
            }
        }
        if (stringBuffer.length() > 0) {
            object = new HTTPHeader(string, stringBuffer.toString());
            return object;
        }
        return null;
    }

    public synchronized int getSize() {
        if (this.altLocationMap == null) {
            return 0;
        }
        return this.altLocationMap.size();
    }

    public synchronized boolean isEmpty() {
        if (this.altLocationMap == null) {
            return true;
        }
        return this.altLocationMap.isEmpty();
    }

    public synchronized void createDAlternateLocationList(List list) {
        if (this.altLocationMap == null) {
            return;
        }
        Iterator iterator = this.altLocationMap.keySet().iterator();
        while (iterator.hasNext()) {
            AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
            DAlternateLocation dAlternateLocation = new DAlternateLocation();
            dAlternateLocation.setHostAddress(alternateLocation.getHostAddress().getFullHostName());
            dAlternateLocation.setUrn(alternateLocation.getURN().getAsString());
            list.add(dAlternateLocation);
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Alt-Locations(SHA1: ");
        stringBuffer.append(this.urn.getAsString());
        stringBuffer.append(")=[ ");
        if (this.altLocationMap != null) {
            Iterator iterator = this.altLocationMap.keySet().iterator();
            while (iterator.hasNext()) {
                AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                stringBuffer.append(alternateLocation.toString());
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    private void initMap() {
        if (this.altLocationMap == null) {
            this.altLocationMap = new SequencedHashMap();
        }
    }

    public static List parseUriResAltLocFromHeaders(HTTPHeader[] hTTPHeaderArray) {
        if (hTTPHeaderArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<AlternateLocation> arrayList = new ArrayList<AlternateLocation>();
        for (int i = 0; i < hTTPHeaderArray.length; ++i) {
            HTTPHeader hTTPHeader = hTTPHeaderArray[i];
            StringTokenizer stringTokenizer = new StringTokenizer(hTTPHeader.getValue(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    String string = stringTokenizer.nextToken().trim();
                    AlternateLocation alternateLocation = AlternateLocation.parseUriResAltLoc(string);
                    if (alternateLocation == null) continue;
                    arrayList.add(alternateLocation);
                }
                catch (Exception exception) {
                    NLogger.error("GLOBAL", (Object)exception, (Throwable)exception);
                }
            }
        }
        return arrayList;
    }

    public static List parseCompactIpAltLocFromHeaders(HTTPHeader[] hTTPHeaderArray, URN uRN) {
        if (hTTPHeaderArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<AlternateLocation> arrayList = new ArrayList<AlternateLocation>();
        for (int i = 0; i < hTTPHeaderArray.length; ++i) {
            HTTPHeader hTTPHeader = hTTPHeaderArray[i];
            StringTokenizer stringTokenizer = new StringTokenizer(hTTPHeader.getValue(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    String string = stringTokenizer.nextToken().trim();
                    AlternateLocation alternateLocation = AlternateLocation.parseCompactIpAltLoc(string, uRN);
                    if (alternateLocation == null) continue;
                    arrayList.add(alternateLocation);
                }
                catch (Exception exception) {
                    NLogger.error("GLOBAL", (Object)exception, (Throwable)exception);
                }
            }
        }
        return arrayList;
    }

    static {
        $assertionsDisabled = !AltLocContainer.class.desiredAssertionStatus();
        PRESENT = new Object();
    }
}

