/*
 * Decompiled with CFR 0.152.
 */
package phex.common.address;

import java.util.Arrays;
import phex.common.Ip2CountryManager;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.utils.IOUtil;

public class IpAddress {
    public static final byte CLASS_A = 1;
    public static final byte CLASS_B = 2;
    public static final byte CLASS_C = 3;
    public static final byte[] LOCAL_HOST_IP = new byte[]{127, 0, 0, 1};
    public static final byte[] UNSET_IP = new byte[]{0, 0, 0, 0};
    public static final String LOCAL_HOST_NAME = "127.0.0.1";
    public static final int DEFAULT_PORT = 6346;
    private int hash = 0;
    private byte[] hostIP;
    public String countryCode;

    public IpAddress(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Ip is null");
        }
        this.hostIP = byArray;
    }

    public byte[] getHostIP() {
        return this.hostIP;
    }

    public String getFormatedString() {
        return AddressUtils.ip2string(this.hostIP);
    }

    public long getLongHostIP() {
        int n = this.hostIP[3] & 0xFF;
        int n2 = this.hostIP[2] << 8 & 0xFF00;
        int n3 = this.hostIP[1] << 16 & 0xFF0000;
        int n4 = this.hostIP[0] << 24;
        long l = (long)(n4 | n3 | n2 | n) & 0xFFFFFFFFL;
        return l;
    }

    public boolean equals(IpAddress ipAddress) {
        if (ipAddress == null) {
            return false;
        }
        return Arrays.equals(this.hostIP, ipAddress.hostIP);
    }

    public boolean equals(Object object) {
        if (object instanceof IpAddress) {
            return this.equals((IpAddress)object);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int n;
            this.hash = n = IOUtil.deserializeInt(this.hostIP, 0);
        }
        return this.hash;
    }

    public String getCountryCode() {
        if (this.countryCode == null) {
            this.countryCode = Ip2CountryManager.getInstance().getCountryCode(this);
        }
        return this.countryCode;
    }

    public boolean isLocalAddress() {
        DestAddress destAddress = NetworkManager.getInstance().getLocalAddress();
        if (this.hostIP[0] == 127) {
            return true;
        }
        return destAddress.getIpAddress().equals(this);
    }

    public boolean isSiteLocalIP() {
        if (this.hostIP[0] == 10 || this.hostIP[0] == 127) {
            return true;
        }
        if (this.hostIP[0] == -84 && this.hostIP[1] >= 16 && this.hostIP[1] <= 31) {
            return true;
        }
        return this.hostIP[0] == -64 && this.hostIP[1] == -88;
    }

    public boolean isValidIP() {
        boolean bl;
        byte by = this.getIPClass();
        switch (by) {
            case 1: {
                bl = (this.hostIP[1] & 0xFF) + (this.hostIP[2] & 0xFF) + (this.hostIP[3] & 0xFF) != 0;
                break;
            }
            case 2: {
                bl = (this.hostIP[2] & 0xFF) + (this.hostIP[3] & 0xFF) != 0;
                break;
            }
            case 3: {
                bl = (this.hostIP[3] & 0xFF) != 0;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public byte getIPClass() {
        if ((this.hostIP[0] & 0x80) == 0) {
            return 1;
        }
        if ((this.hostIP[0] & 0xC0) == 128) {
            return 2;
        }
        if ((this.hostIP[0] & 0xE0) == 192) {
            return 3;
        }
        return -1;
    }

    public String toString() {
        return AddressUtils.ip2string(this.hostIP);
    }
}

