/*
 * Decompiled with CFR 0.152.
 */
package phex.common.bandwidth;

import phex.common.bandwidth.TransferAverage;
import phex.utils.NLogger;

public class BandwidthController {
    private static final int WINDOWS_PER_SECONDS = 5;
    private static final int MILLIS_PER_WINDOW = 200;
    private int bytesPerWindow;
    private int bytesRemaining;
    private long lastWindowTime;
    private long throttlingRate;
    private final String controllerName;
    private BandwidthController nextContollerInChain = null;
    private TransferAverage shortTransferAvg;
    private TransferAverage longTransferAvg;

    private BandwidthController(String string, long l) {
        this.controllerName = string + " " + Integer.toHexString(this.hashCode());
        this.setThrottlingRate(l);
        this.bytesRemaining = this.bytesPerWindow;
    }

    public synchronized void activateShortTransferAvg(int n, int n2) {
        this.shortTransferAvg = new TransferAverage(n, n2);
    }

    public synchronized void activateLongTransferAvg(int n, int n2) {
        this.longTransferAvg = new TransferAverage(n, n2);
    }

    public TransferAverage getShortTransferAvg() {
        return this.shortTransferAvg;
    }

    public TransferAverage getLongTransferAvg() {
        return this.longTransferAvg;
    }

    public synchronized BandwidthController linkControllerIntoChain(BandwidthController bandwidthController) {
        BandwidthController bandwidthController2 = this.nextContollerInChain;
        this.nextContollerInChain = bandwidthController;
        return bandwidthController2;
    }

    public synchronized void setThrottlingRate(long l) {
        this.throttlingRate = l;
        this.bytesPerWindow = (int)((double)this.throttlingRate / 5.0);
        if (NLogger.isDebugEnabled("BANDWIDTH")) {
            NLogger.debug("BANDWIDTH", (Object)("[" + this.controllerName + "] Set throttling rate to " + l + "bps (" + this.bytesPerWindow + " per window)"));
        }
        this.bytesRemaining = Math.min(this.bytesRemaining, this.bytesPerWindow);
    }

    public long getThrottlingRate() {
        return this.throttlingRate;
    }

    public synchronized int getAvailableByteCount(boolean bl) {
        this.updateWindow(bl);
        int n = this.bytesRemaining;
        if (this.nextContollerInChain != null) {
            n = Math.min(n, this.nextContollerInChain.getAvailableByteCount(bl));
        }
        if (NLogger.isDebugEnabled("BANDWIDTH")) {
            NLogger.debug("BANDWIDTH", (Object)("[" + this.controllerName + "] Available byte count " + n + "bps - Remaining: " + this.bytesRemaining + "."));
        }
        return n;
    }

    public synchronized int getAvailableByteCount(int n, boolean bl) {
        return Math.min(n, this.getAvailableByteCount(bl));
    }

    public synchronized void markBytesUsed(int n) {
        this.updateWindow(false);
        this.bytesRemaining -= n;
        if (this.bytesRemaining < 0) {
            this.updateWindow(true);
        }
        if (NLogger.isDebugEnabled("BANDWIDTH")) {
            NLogger.debug("BANDWIDTH", (Object)("[" + this.controllerName + "] Mark bytes used " + n + " - remaining: " + this.bytesRemaining + "."));
        }
        if (this.shortTransferAvg != null) {
            this.shortTransferAvg.addValue(n);
        }
        if (this.longTransferAvg != null) {
            this.longTransferAvg.addValue(n);
        }
        if (this.nextContollerInChain != null) {
            this.nextContollerInChain.markBytesUsed(n);
        }
    }

    private void updateWindow(boolean bl) {
        boolean bl2 = false;
        while (true) {
            long l;
            long l2;
            if ((l2 = (l = System.currentTimeMillis()) - this.lastWindowTime) >= 200L) {
                this.bytesRemaining = this.bytesRemaining < 0 ? (this.bytesRemaining += this.bytesPerWindow) : this.bytesPerWindow;
                this.lastWindowTime = l;
                if (NLogger.isDebugEnabled("BANDWIDTH")) {
                    NLogger.debug("BANDWIDTH", (Object)("[" + this.controllerName + "] Update new Window " + this.bytesPerWindow + " - Remaining: " + this.bytesRemaining + "."));
                }
            }
            if (!bl || this.bytesRemaining > 0) break;
            try {
                Thread.sleep(Math.max(200L - l2, 0L));
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            Thread.currentThread().interrupt();
        }
    }

    public String getName() {
        return this.controllerName;
    }

    public String toDebugString() {
        return "ThrottleController[Name:" + this.controllerName + ",bytesPerWindow:" + this.bytesPerWindow + ",bytesRemaining:" + this.bytesRemaining;
    }

    public static BandwidthController acquireBandwidthController(String string, long l) {
        return new BandwidthController(string, l);
    }

    public static void releaseController(BandwidthController bandwidthController) {
        bandwidthController.nextContollerInChain = null;
    }
}

