/*
 * Decompiled with CFR 0.152.
 */
package phex.common.bandwidth;

public class TransferAverage {
    private int refreshRate;
    private int period;
    private long updateTimeFactor;
    private long[] values;

    public TransferAverage(int n, int n2) {
        if (n2 * 1000 < n) {
            throw new IllegalArgumentException("Invalid period");
        }
        this.refreshRate = n;
        this.period = n2;
        this.updateTimeFactor = System.currentTimeMillis() / (long)n;
        int n3 = n2 * 1000 / n + 2;
        this.values = new long[n3];
    }

    private synchronized void update(long l) {
        if (this.updateTimeFactor < l - (long)this.values.length) {
            this.updateTimeFactor = l - (long)this.values.length - 1L;
        }
        for (long i = this.updateTimeFactor + 1L; i <= l; ++i) {
            this.values[(int)(i % (long)this.values.length)] = 0L;
        }
        this.values[(int)((l + 1L) % (long)this.values.length)] = 0L;
        this.updateTimeFactor = l;
    }

    public void addValue(long l) {
        long l2 = System.currentTimeMillis() / (long)this.refreshRate;
        this.update(l2);
        int n = (int)(l2 % (long)this.values.length);
        this.values[n] = this.values[n] + l;
    }

    public long getAverage() {
        long l = System.currentTimeMillis() / (long)this.refreshRate;
        this.update(l);
        long l2 = 0L;
        for (long i = l + 2L; i < l + (long)this.values.length; ++i) {
            l2 += this.values[(int)(i % (long)this.values.length)];
        }
        return l2 / (long)this.period;
    }

    public String toString() {
        return super.toString() + "Rate: " + this.refreshRate + " Period: " + this.period + " Avg: " + this.getAverage();
    }
}

