/*
 * Decompiled with CFR 0.152.
 */
package phex.common.file;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.utils.DirectByteBuffer;
import phex.utils.DirectByteBufferProvider;
import phex.utils.NLogger;

public class ManagedFileOutputStream
extends OutputStream {
    private DirectByteBuffer buffer;
    private ManagedFile managedFile;
    private long outputPosition;

    public ManagedFileOutputStream(ManagedFile managedFile, long l) {
        this.managedFile = managedFile;
        this.outputPosition = l;
        this.buffer = DirectByteBufferProvider.requestBuffer(65536);
    }

    public void write(int n) throws IOException {
        ByteBuffer byteBuffer = this.buffer.getInternalBuffer();
        if (!byteBuffer.hasRemaining()) {
            this.flush();
        }
        byteBuffer.put((byte)n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        ByteBuffer byteBuffer = this.buffer.getInternalBuffer();
        for (int i = 0; i < n2; i += n3) {
            n3 = Math.min(n2 - i, byteBuffer.remaining());
            byteBuffer.put(byArray, n + i, n3);
            if (byteBuffer.hasRemaining()) continue;
            this.flush();
        }
        if (NLogger.isDebugEnabled(ManagedFileOutputStream.class)) {
            NLogger.debug(ManagedFileOutputStream.class, (Object)("Writen: " + new String(byArray, n, n2)));
        }
    }

    public void flush() throws IOException {
        ByteBuffer byteBuffer = this.buffer.getInternalBuffer();
        byteBuffer.flip();
        try {
            this.managedFile.write(this.buffer, this.outputPosition);
        }
        catch (ManagedFileException managedFileException) {
            IOException iOException = new IOException("ManagedFileException: " + managedFileException.getMessage());
            iOException.initCause(managedFileException);
            throw iOException;
        }
        this.outputPosition += (long)byteBuffer.limit();
        byteBuffer.clear();
        if (NLogger.isDebugEnabled(ManagedFileOutputStream.class)) {
            NLogger.debug(ManagedFileOutputStream.class, (Object)"Flushed");
        }
    }

    public void close() throws IOException {
        this.flush();
        this.buffer.release();
    }
}

