/*
 * Decompiled with CFR 0.152.
 */
package phex.common.log;

import java.util.Collection;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;
import phex.common.log.LogRecord;

public class LogBuffer {
    private UnboundedFifoBuffer buffer;
    private MultiHashMap ownerMap;
    private long totalSize;
    private long maxSize;

    public LogBuffer(long l) {
        this.maxSize = l;
        this.totalSize = 0L;
        this.buffer = new UnboundedFifoBuffer();
        this.ownerMap = new MultiHashMap();
    }

    public void addLogRecord(LogRecord logRecord) {
        int n = logRecord.getSize();
        this.buffer.add(logRecord);
        this.ownerMap.put(logRecord.getOwner(), logRecord);
        this.totalSize += (long)n;
        this.validateBufferSize();
    }

    public Collection getLogRecords(Object object) {
        return this.ownerMap.getCollection(object);
    }

    private void validateBufferSize() {
        while (this.totalSize > this.maxSize) {
            LogRecord logRecord = (LogRecord)this.buffer.remove();
            this.ownerMap.remove(logRecord.getOwner(), logRecord);
            this.totalSize -= (long)logRecord.getSize();
        }
    }

    public long getFillSize() {
        return this.totalSize;
    }

    public long getElementCount() {
        return this.buffer.size();
    }
}

