/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import phex.common.ServiceManager;
import phex.common.address.DestAddress;
import phex.common.bandwidth.BandwidthManager;
import phex.connection.BrowseHostException;
import phex.download.PushHandler;
import phex.http.HTTPHeader;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRequest;
import phex.http.HTTPResponse;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.MessageProcessor;
import phex.msg.MsgHeader;
import phex.msg.MsgManager;
import phex.msg.QueryResponseMsg;
import phex.net.connection.Connection;
import phex.net.connection.OIOSocketFactory;
import phex.net.presentation.SocketFacade;
import phex.query.BrowseHostResults;
import phex.utils.NLogger;

public class BrowseHostConnection {
    private final BrowseHostResults results;
    private final DestAddress address;
    private final GUID hostGUID;

    public BrowseHostConnection(DestAddress destAddress, GUID gUID, BrowseHostResults browseHostResults) {
        this.address = destAddress;
        this.hostGUID = gUID;
        this.results = browseHostResults;
    }

    public void sendBrowseHostRequest() throws IOException, BrowseHostException {
        HTTPResponse hTTPResponse;
        SocketFacade socketFacade;
        block13: {
            NLogger.debug(BrowseHostConnection.class, (Object)("Connection for Browse Host to " + this.address));
            this.results.setBrowseHostStatus((short)1);
            try {
                socketFacade = OIOSocketFactory.connect(this.address, ServiceManager.sCfg.mNetConnectionTimeout);
            }
            catch (IOException iOException) {
                if (this.hostGUID == null) {
                    throw iOException;
                }
                socketFacade = PushHandler.requestSocketViaPush(this.hostGUID, 50484558L);
                if (socketFacade != null) break block13;
                throw new IOException("Push request failed");
            }
        }
        Connection connection = new Connection(socketFacade, BandwidthManager.getInstance().getNetworkBandwidthController());
        HTTPRequest hTTPRequest = new HTTPRequest("GET", "/", true);
        hTTPRequest.addHeader(new HTTPHeader("Host", this.address.getFullHostName()));
        hTTPRequest.addHeader(new HTTPHeader("Accept", "application/x-gnutella-packets"));
        hTTPRequest.addHeader(new HTTPHeader("Content-Length", "0"));
        hTTPRequest.addHeader(new HTTPHeader("Connection", "close"));
        String string = hTTPRequest.buildHTTPRequestString();
        NLogger.debug(BrowseHostConnection.class, (Object)("Sending Browse Host request: " + string));
        connection.write(string.toString().getBytes());
        try {
            hTTPResponse = HTTPProcessor.parseHTTPResponse(connection);
        }
        catch (HTTPMessageException hTTPMessageException) {
            throw new BrowseHostException("Invalid HTTP Response: " + hTTPMessageException.getMessage());
        }
        NLogger.debug(BrowseHostConnection.class, (Object)("Received Browse Host response: " + hTTPResponse.buildHTTPResponseString()));
        if (hTTPResponse.getStatusCode() < 200 || hTTPResponse.getStatusCode() > 299) {
            throw new BrowseHostException("Browse host request not successfull. StatusCode: " + hTTPResponse.getStatusCode() + " " + hTTPResponse.getStatusReason());
        }
        HTTPHeader hTTPHeader = hTTPResponse.getHeader("Content-Type");
        if (hTTPHeader == null) {
            throw new BrowseHostException("Unknwon content-type.");
        }
        if (hTTPHeader.getValue().equals("application/x-gnutella-packets")) {
            MsgHeader msgHeader;
            this.results.setBrowseHostStatus((short)2);
            MsgManager msgManager = MsgManager.getInstance();
            byte[] byArray = new byte[23];
            while ((msgHeader = MessageProcessor.parseMessageHeader(connection, byArray)) != null) {
                if (msgHeader.getPayload() != -127) {
                    throw new BrowseHostException("Wrong header payload. Expecting query hit.");
                }
                QueryResponseMsg queryResponseMsg = null;
                try {
                    queryResponseMsg = (QueryResponseMsg)MessageProcessor.parseMessage(msgHeader, connection);
                }
                catch (InvalidMessageException invalidMessageException) {
                    NLogger.debug(BrowseHostConnection.class, (Object)invalidMessageException, (Throwable)invalidMessageException);
                    throw new IOException("Invalid message returned: " + invalidMessageException.getMessage());
                }
                msgManager.getQueryResultMonitor().processResponse(queryResponseMsg);
                this.results.processResponse(queryResponseMsg);
            }
        } else {
            throw new BrowseHostException("Not supported content-type. " + hTTPHeader.getValue());
        }
    }
}

