/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import phex.common.address.DestAddress;
import phex.connection.ConnectionEngine;
import phex.connection.ConnectionRejectedException;
import phex.connection.NetworkManager;
import phex.host.CaughtHostsContainer;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.net.OnlineObserver;
import phex.utils.NLogger;

public class OutgoingConnectionDispatcher
implements Runnable {
    public DestAddress hostAddress;

    public void setHostAddressToConnect(DestAddress destAddress) {
        this.hostAddress = destAddress;
    }

    public void run() {
        try {
            if (this.hostAddress == null) {
                this.connectToNextCaughtHost();
            } else {
                this.connectToHostAddress();
            }
        }
        catch (Throwable throwable) {
            NLogger.error("OUT_CONNECTION", (Object)throwable, throwable);
        }
    }

    private void connectToHostAddress() {
        NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
        Host host = new Host(this.hostAddress);
        host.setType(Host.TYPE_OUTGOING);
        networkHostsContainer.addNetworkHost(host);
        OnlineObserver onlineObserver = NetworkManager.getInstance().getOnlineObserver();
        try {
            ConnectionEngine connectionEngine = new ConnectionEngine(host);
            connectionEngine.initializeOutgoingConnection();
            connectionEngine.processIncomingData();
        }
        catch (IOException iOException) {
            onlineObserver.markFailedConnection();
            host.setStatus(1, iOException.getMessage());
            HostManager.getInstance().disconnectHost(host);
            NLogger.debug("OUT_CONNECTION", (Object)iOException);
        }
        catch (Exception exception) {
            host.setStatus(1, exception.getMessage());
            HostManager.getInstance().disconnectHost(host);
            NLogger.warn("OUT_CONNECTION", (Object)exception, (Throwable)exception);
        }
    }

    private void connectToNextCaughtHost() {
        DestAddress destAddress;
        NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
        CaughtHostsContainer caughtHostsContainer = HostManager.getInstance().getCaughtHostsContainer();
        do {
            if ((destAddress = caughtHostsContainer.getNextCaughtHost()) != null) continue;
            return;
        } while (networkHostsContainer.isConnectedToHost(destAddress));
        Host host = new Host(destAddress);
        host.setType(Host.TYPE_OUTGOING);
        networkHostsContainer.addNetworkHost(host);
        OnlineObserver onlineObserver = NetworkManager.getInstance().getOnlineObserver();
        ConnectionEngine connectionEngine = new ConnectionEngine(host);
        try {
            connectionEngine.initializeOutgoingConnection();
        }
        catch (ConnectionRejectedException connectionRejectedException) {
            caughtHostsContainer.reportConnectionStatus(destAddress, true);
            host.setStatus(1, connectionRejectedException.getMessage());
            HostManager.getInstance().disconnectHost(host);
            NLogger.debug("OUT_CONNECTION", (Object)connectionRejectedException);
            return;
        }
        catch (IOException iOException) {
            onlineObserver.markFailedConnection();
            caughtHostsContainer.reportConnectionStatus(destAddress, false);
            host.setStatus(1, iOException.getMessage());
            HostManager.getInstance().disconnectHost(host);
            NLogger.debug("OUT_CONNECTION", (Object)iOException);
            return;
        }
        catch (Exception exception) {
            caughtHostsContainer.reportConnectionStatus(destAddress, false);
            host.setStatus(1, exception.getMessage());
            HostManager.getInstance().disconnectHost(host);
            NLogger.warn("OUT_CONNECTION", (Object)exception, (Throwable)exception);
            return;
        }
        caughtHostsContainer.reportConnectionStatus(destAddress, true);
        try {
            connectionEngine.processIncomingData();
        }
        catch (IOException iOException) {
            host.setStatus(1, iOException.getMessage());
            HostManager.getInstance().disconnectHost(host);
            NLogger.debug("OUT_CONNECTION", (Object)iOException);
        }
        catch (Exception exception) {
            host.setStatus(1, exception.getMessage());
            HostManager.getInstance().disconnectHost(host);
            NLogger.warn("OUT_CONNECTION", (Object)exception, (Throwable)exception);
        }
    }
}

