/*
 * Decompiled with CFR 0.152.
 */
package phex.connection.handshake;

import phex.common.ServiceManager;
import phex.connection.ConnectionConstants;
import phex.connection.handshake.HandshakeHandler;
import phex.connection.handshake.HandshakeStatus;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;

public class LeafHandshakeHandler
extends HandshakeHandler
implements ConnectionConstants {
    private HostManager hostMgr = HostManager.getInstance();
    private NetworkHostsContainer hostContainer = this.hostMgr.getNetworkHostsContainer();

    public LeafHandshakeHandler(Host host) {
        super(host);
    }

    protected HTTPHeaderGroup createDefaultHandshakeHeaders() {
        HTTPHeaderGroup hTTPHeaderGroup = super.createDefaultHandshakeHeaders();
        hTTPHeaderGroup.addHeader(new HTTPHeader("X-Ultrapeer", "false"));
        hTTPHeaderGroup.addHeader(new HTTPHeader("X-Query-Routing", "0.1"));
        hTTPHeaderGroup.addHeader(new HTTPHeader("X-Ultrapeer-Query-Routing", "0.1"));
        hTTPHeaderGroup.addHeader(new HTTPHeader("X-Dynamic-Querying", "0.1"));
        hTTPHeaderGroup.addHeader(new HTTPHeader("X-Degree", String.valueOf(ServiceManager.sCfg.up2upConnections)));
        hTTPHeaderGroup.addHeader(new HTTPHeader("X-Max-TTL", String.valueOf(4)));
        return hTTPHeaderGroup;
    }

    public HandshakeStatus createHandshakeResponse(HandshakeStatus handshakeStatus, boolean bl) {
        boolean bl2;
        HTTPHeaderGroup hTTPHeaderGroup = handshakeStatus.getResponseHeaders();
        if (bl && this.isCrawlerConnection(hTTPHeaderGroup)) {
            return this.createCrawlerHandshakeStatus();
        }
        HTTPHeader hTTPHeader = hTTPHeaderGroup.getHeader("X-Ultrapeer");
        boolean bl3 = bl2 = hTTPHeader != null && Boolean.valueOf(hTTPHeader.getValue()) != false;
        if (bl2) {
            this.connectedHost.setConnectionType((byte)1);
        } else {
            this.connectedHost.setConnectionType((byte)0);
            if (!this.areNoneUPConnectionsAllowed()) {
                if (bl) {
                    return new HandshakeStatus(503, "I accept only Ultrapeers");
                }
                return new HandshakeStatus(503, "I accept only Ultrapeers", this.createRejectIncomingHeaders());
            }
            if (!this.hostContainer.hasPeerSlotsAvailable()) {
                if (bl) {
                    return new HandshakeStatus(503, "I am busy.", this.createRejectOutgoingHeaders());
                }
                return new HandshakeStatus(503, "I am busy.", this.createRejectIncomingHeaders());
            }
        }
        if (bl) {
            HTTPHeaderGroup hTTPHeaderGroup2 = new HTTPHeaderGroup(HTTPHeaderGroup.COMMON_HANDSHAKE_GROUP);
            if (handshakeStatus.isDeflateAccepted()) {
                hTTPHeaderGroup2.addHeader(new HTTPHeader("Content-Encoding", "deflate"));
            }
            return new HandshakeStatus(200, "OK", hTTPHeaderGroup2);
        }
        if (this.hostContainer.isShieldedLeafNode()) {
            return new HandshakeStatus(503, "I am a shielded leaf node", this.createRejectIncomingHeaders());
        }
        HTTPHeaderGroup hTTPHeaderGroup3 = this.createDefaultHandshakeHeaders();
        if (handshakeStatus.isDeflateAccepted()) {
            hTTPHeaderGroup3.addHeader(new HTTPHeader("Content-Encoding", "deflate"));
        }
        return new HandshakeStatus(200, "OK", hTTPHeaderGroup3);
    }

    private boolean areNoneUPConnectionsAllowed() {
        return !ServiceManager.sCfg.allowToBecomeLeaf || !ServiceManager.sCfg.forceUPConnections;
    }
}

