/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.httpclient.ChunkedInputStream;
import phex.common.AltLocContainer;
import phex.common.AlternateLocation;
import phex.common.FileHandlingException;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.address.MalformedDestAddressException;
import phex.common.bandwidth.BandwidthController;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.connection.ConnectionFailedException;
import phex.connection.NetworkManager;
import phex.download.DownloadStoppedException;
import phex.download.FileNotAvailableException;
import phex.download.HostBusyException;
import phex.download.RangeUnavailableException;
import phex.download.ReconnectException;
import phex.download.RemotelyQueuedException;
import phex.download.WrongHTTPHeaderException;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSegment;
import phex.host.UnusableHostException;
import phex.http.HTTPHeader;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRangeSet;
import phex.http.HTTPRequest;
import phex.http.HTTPResponse;
import phex.http.HTTPRetryAfter;
import phex.http.XQueueParameters;
import phex.net.connection.Connection;
import phex.net.connection.OIOSocketFactory;
import phex.net.presentation.PresentationManager;
import phex.net.presentation.SocketFacade;
import phex.utils.DirectByteBuffer;
import phex.utils.DirectByteBufferProvider;
import phex.utils.IOUtil;
import phex.utils.LengthLimitedInputStream;
import phex.utils.NLogger;

public class DownloadEngine {
    private static final int BUFFER_LENGTH = 16384;
    private SWDownloadCandidate candidate;
    private SWDownloadSegment segment;
    private SWDownloadFile downloadFile;
    private Connection connection;
    private SocketFacade socket;
    private InputStream inStream;
    private boolean isKeepAliveSupported;
    private boolean isDownloadSuccessful;
    private boolean isDownloadStopped;
    private ContentRange replyContentRange;
    private long replyContentLength;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DownloadEngine(SWDownloadFile sWDownloadFile, SWDownloadCandidate sWDownloadCandidate) {
        this.downloadFile = sWDownloadFile;
        this.candidate = sWDownloadCandidate;
    }

    public void setSocket(SocketFacade socketFacade) throws IOException {
        if (!$assertionsDisabled && this.socket == null) {
            throw new AssertionError();
        }
        this.socket = socketFacade;
        this.prepareConnection();
    }

    public void connect(int n) throws IOException {
        if (!$assertionsDisabled && this.socket != null) {
            throw new AssertionError();
        }
        DestAddress destAddress = this.candidate.getHostAddress();
        try {
            this.candidate.addToCandidateLog("Wait for connect slot " + destAddress.getHostName() + ":" + destAddress.getPort());
            NLogger.debug("Download.Engine", (Object)("Wait for connect slot " + destAddress.getHostName() + ":" + destAddress.getPort()));
            Runnable runnable = new Runnable(){

                public void run() {
                    DestAddress destAddress = DownloadEngine.this.candidate.getHostAddress();
                    DownloadEngine.this.candidate.addToCandidateLog("Connecting to " + destAddress.getHostName() + ":" + destAddress.getPort());
                    NLogger.debug("Download.Engine", (Object)("Connecting to " + destAddress.getHostName() + ":" + destAddress.getPort()));
                    DownloadEngine.this.candidate.setStatus((short)16);
                }
            };
            this.socket = OIOSocketFactory.connect(destAddress, n, runnable);
        }
        catch (SocketException socketException) {
            throw new ConnectionFailedException(socketException.getMessage());
        }
        this.prepareConnection();
    }

    private void prepareConnection() throws IOException {
        BandwidthController bandwidthController = this.downloadFile.getBandwidthController();
        this.connection = new Connection(this.socket, bandwidthController);
        this.candidate.addToCandidateLog("Connected successfully to " + this.candidate.getHostAddress() + ".");
        this.candidate.setLastConnectionTime(System.currentTimeMillis());
        NLogger.debug("Download.Engine", (Object)("Download Engine @" + Integer.toHexString(this.hashCode()) + " connected successfully to " + this.candidate.getHostAddress() + "."));
        if (this.isDownloadStopped) {
            throw new DownloadStoppedException();
        }
    }

    public void exchangeHTTPHandshake(SWDownloadSegment sWDownloadSegment) throws IOException, UnusableHostException, HTTPMessageException {
        Object object;
        Object object2;
        Object object3;
        HTTPHeader hTTPHeader;
        Object object4;
        Object object5;
        NetworkManager networkManager = NetworkManager.getInstance();
        this.isDownloadSuccessful = false;
        this.segment = sWDownloadSegment;
        long l = this.segment.getTransferStartPosition();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.connection.getOutputStream());
        this.inStream = this.connection.getInputStream();
        String string = this.candidate.getDownloadRequestUrl();
        HTTPRequest hTTPRequest = new HTTPRequest("GET", string, true);
        hTTPRequest.addHeader(new HTTPHeader("Host", this.candidate.getHostAddress().getFullHostName()));
        hTTPRequest.addHeader(new HTTPHeader("Listen-IP", networkManager.getLocalAddress().getFullHostName()));
        long l2 = this.segment.getEnd();
        if (l2 == -1L) {
            hTTPRequest.addHeader(new HTTPHeader("Range", "bytes=" + l + "-"));
        } else {
            hTTPRequest.addHeader(new HTTPHeader("Range", "bytes=" + l + "-" + l2));
        }
        hTTPRequest.addHeader(new HTTPHeader("X-Queue", "0.1"));
        hTTPRequest.addHeader(new HTTPHeader("Connection", "Keep-Alive"));
        if (this.candidate.isG2FeatureAdded()) {
            hTTPRequest.addHeader(new HTTPHeader("X-Features", "g2/1.0"));
        }
        this.buildAltLocRequestHeader(hTTPRequest);
        if (ServiceManager.sCfg.isChatEnabled && ((object5 = (object4 = networkManager.getLocalAddress()).getIpAddress()) == null || !((IpAddress)object5).isSiteLocalIP())) {
            hTTPRequest.addHeader(new HTTPHeader("Chat", object4.getFullHostName()));
        }
        object4 = hTTPRequest.buildHTTPRequestString();
        NLogger.debug("Download.Engine", (Object)("HTTP Request to: " + this.candidate.getHostAddress() + "\n" + (String)object4));
        this.candidate.addToCandidateLog("HTTP Request:\n" + (String)object4);
        outputStreamWriter.write((String)object4);
        outputStreamWriter.flush();
        object5 = HTTPProcessor.parseHTTPResponse(this.connection);
        if (NLogger.isDebugEnabled("Download.Engine")) {
            NLogger.debug("Download.Engine", (Object)("HTTP Response from: " + this.candidate.getHostAddress() + "\n" + ((HTTPResponse)object5).buildHTTPResponseString()));
        }
        if (ServiceManager.sCfg.downloadCandidateLogBufferSize > 0L) {
            this.candidate.addToCandidateLog("HTTP Response:\n" + ((HTTPResponse)object5).buildHTTPResponseString());
        }
        if ((hTTPHeader = ((HTTPResponse)object5).getHeader("Server")) != null) {
            this.candidate.setVendor(hTTPHeader.getValue());
        }
        if ((hTTPHeader = ((HTTPResponse)object5).getHeader("Transfer-Encoding")) != null && hTTPHeader.getValue().equals("chunked")) {
            this.inStream = new ChunkedInputStream((InputStream)this.connection.getInputStream());
        }
        this.replyContentRange = null;
        hTTPHeader = ((HTTPResponse)object5).getHeader("Content-Range");
        if (hTTPHeader != null) {
            this.replyContentRange = this.parseContentRange(hTTPHeader.getValue());
            if (this.replyContentRange.startPos != -1L && this.replyContentRange.startPos != l) {
                throw new IOException("Invalid 'CONTENT-RANGE' start offset.");
            }
        }
        this.replyContentLength = -1L;
        hTTPHeader = ((HTTPResponse)object5).getHeader("Content-Length");
        if (hTTPHeader != null) {
            try {
                this.replyContentLength = hTTPHeader.longValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        URN uRN = this.downloadFile.getFileURN();
        ArrayList<HTTPHeader> arrayList = new ArrayList<HTTPHeader>();
        hTTPHeader = ((HTTPResponse)object5).getHeader("X-Gnutella-Content-URN");
        if (hTTPHeader != null) {
            arrayList.add(hTTPHeader);
        }
        Object[] objectArray = ((HTTPResponse)object5).getHeaders("X-Content-URN");
        CollectionUtils.addAll(arrayList, objectArray);
        if (uRN != null) {
            object3 = arrayList.iterator();
            while (object3.hasNext()) {
                hTTPHeader = (HTTPHeader)object3.next();
                object2 = hTTPHeader.getValue();
                if (!URN.isValidURN((String)object2) || uRN.equals((URN)(object = new URN((String)object2)))) continue;
                throw new IOException("Required URN and content URN do not match.");
            }
        }
        if ((hTTPHeader = ((HTTPResponse)object5).getHeader("Chat")) != null) {
            this.candidate.setChatSupported(true);
        }
        if ((hTTPHeader = ((HTTPResponse)object5).getHeader("Remote-IP")) != null && (object3 = (Object)AddressUtils.parseIP(hTTPHeader.getValue())) != null) {
            object2 = new IpAddress((byte[])object3);
            object = PresentationManager.getInstance().createHostAddress((IpAddress)object2, -1);
            networkManager.updateLocalAddress((DestAddress)object);
        }
        int n = ((HTTPResponse)object5).getStatusCode();
        hTTPHeader = ((HTTPResponse)object5).getHeader("X-Available-Ranges");
        if (hTTPHeader != null) {
            object2 = HTTPRangeSet.parseHTTPRangeSet(hTTPHeader.getValue(), false);
            if (object2 == null) {
                NLogger.error("Download.Engine", "Failed to parse X-Available-Ranges in " + this.candidate.getVendor() + " request: " + ((HTTPResponse)object5).buildHTTPResponseString());
            }
            this.candidate.setAvailableRangeSet((HTTPRangeSet)object2);
        } else if (n >= 200 && n < 300 && this.downloadFile.getTotalDataSize() != -1L) {
            this.candidate.setAvailableRangeSet(new HTTPRangeSet(0L, this.downloadFile.getTotalDataSize() - 1L));
        }
        object2 = new ArrayList();
        objectArray = ((HTTPResponse)object5).getHeaders("Alt-Location");
        object = AltLocContainer.parseUriResAltLocFromHeaders((HTTPHeader[])objectArray);
        object2.addAll(object);
        objectArray = ((HTTPResponse)object5).getHeaders("X-Gnutella-Alternate-Location");
        object = AltLocContainer.parseUriResAltLocFromHeaders((HTTPHeader[])objectArray);
        object2.addAll(object);
        objectArray = ((HTTPResponse)object5).getHeaders("X-Alt");
        object = AltLocContainer.parseCompactIpAltLocFromHeaders((HTTPHeader[])objectArray, uRN);
        object2.addAll(object);
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            this.downloadFile.addDownloadCandidate((AlternateLocation)iterator.next());
        }
        objectArray = ((HTTPResponse)object5).getHeaders("X-Pushproxies");
        this.handlePushProxyHeaders((HTTPHeader[])objectArray);
        objectArray = ((HTTPResponse)object5).getHeaders("X-Push-Proxies");
        this.handlePushProxyHeaders((HTTPHeader[])objectArray);
        objectArray = ((HTTPResponse)object5).getHeaders("X-Push-Proxy");
        this.handlePushProxyHeaders((HTTPHeader[])objectArray);
        this.updateKeepAliveSupport((HTTPResponse)object5);
        if (n >= 200 && n < 300) {
            if (arrayList.size() == 0 && string.startsWith("/uri-res/N2R?")) {
                throw new IOException("Response to uri-res request without valid Content-URN header.");
            }
            if (this.downloadFile.getTotalDataSize() == -1L) {
                if (!$assertionsDisabled && this.segment.getTotalDataSize() != -1L) {
                    throw new AssertionError();
                }
                if (this.replyContentRange != null && this.replyContentRange.totalLength != -1L) {
                    this.downloadFile.setFileSize(this.replyContentRange.totalLength);
                    this.stopDownload();
                    throw new ReconnectException();
                }
            }
            NLogger.debug("Download.Engine", (Object)"HTTP Handshake successfull.");
            return;
        }
        if (n == 503) {
            int n2;
            hTTPHeader = ((HTTPResponse)object5).getHeader("X-Queue");
            XQueueParameters xQueueParameters = null;
            if (hTTPHeader != null) {
                xQueueParameters = XQueueParameters.parseHTTPRangeSet(hTTPHeader.getValue());
            }
            if (xQueueParameters != null && this.isKeepAliveSupported) {
                throw new RemotelyQueuedException(xQueueParameters);
            }
            hTTPHeader = ((HTTPResponse)object5).getHeader("Retry-After");
            if (hTTPHeader != null && (n2 = HTTPRetryAfter.parseDeltaInSeconds(hTTPHeader)) > 0) {
                throw new HostBusyException(n2);
            }
            throw new HostBusyException();
        }
        if (n == 401 || n == 403) {
            if ("Network Disabled".equals(((HTTPResponse)object5).getStatusReason())) {
                if (this.candidate.isG2FeatureAdded()) {
                    throw new UnusableHostException("Request Forbidden");
                }
                this.candidate.setG2FeatureAdded(true);
                throw new HostBusyException(300);
            }
            throw new UnusableHostException("Request Forbidden");
        }
        if (n == 408) {
            throw new HostBusyException();
        }
        if (n == 404 || n == 410) {
            throw new FileNotAvailableException();
        }
        if (n == 416) {
            int n3;
            hTTPHeader = ((HTTPResponse)object5).getHeader("Retry-After");
            if (hTTPHeader != null && (n3 = HTTPRetryAfter.parseDeltaInSeconds(hTTPHeader)) > 0) {
                throw new RangeUnavailableException(n3);
            }
            throw new RangeUnavailableException();
        }
        throw new IOException("Unknown HTTP code: " + n);
    }

    private void buildAltLocRequestHeader(HTTPRequest hTTPRequest) {
        Object object;
        IpAddress ipAddress;
        URN uRN = this.downloadFile.getFileURN();
        if (uRN == null) {
            return;
        }
        AltLocContainer altLocContainer = new AltLocContainer(uRN);
        altLocContainer.addContainer(this.downloadFile.getGoodAltLocContainer());
        if (ServiceManager.sCfg.arePartialFilesShared && NetworkManager.getInstance().hasConnectedIncoming() && ((ipAddress = (object = NetworkManager.getInstance().getLocalAddress()).getIpAddress()) == null || !ipAddress.isSiteLocalIP())) {
            AlternateLocation alternateLocation = new AlternateLocation((DestAddress)object, uRN);
            altLocContainer.addAlternateLocation(alternateLocation);
        }
        if ((object = altLocContainer.getAltLocHTTPHeaderForAddress("X-Alt", this.candidate.getHostAddress(), this.candidate.getSendAltLocsSet())) != null) {
            hTTPRequest.addHeader((HTTPHeader)object);
        }
        if ((object = (altLocContainer = this.downloadFile.getBadAltLocContainer()).getAltLocHTTPHeaderForAddress("X-NAlt", this.candidate.getHostAddress(), this.candidate.getSendAltLocsSet())) != null) {
            hTTPRequest.addHeader((HTTPHeader)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startDownload() throws IOException {
        block23: {
            NLogger.debug("Download.Engine", (Object)"Download Engine starts download.");
            DirectByteBuffer directByteBuffer = null;
            LengthLimitedInputStream lengthLimitedInputStream = null;
            try {
                try {
                    int n;
                    long l;
                    ManagedFile managedFile = this.downloadFile.getIncompleteDownloadFile();
                    directByteBuffer = DirectByteBufferProvider.requestBuffer(65536);
                    this.segment.downloadStartNotify();
                    String string = this.segment.toString();
                    long l2 = Long.MAX_VALUE;
                    if (this.replyContentRange != null && this.replyContentRange.totalLength != -1L) {
                        l2 = this.replyContentRange.totalLength;
                    }
                    if (this.replyContentLength != -1L) {
                        l2 = Math.min(this.replyContentLength, l2);
                    }
                    if ((l = this.segment.getTransferDataSizeLeft()) != -1L) {
                        l2 = Math.min(l, l2);
                    }
                    lengthLimitedInputStream = new LengthLimitedInputStream(this.inStream, l2);
                    long l3 = this.segment.getStart() + this.segment.getTransferredDataSize();
                    long l4 = this.segment.getTransferredDataSize();
                    byte[] byArray = new byte[16384];
                    while ((n = lengthLimitedInputStream.read(byArray, 0, 16384)) > 0) {
                        SWDownloadSegment sWDownloadSegment = this.segment;
                        synchronized (sWDownloadSegment) {
                            long l5 = l4 + (long)n;
                            if (l5 < this.segment.getTransferredDataSize()) {
                                NLogger.error("Download.Engine", "TransferredDataSize would be going down!  ll " + l2 + " l " + n + " ld " + l4 + " gtds " + this.segment.getTransferredDataSize() + " seg: " + this.segment + " originally: " + string);
                                throw new IOException("TransferredDataSize would be going down!");
                            }
                            if (this.segment.getTransferDataSize() > -1L && l5 > this.segment.getTransferDataSize()) {
                                NLogger.error("Download.Engine", "TransferredDataSize would be larger then segment!  ll " + l2 + " l " + n + " ld " + l4 + " gtds " + this.segment.getTransferredDataSize() + " seg: " + this.segment + " originally: " + string);
                                throw new IOException("TransferredDataSize would be larger then segment!");
                            }
                            directByteBuffer.put(byArray, 0, n);
                            directByteBuffer.flip();
                            managedFile.write(directByteBuffer, l3);
                            l3 += (long)directByteBuffer.limit();
                            directByteBuffer.clear();
                            this.segment.setTransferredDataSize(l4 += (long)n);
                            this.candidate.incTotalDownloadSize(n);
                            l = this.segment.getTransferDataSizeLeft();
                            if (l != -1L) {
                                l2 = Math.min(l, l2);
                                lengthLimitedInputStream.setLengthLimit(l2);
                            }
                        }
                    }
                    this.isDownloadSuccessful = true;
                    if (this.downloadFile.getTotalDataSize() == -1L) {
                        if (!$assertionsDisabled && this.segment.getTotalDataSize() != -1L) {
                            throw new AssertionError();
                        }
                        this.downloadFile.setFileSize(this.segment.getTransferredDataSize());
                    }
                }
                catch (FileHandlingException fileHandlingException) {
                    NLogger.error("Download.Engine", (Object)fileHandlingException, (Throwable)fileHandlingException);
                    IOException iOException = new IOException(fileHandlingException.getMessage());
                    iOException.initCause(fileHandlingException);
                    throw iOException;
                }
                catch (ManagedFileException managedFileException) {
                    if (!Thread.currentThread().isInterrupted()) {
                        NLogger.error("Download.Engine", (Object)managedFileException, (Throwable)managedFileException);
                        IOException iOException = new IOException(managedFileException.getMessage());
                        iOException.initCause(managedFileException);
                        throw iOException;
                    }
                    Object var20_18 = null;
                    if (directByteBuffer != null) {
                        directByteBuffer.release();
                    }
                    boolean bl = this.isAcceptingNextSegment();
                    this.candidate.addToCandidateLog("Is accepting next segment: " + bl);
                    if (bl) {
                        lengthLimitedInputStream.close();
                        return;
                    }
                    this.stopDownload();
                    return;
                }
                Object var20_17 = null;
                if (directByteBuffer != null) {
                    directByteBuffer.release();
                }
                boolean bl = this.isAcceptingNextSegment();
                this.candidate.addToCandidateLog("Is accepting next segment: " + bl);
                if (!bl) break block23;
            }
            catch (Throwable throwable) {
                Object var20_19 = null;
                if (directByteBuffer != null) {
                    directByteBuffer.release();
                }
                boolean bl = this.isAcceptingNextSegment();
                this.candidate.addToCandidateLog("Is accepting next segment: " + bl);
                if (bl) {
                    lengthLimitedInputStream.close();
                    throw throwable;
                }
                this.stopDownload();
                throw throwable;
            }
            lengthLimitedInputStream.close();
            return;
        }
        this.stopDownload();
    }

    public void stopDownload() {
        NLogger.debug("Download.Engine", (Object)"Closing pipe and socket and telling segment we've stopped.");
        this.isDownloadStopped = true;
        this.candidate.addToCandidateLog("Stop download.");
        IOUtil.closeQuietly(this.inStream);
        if (this.segment != null) {
            this.segment.downloadStopNotify();
        }
        if (this.connection != null) {
            this.connection.disconnect();
        }
        IOUtil.closeQuietly(this.socket);
    }

    public boolean isAcceptingNextSegment() {
        return this.isDownloadSuccessful && this.isKeepAliveSupported && this.replyContentLength != -1L;
    }

    private ContentRange parseContentRange(String string) throws WrongHTTPHeaderException {
        try {
            long l;
            ContentRange contentRange = new ContentRange();
            string = string.toLowerCase();
            int n = string.indexOf("bytes") + 6;
            String string2 = string.substring(n).trim();
            int n2 = string2.indexOf(47);
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            contentRange.totalLength = string4.charAt(0) == '*' ? -1L : (l = Long.parseLong(string4));
            if (string3.charAt(0) == '*') {
                contentRange.startPos = -1L;
                contentRange.endPos = contentRange.totalLength;
            } else {
                int n3 = string2.indexOf(45);
                String string5 = string3.substring(0, n3);
                long l2 = Long.parseLong(string5);
                String string6 = string3.substring(n3 + 1);
                long l3 = Long.parseLong(string6);
                contentRange.startPos = l2;
                contentRange.endPos = l3;
            }
            return contentRange;
        }
        catch (NumberFormatException numberFormatException) {
            NLogger.warn("Download.Engine", (Object)numberFormatException, (Throwable)numberFormatException);
            throw new WrongHTTPHeaderException("Number error while parsing content range: " + string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new WrongHTTPHeaderException("Error while parsing content range: " + string);
        }
    }

    private void updateKeepAliveSupport(HTTPResponse hTTPResponse) {
        HTTPHeader hTTPHeader = hTTPResponse.getHeader("Connection");
        if (hTTPHeader != null) {
            if (hTTPHeader.getValue().equalsIgnoreCase("close")) {
                this.isKeepAliveSupported = false;
                return;
            }
            if (hTTPHeader.getValue().equalsIgnoreCase("keep-alive")) {
                this.isKeepAliveSupported = true;
                return;
            }
        }
        this.isKeepAliveSupported = hTTPResponse.getHTTPVersion().equals("HTTP/1.1");
    }

    public void handlePushProxyHeaders(HTTPHeader[] hTTPHeaderArray) {
        if (hTTPHeaderArray == null || hTTPHeaderArray.length == 0) {
            return;
        }
        ArrayList<DestAddress> arrayList = new ArrayList<DestAddress>();
        for (int i = 0; i < hTTPHeaderArray.length; ++i) {
            HTTPHeader hTTPHeader = hTTPHeaderArray[i];
            StringTokenizer stringTokenizer = new StringTokenizer(hTTPHeader.getValue(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().trim();
                try {
                    DestAddress destAddress = AddressUtils.parseAndValidateAddress(string, false);
                    arrayList.add(destAddress);
                }
                catch (MalformedDestAddressException malformedDestAddressException) {
                    NLogger.debug("Download.Engine", (Object)("Malformed alt-location URL: " + malformedDestAddressException.getMessage()));
                }
            }
        }
        if (arrayList.size() == 0) {
            return;
        }
        DestAddress[] destAddressArray = new DestAddress[arrayList.size()];
        arrayList.toArray(destAddressArray);
        this.candidate.setPushProxyAddresses(destAddressArray);
    }

    static {
        $assertionsDisabled = !DownloadEngine.class.desiredAssertionStatus();
    }

    private class ContentRange {
        long startPos;
        long endPos;
        long totalLength;

        private ContentRange() {
        }
    }
}

