/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.URN;
import phex.utils.URLCodecUtils;

public class MagnetData {
    private String exactTopic;
    private String exactSubstitute;
    private List acceptableSubstituteList = new ArrayList();
    private String displayName;
    private String keywordTopic;

    private MagnetData() {
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getKeywordTopic() {
        return this.keywordTopic;
    }

    public void setKeywordTopic(String string) {
        this.keywordTopic = string;
    }

    public String getExactSubstitute() {
        return this.exactSubstitute;
    }

    public void setExactSubstitute(String string) {
        this.exactSubstitute = string;
    }

    public List getAcceptableSubstituteList() {
        return this.acceptableSubstituteList;
    }

    private void addAcceptableSubstitute(String string) {
        this.acceptableSubstituteList.add(string);
    }

    public String getExactTopic() {
        return this.exactTopic;
    }

    public void setExactTopic(String string) {
        this.exactTopic = string;
    }

    public static String lookupFileName(MagnetData magnetData) {
        if (magnetData.displayName != null) {
            return magnetData.displayName;
        }
        if (magnetData.keywordTopic != null) {
            return magnetData.keywordTopic;
        }
        URN uRN = MagnetData.lookupSHA1URN(magnetData);
        if (uRN != null) {
            return "Magnet download " + uRN.getAsString();
        }
        return "Unknown Magnet download";
    }

    public static String lookupSearchName(MagnetData magnetData) {
        if (magnetData.keywordTopic != null) {
            return magnetData.keywordTopic;
        }
        if (magnetData.displayName != null) {
            return magnetData.displayName;
        }
        return "";
    }

    public static URN lookupSHA1URN(MagnetData magnetData) {
        if (magnetData.exactTopic != null && URN.isValidURN(magnetData.exactTopic)) {
            return new URN(magnetData.exactTopic);
        }
        if (magnetData.exactSubstitute != null && URN.isValidURN(magnetData.exactSubstitute)) {
            return new URN(magnetData.exactSubstitute);
        }
        Iterator iterator = magnetData.acceptableSubstituteList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!URN.isValidURN(string)) continue;
            return new URN(string);
        }
        return null;
    }

    public static List lookupHttpURIs(MagnetData magnetData) {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        if (magnetData.exactTopic != null && magnetData.exactTopic.startsWith("http://")) {
            try {
                arrayList.add(new URI(magnetData.exactTopic, false));
            }
            catch (URIException uRIException) {
                // empty catch block
            }
        }
        if (magnetData.exactSubstitute != null && magnetData.exactSubstitute.startsWith("http://")) {
            try {
                arrayList.add(new URI(magnetData.exactSubstitute, false));
            }
            catch (URIException uRIException) {
                // empty catch block
            }
        }
        Iterator iterator = magnetData.acceptableSubstituteList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith("http://")) continue;
            try {
                arrayList.add(new URI(string, false));
            }
            catch (URIException uRIException) {}
        }
        return arrayList;
    }

    public static MagnetData parseFromURI(URI uRI) {
        String string = uRI.getScheme();
        if (!"magnet".equals(string)) {
            return null;
        }
        MagnetData magnetData = new MagnetData();
        String string2 = uRI.getEscapedQuery();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            int n = string3.indexOf("=");
            if (n == -1) continue;
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n + 1);
            string5 = URLCodecUtils.decodeURL(string5);
            if (string4.equals("xt")) {
                magnetData.setExactTopic(string5);
                continue;
            }
            if (string4.equals("xs")) {
                magnetData.setExactSubstitute(string5);
                continue;
            }
            if (string4.equals("as")) {
                magnetData.addAcceptableSubstitute(string5);
                continue;
            }
            if (string4.equals("dn")) {
                magnetData.setDisplayName(string5);
                continue;
            }
            if (!string4.equals("kt")) continue;
            magnetData.setKeywordTopic(string5);
        }
        return magnetData;
    }
}

