/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.io.IOException;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import phex.common.ServiceManager;
import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.download.PushHandler;
import phex.host.Host;
import phex.http.HttpClientFactory;
import phex.msg.GUID;
import phex.msg.MsgManager;
import phex.msg.PushRequestMsg;
import phex.net.presentation.SocketFacade;
import phex.statistic.UploadDownloadCountStatistic;
import phex.utils.NLogger;

public class PushRequestSleeper {
    private GUID clientGUID;
    private long fileIndex;
    private DestAddress[] pushProxyAddresses;
    private SocketFacade givenSocket;

    public PushRequestSleeper(GUID gUID, long l, DestAddress[] destAddressArray) {
        this.clientGUID = gUID;
        this.fileIndex = l;
        this.pushProxyAddresses = destAddressArray;
    }

    public GUID getGUID() {
        return this.clientGUID;
    }

    public long getFileIndex() {
        return this.fileIndex;
    }

    public synchronized boolean acceptGIVConnection(SocketFacade socketFacade, GUID gUID) {
        if (!this.clientGUID.equals(gUID)) {
            return false;
        }
        this.givenSocket = socketFacade;
        this.notify();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SocketFacade requestSocketViaPush() {
        boolean bl = false;
        try {
            if (this.pushProxyAddresses != null && this.pushProxyAddresses.length > 0) {
                bl = this.requestViaPushProxies();
            }
            if (!bl) {
                bl = this.requestViaPushRoute();
            }
            if (!bl) {
                SocketFacade socketFacade = null;
                return socketFacade;
            }
            try {
                this.wait(ServiceManager.sCfg.mPushTransferTimeout);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            if (this.givenSocket == null) {
                SocketFacade socketFacade = null;
                return socketFacade;
            }
            SocketFacade socketFacade = this.givenSocket;
            return socketFacade;
        }
        finally {
            PushHandler.unregisterPushRequestSleeper(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestViaPushProxies() {
        DestAddress destAddress = NetworkManager.getInstance().getLocalAddress();
        String string = "/gnet/push-proxy?guid=" + this.clientGUID.toHexString();
        if (this.pushProxyAddresses.length > 0) {
            UploadDownloadCountStatistic.pushDldPushProxyAttempts.increment(1);
        }
        for (int i = 0; i < this.pushProxyAddresses.length; ++i) {
            String string2 = "http://" + this.pushProxyAddresses[i].getFullHostName() + string;
            if (NLogger.isDebugEnabled("PUSH")) {
                NLogger.debug("PUSH", (Object)("PUSH via push proxy: " + string2));
            }
            HttpClient httpClient = HttpClientFactory.createHttpClient();
            httpClient.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(1, false));
            HeadMethod headMethod = null;
            try {
                headMethod = new HeadMethod(string2);
                headMethod.addRequestHeader("X-Node", destAddress.getFullHostName());
                headMethod.addRequestHeader("Cache-Control", "no-cache");
                headMethod.addRequestHeader("Connection", "close");
                int n = httpClient.executeMethod((HttpMethod)headMethod);
                if (NLogger.isDebugEnabled("PUSH")) {
                    NLogger.debug("PUSH", (Object)("PUSH via push proxy response code: " + n + " (" + string2 + ")"));
                }
                if (n != 202) continue;
                UploadDownloadCountStatistic.pushDldPushProxySuccess.increment(1);
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
                if (!NLogger.isWarnEnabled("PUSH")) continue;
                NLogger.warn("PUSH", (Object)iOException);
                continue;
            }
            finally {
                if (headMethod != null) {
                    headMethod.releaseConnection();
                }
            }
        }
        return false;
    }

    private boolean requestViaPushRoute() {
        DestAddress destAddress = NetworkManager.getInstance().getLocalAddress();
        if (destAddress.getIpAddress() == null) {
            NLogger.warn("PUSH", (Object)"Local address has no IP to use for PUSH.");
            return false;
        }
        PushRequestMsg pushRequestMsg = new PushRequestMsg(this.clientGUID, this.fileIndex, destAddress);
        Host host = MsgManager.getInstance().getPushRouting(this.clientGUID);
        if (host == null) {
            if (NLogger.isDebugEnabled("PUSH")) {
                NLogger.debug("PUSH", (Object)("No PUSH route for " + this.clientGUID + "."));
            }
            return false;
        }
        if (NLogger.isDebugEnabled("PUSH")) {
            NLogger.debug("PUSH", (Object)("Push route for " + this.clientGUID + " is " + host));
        }
        host.queueMessageToSend(pushRequestMsg);
        return true;
    }
}

