/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import phex.download.DownloadScope;
import phex.download.DownloadScopeList;
import phex.download.RatedDownloadScope;

public class RatedDownloadScopeList {
    private static DownloadScopeComparator DOWNLOAD_SCOPE_COMPARATOR;
    private static RatedDownloadScopeComparator RATED_DOWNLOAD_SCOPE_COMPARATOR;
    private int modificationCount = 0;
    private List scopeList = new ArrayList();
    private List ratedScopeList = new ArrayList();
    private long aggregatedLengthCache = 0L;
    private int aggregatedLengthModCount = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RatedDownloadScopeList() {
    }

    public RatedDownloadScopeList(DownloadScopeList downloadScopeList) {
        this();
        Iterator iterator = downloadScopeList.getScopeIterator();
        while (iterator.hasNext()) {
            DownloadScope downloadScope = (DownloadScope)iterator.next();
            this.add(new RatedDownloadScope(downloadScope.getStart(), downloadScope.getEnd()));
        }
    }

    public void addAll(RatedDownloadScopeList ratedDownloadScopeList) {
        Iterator iterator = ratedDownloadScopeList.getScopeIterator();
        while (iterator.hasNext()) {
            RatedDownloadScope ratedDownloadScope = (RatedDownloadScope)iterator.next();
            this.add(ratedDownloadScope);
        }
    }

    public void addAll(DownloadScopeList downloadScopeList) {
        Iterator iterator = downloadScopeList.getScopeIterator();
        while (iterator.hasNext()) {
            DownloadScope downloadScope = (DownloadScope)iterator.next();
            this.add(new RatedDownloadScope(downloadScope.getStart(), downloadScope.getEnd()));
        }
    }

    public void add(RatedDownloadScope ratedDownloadScope) {
        RatedDownloadScope ratedDownloadScope2;
        RatedDownloadScope ratedDownloadScope3 = null;
        RatedDownloadScope ratedDownloadScope4 = null;
        Iterator iterator = this.getScopeIterator();
        while (iterator.hasNext()) {
            ratedDownloadScope2 = (RatedDownloadScope)iterator.next();
            if (ratedDownloadScope.contains(ratedDownloadScope2)) {
                RatedDownloadScope ratedDownloadScope5;
                iterator.remove();
                RatedDownloadScope ratedDownloadScope6 = new RatedDownloadScope(ratedDownloadScope2.getStart(), ratedDownloadScope2.getEnd(), ratedDownloadScope2.getCountRating() + ratedDownloadScope.getCountRating(), ratedDownloadScope2.getSpeedRating() + ratedDownloadScope.getSpeedRating());
                this.addInternal(ratedDownloadScope6);
                if (ratedDownloadScope.getStart() < ratedDownloadScope2.getStart()) {
                    ratedDownloadScope5 = new RatedDownloadScope(ratedDownloadScope.getStart(), ratedDownloadScope2.getStart() - 1L, ratedDownloadScope.getCountRating(), ratedDownloadScope.getSpeedRating());
                    this.add(ratedDownloadScope5);
                }
                if (ratedDownloadScope2.getEnd() < ratedDownloadScope.getEnd()) {
                    ratedDownloadScope5 = new RatedDownloadScope(ratedDownloadScope2.getEnd() + 1L, ratedDownloadScope.getEnd(), ratedDownloadScope.getCountRating(), ratedDownloadScope.getSpeedRating());
                    this.add(ratedDownloadScope5);
                }
                return;
            }
            if (ratedDownloadScope2.contains(ratedDownloadScope)) {
                RatedDownloadScope ratedDownloadScope7;
                if (ratedDownloadScope.getCountRating() == 0 && ratedDownloadScope.getSpeedRating() == 0L) {
                    return;
                }
                iterator.remove();
                if (ratedDownloadScope2.getStart() != ratedDownloadScope.getStart()) {
                    ratedDownloadScope7 = new RatedDownloadScope(ratedDownloadScope2.getStart(), ratedDownloadScope.getStart() - 1L, ratedDownloadScope2.getCountRating(), ratedDownloadScope2.getSpeedRating());
                    this.addInternal(ratedDownloadScope7);
                }
                ratedDownloadScope7 = new RatedDownloadScope(ratedDownloadScope.getStart(), ratedDownloadScope.getEnd(), ratedDownloadScope2.getCountRating() + ratedDownloadScope.getCountRating(), ratedDownloadScope2.getSpeedRating() + ratedDownloadScope.getSpeedRating());
                this.addInternal(ratedDownloadScope7);
                if (ratedDownloadScope2.getEnd() != ratedDownloadScope.getEnd()) {
                    RatedDownloadScope ratedDownloadScope8 = new RatedDownloadScope(ratedDownloadScope.getEnd() + 1L, ratedDownloadScope2.getEnd(), ratedDownloadScope2.getCountRating(), ratedDownloadScope2.getSpeedRating());
                    this.addInternal(ratedDownloadScope8);
                }
                return;
            }
            if (ratedDownloadScope.isNeighborBefore(ratedDownloadScope2) && ratedDownloadScope.isOverlapping(ratedDownloadScope2)) {
                ratedDownloadScope3 = ratedDownloadScope2;
            }
            if (ratedDownloadScope.isNeighborAfter(ratedDownloadScope2) && ratedDownloadScope2.isOverlapping(ratedDownloadScope)) {
                ratedDownloadScope4 = ratedDownloadScope2;
            }
            if (ratedDownloadScope4 == null && ratedDownloadScope2.getStart() <= ratedDownloadScope.getEnd()) continue;
        }
        if (ratedDownloadScope3 == null && ratedDownloadScope4 == null) {
            this.addInternal(ratedDownloadScope);
        } else if (ratedDownloadScope4 != null && ratedDownloadScope3 != null && ratedDownloadScope.getCountRating() == 0 && ratedDownloadScope.getSpeedRating() == 0L && ratedDownloadScope4.getCountRating() == ratedDownloadScope3.getCountRating() && ratedDownloadScope4.getSpeedRating() == ratedDownloadScope3.getSpeedRating()) {
            this.removeInternal(ratedDownloadScope3);
            this.removeInternal(ratedDownloadScope4);
            ratedDownloadScope2 = new RatedDownloadScope(ratedDownloadScope3.getStart(), ratedDownloadScope4.getEnd(), ratedDownloadScope4.getCountRating(), ratedDownloadScope4.getSpeedRating());
            this.addInternal(ratedDownloadScope2);
        } else {
            RatedDownloadScope ratedDownloadScope9;
            if (ratedDownloadScope4 != null) {
                if (ratedDownloadScope.getCountRating() == 0 && ratedDownloadScope.getSpeedRating() == 0L) {
                    this.removeInternal(ratedDownloadScope4);
                    ratedDownloadScope2 = new RatedDownloadScope(ratedDownloadScope.getStart(), ratedDownloadScope4.getEnd(), ratedDownloadScope4.getCountRating(), ratedDownloadScope4.getSpeedRating());
                    this.add(ratedDownloadScope2);
                } else {
                    this.removeInternal(ratedDownloadScope4);
                    ratedDownloadScope2 = new RatedDownloadScope(ratedDownloadScope4.getStart(), ratedDownloadScope.getEnd(), ratedDownloadScope4.getCountRating() + ratedDownloadScope.getCountRating(), ratedDownloadScope4.getSpeedRating() + ratedDownloadScope.getSpeedRating());
                    this.add(ratedDownloadScope2);
                    ratedDownloadScope9 = new RatedDownloadScope(ratedDownloadScope.getEnd() + 1L, ratedDownloadScope4.getEnd(), ratedDownloadScope4.getCountRating(), ratedDownloadScope4.getSpeedRating());
                    this.add(ratedDownloadScope9);
                }
            }
            if (ratedDownloadScope3 != null) {
                if (ratedDownloadScope.getCountRating() == 0 && ratedDownloadScope.getSpeedRating() == 0L) {
                    this.removeInternal(ratedDownloadScope3);
                    ratedDownloadScope2 = new RatedDownloadScope(ratedDownloadScope3.getStart(), ratedDownloadScope.getEnd(), ratedDownloadScope3.getCountRating(), ratedDownloadScope3.getSpeedRating());
                    this.add(ratedDownloadScope2);
                } else {
                    this.removeInternal(ratedDownloadScope3);
                    ratedDownloadScope2 = new RatedDownloadScope(ratedDownloadScope3.getStart(), ratedDownloadScope.getStart() - 1L, ratedDownloadScope3.getCountRating(), ratedDownloadScope3.getSpeedRating());
                    this.add(ratedDownloadScope2);
                    ratedDownloadScope9 = new RatedDownloadScope(ratedDownloadScope.getStart(), ratedDownloadScope3.getEnd(), ratedDownloadScope3.getCountRating() + ratedDownloadScope.getCountRating(), ratedDownloadScope3.getSpeedRating() + ratedDownloadScope.getSpeedRating());
                    this.add(ratedDownloadScope9);
                }
            }
        }
    }

    public void removeAll(RatedDownloadScopeList ratedDownloadScopeList) {
        Iterator iterator = ratedDownloadScopeList.getScopeIterator();
        while (iterator.hasNext()) {
            RatedDownloadScope ratedDownloadScope = (RatedDownloadScope)iterator.next();
            this.remove(ratedDownloadScope);
        }
    }

    public void remove(RatedDownloadScope ratedDownloadScope) {
        RatedDownloadScope ratedDownloadScope2 = null;
        RatedDownloadScope ratedDownloadScope3 = null;
        Iterator iterator = this.scopeList.iterator();
        while (iterator.hasNext()) {
            RatedDownloadScope ratedDownloadScope4 = (RatedDownloadScope)iterator.next();
            if (ratedDownloadScope4.isOverlapping(ratedDownloadScope)) {
                iterator.remove();
                if (ratedDownloadScope.getEnd() >= ratedDownloadScope4.getEnd()) {
                    if (ratedDownloadScope.getStart() <= ratedDownloadScope4.getStart()) continue;
                    ratedDownloadScope2 = new RatedDownloadScope(ratedDownloadScope4.getStart(), ratedDownloadScope.getStart() - 1L, ratedDownloadScope4.getCountRating(), ratedDownloadScope4.getSpeedRating());
                    continue;
                }
                if (ratedDownloadScope4.getStart() >= ratedDownloadScope.getStart()) {
                    ratedDownloadScope3 = new RatedDownloadScope(ratedDownloadScope.getEnd() + 1L, ratedDownloadScope4.getEnd(), ratedDownloadScope4.getCountRating(), ratedDownloadScope4.getSpeedRating());
                    break;
                }
                ratedDownloadScope2 = new RatedDownloadScope(ratedDownloadScope4.getStart(), ratedDownloadScope.getStart() - 1L, ratedDownloadScope4.getCountRating(), ratedDownloadScope4.getSpeedRating());
                ratedDownloadScope3 = new RatedDownloadScope(ratedDownloadScope.getEnd() + 1L, ratedDownloadScope4.getEnd(), ratedDownloadScope4.getCountRating(), ratedDownloadScope4.getSpeedRating());
                break;
            }
            if (ratedDownloadScope4.getStart() < ratedDownloadScope.getEnd()) continue;
        }
        if (ratedDownloadScope2 != null) {
            this.add(ratedDownloadScope2);
        }
        if (ratedDownloadScope3 != null) {
            this.add(ratedDownloadScope3);
        }
    }

    public void retainAll(DownloadScopeList downloadScopeList) {
        ListIterator<RatedDownloadScope> listIterator = this.scopeList.listIterator();
        while (listIterator.hasNext()) {
            boolean bl = true;
            RatedDownloadScope ratedDownloadScope = (RatedDownloadScope)listIterator.next();
            Iterator iterator = downloadScopeList.getScopeIterator();
            while (iterator.hasNext()) {
                DownloadScope downloadScope = (DownloadScope)iterator.next();
                if (ratedDownloadScope.isOverlapping(downloadScope)) {
                    listIterator.remove();
                    long l = Math.max(downloadScope.getStart(), ratedDownloadScope.getStart());
                    long l2 = Math.min(downloadScope.getEnd(), ratedDownloadScope.getEnd());
                    listIterator.add(new RatedDownloadScope(l, l2, ratedDownloadScope.getCountRating(), ratedDownloadScope.getSpeedRating()));
                    bl = false;
                    break;
                }
                if (downloadScope.getStart() < ratedDownloadScope.getEnd()) continue;
            }
            if (!bl) continue;
            listIterator.remove();
        }
    }

    public void rateDownloadScopeList(DownloadScopeList downloadScopeList, long l) {
        Iterator iterator = downloadScopeList.getScopeIterator();
        while (iterator.hasNext()) {
            DownloadScope downloadScope = (DownloadScope)iterator.next();
            this.rateDownloadScope(downloadScope, l);
        }
    }

    public void compressByRatings() {
        ListIterator<RatedDownloadScope> listIterator = this.scopeList.listIterator();
        if (!listIterator.hasNext()) {
            return;
        }
        RatedDownloadScope ratedDownloadScope = (RatedDownloadScope)listIterator.next();
        while (listIterator.hasNext()) {
            RatedDownloadScope ratedDownloadScope2 = (RatedDownloadScope)listIterator.next();
            if (ratedDownloadScope2.getStart() == ratedDownloadScope.getEnd() + 1L && this.hasCloseToleranze(ratedDownloadScope, ratedDownloadScope2, 5.0)) {
                listIterator.remove();
                listIterator.previous();
                listIterator.remove();
                int n = (int)Math.round((double)(ratedDownloadScope.getLength() * (long)ratedDownloadScope.getCountRating() + ratedDownloadScope2.getLength() * (long)ratedDownloadScope2.getCountRating()) / (double)(ratedDownloadScope.getLength() + ratedDownloadScope2.getLength()));
                long l = ratedDownloadScope.getSpeedRating() == 0L || ratedDownloadScope2.getSpeedRating() == 0L ? Math.max(ratedDownloadScope.getSpeedRating(), ratedDownloadScope2.getSpeedRating()) : Math.min(ratedDownloadScope.getSpeedRating(), ratedDownloadScope2.getSpeedRating());
                RatedDownloadScope ratedDownloadScope3 = new RatedDownloadScope(ratedDownloadScope.getStart(), ratedDownloadScope2.getEnd(), n, l);
                listIterator.add(ratedDownloadScope3);
                ratedDownloadScope2 = ratedDownloadScope3;
            }
            ratedDownloadScope = ratedDownloadScope2;
        }
    }

    private boolean hasCloseToleranze(RatedDownloadScope ratedDownloadScope, RatedDownloadScope ratedDownloadScope2, double d) {
        double d2;
        double d3 = Math.max(ratedDownloadScope.getCountRating(), ratedDownloadScope2.getCountRating());
        double d4 = d3 - d3 / 100.0 * d;
        return d4 < (d2 = (double)Math.min(ratedDownloadScope.getCountRating(), ratedDownloadScope2.getCountRating()));
    }

    private void rateDownloadScope(DownloadScope downloadScope, long l) {
        RatedDownloadScope ratedDownloadScope;
        ArrayList<RatedDownloadScope> arrayList = new ArrayList<RatedDownloadScope>();
        Iterator iterator = this.scopeList.iterator();
        while (iterator.hasNext()) {
            ratedDownloadScope = (RatedDownloadScope)iterator.next();
            if (ratedDownloadScope.isOverlapping(downloadScope)) {
                int n = (int)Math.max(ratedDownloadScope.getStart(), downloadScope.getStart());
                int n2 = (int)Math.min(ratedDownloadScope.getEnd(), downloadScope.getEnd());
                RatedDownloadScope ratedDownloadScope2 = new RatedDownloadScope(n, n2, 1, l);
                arrayList.add(ratedDownloadScope2);
            }
            if (ratedDownloadScope.getStart() <= downloadScope.getEnd()) continue;
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ratedDownloadScope = (RatedDownloadScope)iterator.next();
            this.add(ratedDownloadScope);
        }
    }

    public void prepareRating() {
        this.compressByRatings();
        this.ratedScopeList.clear();
        this.ratedScopeList.addAll(this.scopeList);
        Collections.sort(this.ratedScopeList, RATED_DOWNLOAD_SCOPE_COMPARATOR);
        this.dumpRatings();
    }

    public RatedDownloadScope getBestRated() {
        if (this.ratedScopeList.size() > 0) {
            return (RatedDownloadScope)this.ratedScopeList.get(0);
        }
        return null;
    }

    public RatedDownloadScope getWorstRated() {
        if (this.ratedScopeList.size() > 0) {
            return (RatedDownloadScope)this.ratedScopeList.get(this.ratedScopeList.size() - 1);
        }
        return null;
    }

    public boolean isRatingFruitful() {
        RatedDownloadScope ratedDownloadScope = this.getBestRated();
        RatedDownloadScope ratedDownloadScope2 = this.getWorstRated();
        if (ratedDownloadScope == null || ratedDownloadScope2 == null) {
            return false;
        }
        return !this.hasCloseToleranze(ratedDownloadScope, ratedDownloadScope2, 15.0);
    }

    public long getAggregatedLength() {
        if (this.modificationCount == this.aggregatedLengthModCount) {
            return this.aggregatedLengthCache;
        }
        long l = 0L;
        Iterator iterator = this.scopeList.iterator();
        while (iterator.hasNext()) {
            DownloadScope downloadScope = (DownloadScope)iterator.next();
            l += downloadScope.getLength();
        }
        this.aggregatedLengthCache = l;
        this.aggregatedLengthModCount = this.modificationCount;
        return l;
    }

    public Iterator getScopeIterator() {
        return this.scopeList.listIterator();
    }

    public int size() {
        return this.scopeList.size();
    }

    public void clear() {
        this.scopeList.clear();
        this.ratedScopeList.clear();
        this.aggregatedLengthCache = 0L;
        this.modificationCount = 0;
        this.aggregatedLengthModCount = 0;
    }

    protected void addInternal(RatedDownloadScope ratedDownloadScope) {
        int n = Collections.binarySearch(this.scopeList, ratedDownloadScope, DOWNLOAD_SCOPE_COMPARATOR);
        if (!$assertionsDisabled && n >= 0) {
            throw new AssertionError();
        }
        this.scopeList.add(-(n + 1), ratedDownloadScope);
        ++this.modificationCount;
    }

    protected void removeInternal(RatedDownloadScope ratedDownloadScope) {
        int n = Collections.binarySearch(this.scopeList, ratedDownloadScope, DOWNLOAD_SCOPE_COMPARATOR);
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        this.scopeList.remove(n);
        ++this.modificationCount;
    }

    private void dumpRatings() {
    }

    static {
        $assertionsDisabled = !RatedDownloadScopeList.class.desiredAssertionStatus();
        DOWNLOAD_SCOPE_COMPARATOR = new DownloadScopeComparator();
        RATED_DOWNLOAD_SCOPE_COMPARATOR = new RatedDownloadScopeComparator();
    }

    private static class RatedDownloadScopeComparator
    implements Comparator {
        private RatedDownloadScopeComparator() {
        }

        public int compare(Object object, Object object2) {
            RatedDownloadScope ratedDownloadScope = (RatedDownloadScope)object;
            RatedDownloadScope ratedDownloadScope2 = (RatedDownloadScope)object2;
            if (ratedDownloadScope == ratedDownloadScope2 || ratedDownloadScope.equals(ratedDownloadScope2)) {
                return 0;
            }
            if (ratedDownloadScope.getCountRating() > ratedDownloadScope2.getCountRating()) {
                return 1;
            }
            if (ratedDownloadScope.getCountRating() < ratedDownloadScope2.getCountRating()) {
                return -1;
            }
            if (ratedDownloadScope.getSpeedRating() > ratedDownloadScope2.getSpeedRating()) {
                return 1;
            }
            return -1;
        }
    }

    private static class DownloadScopeComparator
    implements Comparator {
        private DownloadScopeComparator() {
        }

        public int compare(Object object, Object object2) {
            DownloadScope downloadScope = (DownloadScope)object;
            DownloadScope downloadScope2 = (DownloadScope)object2;
            if (downloadScope == downloadScope2 || downloadScope.equals(downloadScope2)) {
                return 0;
            }
            if (downloadScope.getStart() > downloadScope2.getStart()) {
                return 1;
            }
            return -1;
        }
    }
}

