/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import phex.common.URN;
import phex.common.address.DestAddress;
import phex.msg.GUID;
import phex.query.QueryHitHost;

public class RemoteFile {
    private QueryHitHost qhHost;
    private int fileIndex;
    private String filename;
    private String pathInfo;
    private String displayName;
    private String fileExtension = null;
    private Long fileSize;
    private URN urn;
    private String metaData;
    private boolean isInDownloadQueue;
    private boolean filteredHidden;
    private boolean filteredRemoved;
    private Short score;

    public RemoteFile(QueryHitHost queryHitHost, int n, String string, String string2, long l, URN uRN, String string3, short s) {
        this.qhHost = queryHitHost;
        this.fileIndex = n;
        this.filename = string;
        this.pathInfo = string2;
        this.fileSize = new Long(l);
        this.urn = uRN;
        this.metaData = string3;
        this.isInDownloadQueue = false;
        this.score = new Short(s);
        this.buildDisplayName();
    }

    public RemoteFile(RemoteFile remoteFile) {
        this.copy(remoteFile);
    }

    public void copy(RemoteFile remoteFile) {
        this.qhHost = remoteFile.qhHost;
        this.fileIndex = remoteFile.fileIndex;
        this.urn = remoteFile.urn;
        this.filename = remoteFile.filename;
        this.fileSize = remoteFile.fileSize;
        this.isInDownloadQueue = remoteFile.isInDownloadQueue;
        this.score = remoteFile.score;
        this.pathInfo = remoteFile.pathInfo;
        this.displayName = remoteFile.displayName;
    }

    public GUID getRemoteClientID() {
        return this.qhHost.getHostGUID();
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFileExt() {
        if (this.fileExtension != null) {
            return this.fileExtension;
        }
        int n = this.filename.lastIndexOf(".");
        this.fileExtension = n > -1 ? this.filename.substring(n + 1, this.filename.length()) : "";
        return this.fileExtension;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public Long getFileSizeObject() {
        return this.fileSize;
    }

    public QueryHitHost getQueryHitHost() {
        return this.qhHost;
    }

    public void setQueryHitHost(QueryHitHost queryHitHost) {
        this.qhHost = queryHitHost;
    }

    public void updateQueryHitHost(QueryHitHost queryHitHost) {
        if (this.qhHost.getHostGUID() == null) {
            this.qhHost.setHostGUID(queryHitHost.getHostGUID());
        }
        if (this.qhHost.getHostSpeed() == -1) {
            this.qhHost.setHostSpeed(queryHitHost.getHostSpeed());
        }
    }

    public DestAddress getHostAddress() {
        return this.qhHost.getHostAddress();
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String string) {
        this.metaData = string;
    }

    public URN getURN() {
        return this.urn;
    }

    public String getSHA1() {
        if (this.urn == null || !this.urn.isSha1Nid()) {
            return "";
        }
        return this.urn.getNamespaceSpecificString();
    }

    public int getSpeed() {
        return this.qhHost.getHostSpeed();
    }

    public Long getSpeedObject() {
        return this.qhHost.getHostSpeedObject();
    }

    public boolean isInDownloadQueue() {
        return this.isInDownloadQueue;
    }

    public void setInDownloadQueue(boolean bl) {
        this.isInDownloadQueue = bl;
    }

    public void clearFilterFlags() {
        this.filteredHidden = false;
        this.filteredRemoved = false;
    }

    public boolean isFilteredHidden() {
        return this.filteredHidden;
    }

    public void setFilteredHidden(boolean bl) {
        this.filteredHidden = bl;
    }

    public boolean isFilteredRemoved() {
        return this.filteredRemoved;
    }

    public void setFilteredRemoved(boolean bl) {
        this.filteredRemoved = bl;
    }

    public Short getScore() {
        return this.score;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RemoteFile)) {
            return false;
        }
        RemoteFile remoteFile = (RemoteFile)object;
        return this.qhHost.getHostAddress().equals(remoteFile.qhHost.getHostAddress()) && this.fileIndex == remoteFile.fileIndex;
    }

    public int hashCode() {
        int n = 0;
        n = 31 * n + ((Object)this.qhHost.getHostAddress()).hashCode();
        n = 127 * n + this.fileIndex;
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("  ");
        stringBuffer.append(this.qhHost.getHostAddress());
        stringBuffer.append("  ");
        stringBuffer.append(this.filename);
        stringBuffer.append("  ");
        stringBuffer.append(this.fileIndex);
        return stringBuffer.toString();
    }

    private void buildDisplayName() {
        String string;
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this.pathInfo != null && this.pathInfo.length() > 0) {
            string = this.pathInfo.replace('\\', '/');
            stringBuffer.append(string);
            if (!string.endsWith("/")) {
                stringBuffer.append("/");
            }
        }
        string = this.filename.replace('\\', '/');
        stringBuffer.append(string);
        this.displayName = stringBuffer.toString();
    }
}

