/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.ServiceManager;
import phex.common.ShortObj;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.common.log.LogRecord;
import phex.download.DownloadScope;
import phex.download.DownloadScopeList;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadConstants;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadInfo;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SwarmingManager;
import phex.http.HTTPRangeSet;
import phex.http.Range;
import phex.http.XQueueParameters;
import phex.msg.GUID;
import phex.net.presentation.PresentationManager;
import phex.query.QueryHitHost;
import phex.utils.NLogger;
import phex.utils.URLCodecUtils;
import phex.utils.URLUtil;
import phex.xml.ObjectFactory;
import phex.xml.XJBSWDownloadCandidate;
import phex.xml.XMLUtils;

public class SWDownloadCandidate
implements SWDownloadConstants {
    private long lastConnectionTime;
    private int failedConnectionTries;
    private GUID guid;
    private long fileIndex;
    private URN resourceURN;
    private URI downloadURI;
    private String fileName;
    private int lastTransferRateBPS;
    private DestAddress hostAddress;
    private ShortObj statusObj;
    private String statusReason;
    private short errorStatus;
    private long statusTimeout;
    private int errorStatusRepetition;
    private String vendor;
    private boolean isG2FeatureAdded;
    private boolean isPushNeeded;
    private DestAddress[] pushProxyAddresses;
    private boolean isChatSupported;
    private DownloadScopeList availableScopeList = null;
    private long availableRangeSetTime = 0L;
    private SWDownloadFile downloadFile;
    private SWDownloadSegment downloadSegment;
    private XQueueParameters xQueueParameters;
    private Set sendAltLocSet;
    private long totalDownloadSize;

    public SWDownloadCandidate(RemoteFile remoteFile, SWDownloadFile sWDownloadFile) {
        this.downloadFile = sWDownloadFile;
        this.fileIndex = remoteFile.getFileIndex();
        this.fileName = remoteFile.getFilename();
        this.resourceURN = remoteFile.getURN();
        this.guid = remoteFile.getRemoteClientID();
        QueryHitHost queryHitHost = remoteFile.getQueryHitHost();
        this.vendor = queryHitHost.getVendor();
        this.isPushNeeded = queryHitHost.isPushNeeded();
        this.hostAddress = remoteFile.getHostAddress();
        this.isChatSupported = queryHitHost.isChatSupported();
        this.pushProxyAddresses = queryHitHost.getPushProxyAddresses();
        this.statusObj = new ShortObj(12);
        this.lastTransferRateBPS = 0;
        this.totalDownloadSize = 0L;
        this.lastConnectionTime = 0L;
    }

    public SWDownloadCandidate(DestAddress destAddress, long l, String string, URN uRN, SWDownloadFile sWDownloadFile) {
        this.downloadFile = sWDownloadFile;
        this.fileIndex = l;
        this.fileName = string;
        this.resourceURN = uRN;
        this.guid = null;
        this.vendor = null;
        this.isPushNeeded = false;
        this.isChatSupported = true;
        this.hostAddress = destAddress;
        this.statusObj = new ShortObj(12);
        this.lastTransferRateBPS = 0;
        this.totalDownloadSize = 0L;
        this.lastConnectionTime = 0L;
    }

    public SWDownloadCandidate(DestAddress destAddress, URI uRI, SWDownloadFile sWDownloadFile) throws URIException {
        this.downloadFile = sWDownloadFile;
        this.fileName = URLUtil.getPathQueryFromUri(uRI);
        this.downloadURI = uRI;
        this.resourceURN = URLUtil.getQueryURN(uRI);
        this.guid = null;
        this.vendor = null;
        this.isPushNeeded = false;
        this.isChatSupported = true;
        this.hostAddress = destAddress;
        this.statusObj = new ShortObj(12);
        this.lastTransferRateBPS = 0;
        this.totalDownloadSize = 0L;
        this.lastConnectionTime = 0L;
    }

    public SWDownloadCandidate(XJBSWDownloadCandidate xJBSWDownloadCandidate, SWDownloadFile sWDownloadFile) throws MalformedDestAddressException {
        String string;
        this.downloadFile = sWDownloadFile;
        this.fileIndex = xJBSWDownloadCandidate.getFileIndex();
        this.fileName = xJBSWDownloadCandidate.getFileName();
        this.lastTransferRateBPS = 0;
        this.totalDownloadSize = 0L;
        String string2 = xJBSWDownloadCandidate.getGUID();
        if (string2 != null) {
            this.guid = new GUID(string2);
        }
        if ((string = xJBSWDownloadCandidate.getDownloadURI()) != null) {
            try {
                this.downloadURI = new URI(xJBSWDownloadCandidate.getDownloadURI(), true);
            }
            catch (URIException uRIException) {
                NLogger.warn("Download.Candidate", (Object)("Malformed URI in: " + sWDownloadFile.toString() + " - " + xJBSWDownloadCandidate.getDownloadURI() + " - " + this.toString()), (Throwable)uRIException);
            }
        }
        this.vendor = xJBSWDownloadCandidate.getVendor();
        this.isPushNeeded = xJBSWDownloadCandidate.isPushNeeded();
        this.isChatSupported = xJBSWDownloadCandidate.isChatSupported();
        this.lastConnectionTime = xJBSWDownloadCandidate.isSetLastConnectionTime() ? xJBSWDownloadCandidate.getLastConnectionTime() : 0L;
        try {
            this.hostAddress = PresentationManager.getInstance().createHostAddress(xJBSWDownloadCandidate.getRemoteHost(), 6346);
        }
        catch (MalformedDestAddressException malformedDestAddressException) {
            NLogger.warn("Download.Candidate", (Object)("Malformed host address in: " + sWDownloadFile.toString() + " - " + xJBSWDownloadCandidate.getRemoteHost() + " - " + this.toString()), (Throwable)malformedDestAddressException);
            throw malformedDestAddressException;
        }
        this.resourceURN = sWDownloadFile.getFileURN();
        if (xJBSWDownloadCandidate.getConnectionFailedRepetition() > 0) {
            this.errorStatus = (short)13;
            this.statusObj = new ShortObj(13);
            this.failedConnectionTries = this.errorStatusRepetition = xJBSWDownloadCandidate.getConnectionFailedRepetition();
        } else {
            this.statusObj = new ShortObj(12);
        }
    }

    public String getDownloadRequestUrl() {
        String string;
        if (this.downloadURI != null) {
            try {
                String string2 = URLUtil.getPathQueryFromUri(this.downloadURI);
                return string2;
            }
            catch (URIException uRIException) {
                NLogger.warn("Download.Candidate", (Object)uRIException, (Throwable)uRIException);
            }
        }
        if (this.resourceURN != null) {
            string = URLUtil.buildName2ResourceURL(this.resourceURN);
        } else {
            String string3 = String.valueOf(this.fileIndex);
            StringBuffer stringBuffer = new StringBuffer(6 + string3.length() + this.fileName.length());
            stringBuffer.append("/get/");
            stringBuffer.append(string3);
            stringBuffer.append('/');
            stringBuffer.append(URLCodecUtils.encodeURL(this.fileName));
            string = stringBuffer.toString();
        }
        return string;
    }

    public SWDownloadFile getDownloadFile() {
        return this.downloadFile;
    }

    public long getSpeed() {
        return this.lastTransferRateBPS;
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public String getFileName() {
        return this.fileName;
    }

    public URN getResourceURN() {
        return this.resourceURN;
    }

    public GUID getGUID() {
        return this.guid;
    }

    public long getFileIndex() {
        return this.fileIndex;
    }

    public long getTotalDownloadSize() {
        return this.totalDownloadSize;
    }

    public void incTotalDownloadSize(int n) {
        this.totalDownloadSize += (long)n;
    }

    public long getStatusTimeLeft() {
        long l = this.statusTimeout - System.currentTimeMillis();
        if (l < 0L) {
            l = 0L;
        }
        return l;
    }

    public short getStatus() {
        return this.statusObj.getValue();
    }

    public ShortObj getStatusObj() {
        return this.statusObj;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public int getFailedConnectionTries() {
        return this.failedConnectionTries;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String string) {
        if (this.vendor == null || !this.vendor.equals(string)) {
            for (int i = 0; i < string.length(); ++i) {
                if (XMLUtils.isXmlChar(string.charAt(i))) continue;
                return;
            }
            this.vendor = string;
            this.addToCandidateLog("Set vendor to: " + this.vendor);
            this.downloadFile.fireDownloadCandidateChanged(this);
        }
    }

    public boolean isG2FeatureAdded() {
        return this.isG2FeatureAdded;
    }

    public void setG2FeatureAdded(boolean bl) {
        this.isG2FeatureAdded = bl;
    }

    public void updateXQueueParameters(XQueueParameters xQueueParameters) {
        if (this.xQueueParameters == null) {
            this.xQueueParameters = xQueueParameters;
        } else {
            this.xQueueParameters.update(xQueueParameters);
        }
    }

    public XQueueParameters getXQueueParameters() {
        return this.xQueueParameters;
    }

    public boolean isPushNeeded() {
        return this.isPushNeeded;
    }

    public DestAddress[] getPushProxyAddresses() {
        return this.pushProxyAddresses;
    }

    public void setPushProxyAddresses(DestAddress[] destAddressArray) {
        this.pushProxyAddresses = destAddressArray;
    }

    public long getLastConnectionTime() {
        return this.lastConnectionTime;
    }

    public void setLastConnectionTime(long l) {
        this.lastConnectionTime = l;
    }

    public boolean isChatSupported() {
        return this.isChatSupported;
    }

    public void setChatSupported(boolean bl) {
        this.isChatSupported = bl;
    }

    public boolean isRemotlyQueued() {
        return this.statusObj.value == 18;
    }

    public boolean isRangeUnavailable() {
        return this.statusObj.value == 15;
    }

    public boolean isDownloading() {
        return this.statusObj.value == 20;
    }

    public Set getSendAltLocsSet() {
        if (this.sendAltLocSet == null) {
            this.sendAltLocSet = new HashSet();
        }
        return this.sendAltLocSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvailableRangeSet(HTTPRangeSet hTTPRangeSet) {
        if ((hTTPRangeSet == null || hTTPRangeSet.getRangeSet().size() == 0) && this.availableScopeList == null) {
            return;
        }
        if (hTTPRangeSet == null) {
            this.availableScopeList = null;
            return;
        }
        SWDownloadCandidate sWDownloadCandidate = this;
        synchronized (sWDownloadCandidate) {
            this.availableScopeList = new DownloadScopeList();
            long l = this.downloadFile.getTotalDataSize();
            Iterator iterator = hTTPRangeSet.getIterator();
            while (iterator.hasNext()) {
                Range range = (Range)iterator.next();
                DownloadScope downloadScope = new DownloadScope(range.getStartOffset(l), range.getEndOffset(l));
                this.availableScopeList.add(downloadScope);
            }
            this.availableRangeSetTime = System.currentTimeMillis();
        }
        NLogger.debug("Download.File.RangePriority", (Object)("Added new rangeset for " + this.downloadFile.getDestinationFileName() + ": " + hTTPRangeSet));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadScopeList getAvailableScopeList() {
        if (System.currentTimeMillis() > this.availableRangeSetTime + 600000L) {
            this.setAvailableRangeSet(null);
        }
        SWDownloadCandidate sWDownloadCandidate = this;
        synchronized (sWDownloadCandidate) {
            return this.availableScopeList;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof SWDownloadCandidate) {
            return this.equals((SWDownloadCandidate)object);
        }
        return false;
    }

    public boolean equals(SWDownloadCandidate sWDownloadCandidate) {
        return this.hostAddress.equals(sWDownloadCandidate.hostAddress);
    }

    public void setStatus(short s) {
        this.setStatus(s, -1, null);
    }

    public void setStatus(short s, int n) {
        this.setStatus(s, n, null);
    }

    public void setStatus(short s, int n, String string) {
        long l;
        if (this.statusObj.value == s) {
            return;
        }
        short s2 = this.statusObj.value;
        this.statusObj.value = s;
        this.statusTimeout = l = System.currentTimeMillis();
        switch (this.statusObj.value) {
            case 11: {
                l += 10800000L;
                break;
            }
            case 10: {
                l = Long.MAX_VALUE;
                break;
            }
            case 16: {
                break;
            }
            case 13: {
                ++this.failedConnectionTries;
                if (this.failedConnectionTries >= 12) {
                    this.downloadFile.markCandidateIgnored(this, "CandidateStatusReason_ConnectionFailed");
                    l = this.statusTimeout;
                    string = this.statusReason;
                    break;
                }
                if (this.failedConnectionTries >= 3) {
                    this.downloadFile.markCandidateBad(this);
                    l = this.statusTimeout;
                    break;
                }
                this.downloadFile.markCandidateMedium(this);
                l += this.calculateConnectionFailedTimeout();
                break;
            }
            case 19: {
                this.failedConnectionTries = 0;
                break;
            }
            case 14: 
            case 15: 
            case 18: {
                this.failedConnectionTries = 0;
                if (n > 0) {
                    l += (long)(n * 1000);
                    break;
                }
                l += this.determineErrorStatusTimeout(this.statusObj.value);
                break;
            }
            case 17: {
                l += (long)ServiceManager.sCfg.mPushTransferTimeout;
                break;
            }
            case 20: {
                this.errorStatus = 0;
                this.failedConnectionTries = 0;
            }
        }
        this.statusReason = string;
        NLogger.debug("Download.Candidate", (Object)("Setting status to " + s + " and raise timeout from " + this.statusTimeout + " to " + l + "(" + (l - this.statusTimeout) + ") Reason:" + string + "."));
        this.addToCandidateLog("Setting status to " + SWDownloadInfo.getDownloadCandidateStatusString(this) + " and raise timeout from " + this.statusTimeout + " to " + l + "(" + (l - this.statusTimeout) + ") Reason:" + string + ".");
        this.statusTimeout = l;
        this.downloadFile.candidateStatusChanged(this, s2, s);
    }

    private long calculateConnectionFailedTimeout() {
        return 120000L * (long)Math.pow(2.0, Math.min(this.failedConnectionTries - 1, 7)) + (long)((this.failedConnectionTries - 1) * 2);
    }

    private long determineErrorStatusTimeout(short s) {
        if (this.errorStatus == s) {
            ++this.errorStatusRepetition;
        } else {
            this.errorStatus = s;
            this.errorStatusRepetition = 0;
        }
        switch (this.errorStatus) {
            case 14: {
                return 60000L;
            }
            case 15: {
                return 60000L * (long)Math.pow(2.0, this.errorStatusRepetition);
            }
            case 18: {
                if (this.xQueueParameters == null) {
                    return 0L;
                }
                return this.xQueueParameters.getRequestSleepTime();
            }
        }
        NLogger.warn("Download.Candidate", (Object)("Unknown error status: " + this.errorStatus));
        return 0L;
    }

    public void manualConnectionRetry() {
        if (this.statusObj.value != 14 && this.statusObj.value != 13 && this.statusObj.value != 15 && this.statusObj.value != 11 && this.statusObj.value != 10) {
            return;
        }
        this.setStatus((short)12);
        SwarmingManager.getInstance().notifyWaitingWorkers();
    }

    public boolean isAbleToBeAllocated() {
        if ((long)this.lastTransferRateBPS < ServiceManager.sCfg.minimumAllowedTransferRate && this.lastTransferRateBPS > 0) {
            this.addToCandidateLog("Refusing candidate allocation as last transfer rate was only " + this.lastTransferRateBPS + " bps");
            NLogger.debug("Download.Candidate.Allocate", (Object)("Refusing candidate allocation as last transfer rate was only " + this.lastTransferRateBPS + " bps"));
            return false;
        }
        long l = System.currentTimeMillis();
        return this.statusTimeout <= l;
    }

    public void associateDownloadSegment(SWDownloadSegment sWDownloadSegment) {
        this.downloadSegment = sWDownloadSegment;
    }

    public long getPreferredSegmentSize() {
        long l;
        if (this.lastTransferRateBPS == 0) {
            l = ServiceManager.sCfg.initialSegmentSize;
        } else {
            long l2;
            l = Math.max((long)(this.lastTransferRateBPS * ServiceManager.sCfg.segmentTransferTime), ServiceManager.sCfg.segmentMultiple);
            if ((l += (l2 = -l % ServiceManager.sCfg.segmentMultiple)) > ServiceManager.sCfg.maximumSegmentSize) {
                l = ServiceManager.sCfg.maximumSegmentSize;
            }
        }
        if (l < 1L) {
            NLogger.warn("Download.Candidate", (Object)("Preferred size looks strange. bps=" + this.lastTransferRateBPS + " and stt=" + ServiceManager.sCfg.segmentTransferTime + " res " + l + " res1 " + this.lastTransferRateBPS * ServiceManager.sCfg.segmentTransferTime + " res2 " + -l % ServiceManager.sCfg.segmentMultiple));
            l = ServiceManager.sCfg.initialSegmentSize;
        }
        NLogger.debug("Download.Candidate", (Object)("Preferred segment size is " + l));
        return l;
    }

    public void releaseDownloadSegment() {
        if (this.downloadSegment != null) {
            this.lastTransferRateBPS = this.downloadSegment.getLongTermTransferRate();
            this.downloadSegment = null;
        }
    }

    public SWDownloadSegment getDownloadSegment() {
        return this.downloadSegment;
    }

    public XJBSWDownloadCandidate createXJBSWDownloadCandidate() throws JAXBException {
        ObjectFactory objectFactory = new ObjectFactory();
        XJBSWDownloadCandidate xJBSWDownloadCandidate = objectFactory.createXJBSWDownloadCandidate();
        xJBSWDownloadCandidate.setFileIndex(this.fileIndex);
        xJBSWDownloadCandidate.setFileName(this.fileName);
        if (this.guid != null) {
            xJBSWDownloadCandidate.setGUID(this.guid.toHexString());
        }
        if (this.downloadURI != null) {
            xJBSWDownloadCandidate.setDownloadURI(this.downloadURI.getEscapedURI());
        }
        xJBSWDownloadCandidate.setPushNeeded(this.isPushNeeded);
        xJBSWDownloadCandidate.setChatSupported(this.isChatSupported);
        xJBSWDownloadCandidate.setRemoteHost(this.hostAddress.getFullHostName());
        xJBSWDownloadCandidate.setVendor(this.vendor);
        if (this.lastConnectionTime > 0L) {
            xJBSWDownloadCandidate.setLastConnectionTime(this.lastConnectionTime);
        }
        if (this.failedConnectionTries > 0) {
            xJBSWDownloadCandidate.setConnectionFailedRepetition(this.failedConnectionTries);
        }
        return xJBSWDownloadCandidate;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[Candidate: ");
        if (this.vendor != null) {
            stringBuffer.append(this.vendor);
            stringBuffer.append(',');
        }
        stringBuffer.append("Adr:");
        stringBuffer.append(this.hostAddress);
        stringBuffer.append(" ->");
        stringBuffer.append(super.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void addToCandidateLog(String string) {
        if (ServiceManager.sCfg.downloadCandidateLogBufferSize > 0L) {
            LogRecord logRecord = new LogRecord(this, string);
            SwarmingManager.getInstance().getCandidateLogBuffer().addLogRecord(logRecord);
        }
    }
}

