/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.AltLocContainer;
import phex.common.AlternateLocation;
import phex.common.Environment;
import phex.common.FileHandlingException;
import phex.common.IntObj;
import phex.common.MediaType;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.TransferDataProvider;
import phex.common.URN;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.common.bandwidth.BandwidthController;
import phex.common.bandwidth.BandwidthManager;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.download.DownloadScope;
import phex.download.DownloadScopeList;
import phex.download.MagnetData;
import phex.download.RatedDownloadScopeList;
import phex.download.RemoteFile;
import phex.download.strategy.ScopeSelectionStrategy;
import phex.download.strategy.ScopeSelectionStrategyProvider;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadConstants;
import phex.download.swarming.SWDownloadInfo;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SWDownloadWorker;
import phex.download.swarming.SwarmingManager;
import phex.event.AsynchronousDispatcher;
import phex.event.DownloadCandidatesChangeListener;
import phex.event.DownloadSegmentsChangeListener;
import phex.event.EventListenerList;
import phex.http.HTTPRangeSet;
import phex.query.ResearchSetting;
import phex.statistic.SimpleStatisticProvider;
import phex.statistic.StatisticsManager;
import phex.utils.Executer;
import phex.utils.FileUtils;
import phex.utils.NLogger;
import phex.utils.StringUtils;
import phex.utils.URLUtil;
import phex.xml.ObjectFactory;
import phex.xml.XJBDownloadScope;
import phex.xml.XJBSWDownloadCandidate;
import phex.xml.XJBSWDownloadFile;
import phex.xml.XJBSWDownloadSegment;

public class SWDownloadFile
implements TransferDataProvider,
SWDownloadConstants {
    private static Random random;
    private DownloadScopeList missingScopeList;
    private DownloadScopeList blockedScopeList;
    private DownloadScopeList finishedScopeList;
    private RatedDownloadScopeList ratedScopeList;
    private long ratedScopeListBuildTime;
    private AltLocContainer goodAltLocContainer;
    private AltLocContainer badAltLocContainer;
    private Object candidatesLock = new Object();
    private ArrayList allCandidatesList;
    private ArrayList goodCandidatesList;
    private ArrayList mediumCandidatesList;
    private ArrayList badCandidatesList;
    private int goodCandidatePosition = 0;
    private int mediumCandidatePosition = 0;
    private int badCandidatePosition = 0;
    private ArrayList transferCandidatesList;
    private Set queuedCandidatesSet;
    private LinkedMap allocatedCandidateWorkerMap;
    private IntObj candidateCountObj;
    private int downloadingCandidateCount = 0;
    private int queuedCandidateCount = 0;
    private int connectingCandidateCount = 0;
    private long lastCandidateWorkerCountUpdate = 0L;
    private static final int CANDIDATE_WORKER_COUNT_TIMEOUT = 2000;
    private long fileSize;
    private File destinationFile;
    private boolean isDestStreamable;
    private File incompleteFile;
    private Date createdDate;
    private Date modifiedDate;
    private short status = 1;
    private long transferStartTime;
    private long transferStopTime;
    private long transferredDataSize;
    private long transferDataUpdateTime;
    private Integer currentProgress;
    private short workerCount;
    private URN fileURN;
    private URI downloadURI;
    private ResearchSetting researchSetting;
    private long previewSize;
    private BandwidthController bandwidthController;
    private ScopeSelectionStrategy scopeSelectionStrategy;
    private EventListenerList listenerList = new EventListenerList();
    static final /* synthetic */ boolean $assertionsDisabled;

    private SWDownloadFile() {
        this.allCandidatesList = new ArrayList();
        this.goodCandidatesList = new ArrayList();
        this.mediumCandidatesList = new ArrayList();
        this.badCandidatesList = new ArrayList();
        this.transferCandidatesList = new ArrayList();
        this.queuedCandidatesSet = new HashSet();
        this.allocatedCandidateWorkerMap = new LinkedMap();
        this.candidateCountObj = new IntObj(0);
        this.currentProgress = new Integer(0);
        this.createdDate = this.modifiedDate = new Date(System.currentTimeMillis());
        this.bandwidthController = BandwidthController.acquireBandwidthController("DownloadFile-" + this.toString(), Long.MAX_VALUE);
        this.bandwidthController.activateShortTransferAvg(1000, 15);
        this.bandwidthController.linkControllerIntoChain(BandwidthManager.getInstance().getDownloadBandwidthController());
    }

    public SWDownloadFile(String string, String string2, long l, URN uRN) {
        this();
        this.initialize(string, uRN, l, string2, true);
        try {
            this.initIncompleteFile();
        }
        catch (FileHandlingException fileHandlingException) {
            NLogger.error("Download", (Object)fileHandlingException, (Throwable)fileHandlingException);
        }
    }

    public SWDownloadFile(URI uRI) throws URIException {
        this();
        this.downloadURI = uRI;
        String string = this.downloadURI.getScheme();
        if ("magnet".equals(string)) {
            MagnetData magnetData = MagnetData.parseFromURI(this.downloadURI);
            URN uRN = MagnetData.lookupSHA1URN(magnetData);
            String string2 = MagnetData.lookupFileName(magnetData);
            String string3 = ServiceManager.sCfg.mDownloadDir + File.separator + FileUtils.convertToLocalSystemFilename(string2);
            String string4 = magnetData.getKeywordTopic() != null ? magnetData.getKeywordTopic() : StringUtils.createNaturalSearchTerm(MagnetData.lookupSearchName(magnetData));
            this.initialize(string3, uRN, -1L, string4, true);
            try {
                this.initIncompleteFile();
            }
            catch (FileHandlingException fileHandlingException) {
                NLogger.error("Download", (Object)fileHandlingException, (Throwable)fileHandlingException);
            }
            List list = MagnetData.lookupHttpURIs(magnetData);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                URI uRI2 = (URI)iterator.next();
                String string5 = uRI2.getHost();
                int n = uRI2.getPort();
                if (n == -1) {
                    n = 80;
                }
                DefaultDestAddress defaultDestAddress = new DefaultDestAddress(string5, n);
                SWDownloadCandidate sWDownloadCandidate = new SWDownloadCandidate(defaultDestAddress, uRI2, this);
                this.addDownloadCandidate(sWDownloadCandidate);
            }
            if (uRN != null || this.getCandidatesCount() == 0) {
                this.startSearchForCandidates();
            }
        } else {
            String string6 = URLUtil.getFileNameFromUri(this.downloadURI);
            String string7 = ServiceManager.sCfg.mDownloadDir + File.separator + FileUtils.convertToLocalSystemFilename(string6);
            String string8 = StringUtils.createNaturalSearchTerm(string6);
            this.initialize(string7, null, -1L, string8, true);
            try {
                this.initIncompleteFile();
            }
            catch (FileHandlingException fileHandlingException) {
                NLogger.error("Download", (Object)fileHandlingException, (Throwable)fileHandlingException);
            }
            String string9 = this.downloadURI.getHost();
            if (string9 != null) {
                int n = this.downloadURI.getPort();
                if (n == -1) {
                    n = 80;
                }
                DefaultDestAddress defaultDestAddress = new DefaultDestAddress(string9, n);
                SWDownloadCandidate sWDownloadCandidate = new SWDownloadCandidate(defaultDestAddress, this.downloadURI, this);
                this.addDownloadCandidate(sWDownloadCandidate);
            }
        }
    }

    public SWDownloadFile(XJBSWDownloadFile xJBSWDownloadFile) {
        this();
        URN uRN = null;
        if (xJBSWDownloadFile.getFileURN() != null) {
            uRN = new URN(xJBSWDownloadFile.getFileURN());
        }
        this.initialize(ServiceManager.sCfg.mDownloadDir + File.separator + xJBSWDownloadFile.getLocalFileName(), uRN, xJBSWDownloadFile.getFileSize(), xJBSWDownloadFile.getSearchTerm(), false);
        String string = xJBSWDownloadFile.getIncompleteFileName();
        if (!StringUtils.isEmpty(string)) {
            this.incompleteFile = new File(string);
        }
        this.setCreatedDate(new Date(xJBSWDownloadFile.getCreatedTime()));
        this.setDownloadedDate(new Date(xJBSWDownloadFile.getModifiedTime()));
        this.setScopeSelectionStrategy(ScopeSelectionStrategyProvider.getByClassName(xJBSWDownloadFile.getScopeSelectionStrategy()));
        this.status = xJBSWDownloadFile.getStatus();
        this.createDownloadScopes(xJBSWDownloadFile);
        this.createDownloadCandidates(xJBSWDownloadFile);
        this.forceCollectionOfTransferData();
        this.verifyStatus();
        if (this.isFileCompletedOrMoved()) {
            this.transferredDataSize = this.fileSize;
            if (this.isFileCompleted() && this.finishedScopeList.getAggregatedLength() == 0L) {
                this.setStatus((short)6);
            }
        }
    }

    private void initialize(String string, URN uRN, long l, String string2, boolean bl) {
        this.destinationFile = new File(string);
        this.updateDestinationData();
        this.scopeSelectionStrategy = ScopeSelectionStrategyProvider.getAvailBeginRandSelectionStrategy();
        if (uRN != null) {
            this.fileURN = uRN;
            this.initAltLocContainers();
        }
        this.fileSize = l;
        this.previewSize = this.fileSize / 10L;
        this.researchSetting = new ResearchSetting(this);
        this.researchSetting.setSearchTerm(string2);
        this.missingScopeList = new DownloadScopeList();
        this.blockedScopeList = new DownloadScopeList();
        this.finishedScopeList = new DownloadScopeList();
        if (this.fileSize == -1L) {
            this.missingScopeList.add(new DownloadScope(0L, Long.MAX_VALUE));
        } else {
            this.missingScopeList.add(new DownloadScope(0L, this.fileSize - 1L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileSize(long l) {
        this.fileSize = l;
        DownloadScopeList downloadScopeList = this.missingScopeList;
        synchronized (downloadScopeList) {
            this.missingScopeList.remove(new DownloadScope(l, Long.MAX_VALUE));
        }
        downloadScopeList = this.blockedScopeList;
        synchronized (downloadScopeList) {
            this.blockedScopeList.remove(new DownloadScope(l, Long.MAX_VALUE));
        }
        this.previewSize = l / 10L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDownloadFinished() {
        DownloadScopeList downloadScopeList = this.finishedScopeList;
        synchronized (downloadScopeList) {
            return this.isFileCompletedOrMoved() || this.finishedScopeList.getAggregatedLength() == this.fileSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScopeAllocateable(DownloadScopeList downloadScopeList) {
        DownloadScopeList downloadScopeList2 = this.missingScopeList;
        synchronized (downloadScopeList2) {
            if (this.missingScopeList.size() == 0) {
                return false;
            }
            if (this.fileSize != -1L && downloadScopeList != null) {
                DownloadScopeList downloadScopeList3 = (DownloadScopeList)this.missingScopeList.clone();
                downloadScopeList3.retainAll(downloadScopeList);
                return downloadScopeList3.size() > 0;
            }
            return true;
        }
    }

    public SWDownloadCandidate allocateDownloadCandidate(SWDownloadWorker sWDownloadWorker) {
        int n = random.nextInt(10);
        SWDownloadCandidate sWDownloadCandidate = null;
        if (n < 6) {
            sWDownloadCandidate = this.allocateGoodCandidate(sWDownloadWorker);
            if (sWDownloadCandidate == null) {
                sWDownloadCandidate = this.allocateMediumCandidate(sWDownloadWorker);
            }
            if (sWDownloadCandidate == null) {
                sWDownloadCandidate = this.allocateBadCandidate(sWDownloadWorker);
            }
        } else if (n < 9) {
            sWDownloadCandidate = this.allocateMediumCandidate(sWDownloadWorker);
            if (sWDownloadCandidate == null) {
                sWDownloadCandidate = this.allocateBadCandidate(sWDownloadWorker);
            }
            if (sWDownloadCandidate == null) {
                sWDownloadCandidate = this.allocateGoodCandidate(sWDownloadWorker);
            }
        } else {
            sWDownloadCandidate = this.allocateBadCandidate(sWDownloadWorker);
            if (sWDownloadCandidate == null) {
                sWDownloadCandidate = this.allocateMediumCandidate(sWDownloadWorker);
            }
            if (sWDownloadCandidate == null) {
                sWDownloadCandidate = this.allocateGoodCandidate(sWDownloadWorker);
            }
        }
        return sWDownloadCandidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SWDownloadCandidate allocateGoodCandidate(SWDownloadWorker sWDownloadWorker) {
        SWDownloadCandidate sWDownloadCandidate = null;
        Object object = this.candidatesLock;
        synchronized (object) {
            int n = this.goodCandidatesList.size();
            if (n == 0) {
                return null;
            }
            if (this.goodCandidatePosition >= n) {
                this.goodCandidatePosition = 0;
            }
            for (int i = 0; i < n; ++i) {
                int n2 = i + this.goodCandidatePosition;
                if (n2 >= n) {
                    n2 -= n;
                }
                if (!(sWDownloadCandidate = (SWDownloadCandidate)this.goodCandidatesList.get(n2)).isAbleToBeAllocated() || this.allocatedCandidateWorkerMap.containsKey(sWDownloadCandidate)) continue;
                NLogger.debug("Download.Candidate.Allocate", (Object)("Allocating good candidate " + sWDownloadCandidate + " from " + sWDownloadWorker));
                sWDownloadCandidate.addToCandidateLog("Allocating as good candidate.");
                this.allocatedCandidateWorkerMap.put(sWDownloadCandidate, sWDownloadWorker);
                this.goodCandidatePosition = n2 + 1;
                return sWDownloadCandidate;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SWDownloadCandidate allocateMediumCandidate(SWDownloadWorker sWDownloadWorker) {
        SWDownloadCandidate sWDownloadCandidate = null;
        Object object = this.candidatesLock;
        synchronized (object) {
            int n = this.mediumCandidatesList.size();
            if (n == 0) {
                return null;
            }
            if (this.mediumCandidatePosition >= n) {
                this.mediumCandidatePosition = 0;
            }
            for (int i = 0; i < n; ++i) {
                int n2 = i + this.mediumCandidatePosition;
                if (n2 >= n) {
                    n2 -= n;
                }
                if (!(sWDownloadCandidate = (SWDownloadCandidate)this.mediumCandidatesList.get(n2)).isAbleToBeAllocated() || this.allocatedCandidateWorkerMap.containsKey(sWDownloadCandidate)) continue;
                NLogger.debug("Download.Candidate.Allocate", (Object)("Allocating medium candidate " + sWDownloadCandidate + " from " + sWDownloadWorker));
                sWDownloadCandidate.addToCandidateLog("Allocating as medium candidate.");
                this.allocatedCandidateWorkerMap.put(sWDownloadCandidate, sWDownloadWorker);
                this.mediumCandidatePosition = n2 + 1;
                return sWDownloadCandidate;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SWDownloadCandidate allocateBadCandidate(SWDownloadWorker sWDownloadWorker) {
        SWDownloadCandidate sWDownloadCandidate = null;
        Object object = this.candidatesLock;
        synchronized (object) {
            int n = this.badCandidatesList.size();
            if (n == 0) {
                return null;
            }
            if (this.badCandidatePosition >= n) {
                this.badCandidatePosition = 0;
            }
            for (int i = 0; i < n; ++i) {
                int n2 = i + this.badCandidatePosition;
                if (n2 >= n) {
                    n2 -= n;
                }
                if (!(sWDownloadCandidate = (SWDownloadCandidate)this.badCandidatesList.get(n2)).isAbleToBeAllocated() || this.allocatedCandidateWorkerMap.containsKey(sWDownloadCandidate)) continue;
                NLogger.debug("Download.Candidate.Allocate", (Object)("Allocating bad candidate " + sWDownloadCandidate + " from " + sWDownloadWorker));
                sWDownloadCandidate.addToCandidateLog("Allocating as bad candidate.");
                this.allocatedCandidateWorkerMap.put(sWDownloadCandidate, sWDownloadWorker);
                this.badCandidatePosition = n2 + 1;
                return sWDownloadCandidate;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDownloadCandidate(SWDownloadCandidate sWDownloadCandidate) {
        Object object = this.candidatesLock;
        synchronized (object) {
            SwarmingManager.getInstance().releaseCandidateIP(sWDownloadCandidate);
            NLogger.debug("Download.Candidate.Allocate", (Object)("Release allocation " + sWDownloadCandidate + "."));
            this.allocatedCandidateWorkerMap.remove(sWDownloadCandidate);
        }
    }

    public boolean addDownloadCandidate(RemoteFile remoteFile) {
        SWDownloadCandidate sWDownloadCandidate = new SWDownloadCandidate(remoteFile, this);
        return this.addDownloadCandidate(sWDownloadCandidate);
    }

    public boolean addDownloadCandidate(AlternateLocation alternateLocation) {
        URN uRN = alternateLocation.getURN();
        if (this.fileURN != null && !uRN.equals(this.fileURN)) {
            NLogger.debug("Download_File", (Object)"AlternateLocation URN does not match!");
            return false;
        }
        DestAddress destAddress = alternateLocation.getHostAddress();
        if (destAddress.isLocalHost()) {
            return false;
        }
        SWDownloadCandidate sWDownloadCandidate = new SWDownloadCandidate(destAddress, 0L, null, uRN, this);
        return this.addDownloadCandidate(sWDownloadCandidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addDownloadCandidate(SWDownloadCandidate sWDownloadCandidate) {
        URN uRN = sWDownloadCandidate.getResourceURN();
        if (this.fileURN == null && uRN != null) {
            this.fileURN = uRN;
            this.initAltLocContainers();
        }
        if (this.fileURN != null && uRN != null && !this.fileURN.equals(uRN)) {
            NLogger.debug("Download_File", (Object)"Candidate URN to add does not match!");
            return false;
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            if (this.allCandidatesList.contains(sWDownloadCandidate)) {
                return false;
            }
            NLogger.debug("Download_File", (Object)("Adding download candidate " + sWDownloadCandidate));
            int n = this.allCandidatesList.size();
            this.allCandidatesList.add(sWDownloadCandidate);
            this.fireDownloadCandidateAdded(n);
            this.mediumCandidatesList.add(sWDownloadCandidate);
        }
        SwarmingManager.getInstance().notifyWaitingWorkers();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCandidateGood(SWDownloadCandidate sWDownloadCandidate) {
        if (sWDownloadCandidate == null) {
            throw new NullPointerException("Candidate is null.");
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            int n = this.badCandidatesList.indexOf(sWDownloadCandidate);
            if (n >= 0) {
                this.badCandidatesList.remove(n);
            }
            if ((n = this.mediumCandidatesList.indexOf(sWDownloadCandidate)) >= 0) {
                this.mediumCandidatesList.remove(n);
            }
            if (!this.goodCandidatesList.contains(sWDownloadCandidate)) {
                this.goodCandidatesList.add(sWDownloadCandidate);
                NLogger.debug("Download_File", (Object)("Moving candidate to good list: " + sWDownloadCandidate.getHostAddress()));
                sWDownloadCandidate.addToCandidateLog("Moving candidate to good list.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCandidateMedium(SWDownloadCandidate sWDownloadCandidate) {
        if (sWDownloadCandidate == null) {
            throw new NullPointerException("Candidate is null.");
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            int n = this.badCandidatesList.indexOf(sWDownloadCandidate);
            if (n >= 0) {
                this.badCandidatesList.remove(n);
            }
            if ((n = this.goodCandidatesList.indexOf(sWDownloadCandidate)) >= 0) {
                this.goodCandidatesList.remove(n);
            }
            if (!this.mediumCandidatesList.contains(sWDownloadCandidate)) {
                this.mediumCandidatesList.add(sWDownloadCandidate);
                NLogger.debug("Download_File", (Object)("Moving candidate to medium list: " + sWDownloadCandidate.getHostAddress()));
                sWDownloadCandidate.addToCandidateLog("Moving candidate to medium list.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCandidateBad(SWDownloadCandidate sWDownloadCandidate) {
        if (sWDownloadCandidate == null) {
            throw new NullPointerException("Candidate is null.");
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            int n = this.goodCandidatesList.indexOf(sWDownloadCandidate);
            if (n >= 0) {
                this.goodCandidatesList.remove(n);
            }
            if ((n = this.mediumCandidatesList.indexOf(sWDownloadCandidate)) >= 0) {
                this.mediumCandidatesList.remove(n);
            }
            if (!this.badCandidatesList.contains(sWDownloadCandidate)) {
                this.badCandidatesList.add(sWDownloadCandidate);
                NLogger.debug("Download_File", (Object)("Moving candidate to bad list: " + sWDownloadCandidate.getHostAddress()));
                sWDownloadCandidate.addToCandidateLog("Moving candidate to bad list.");
            }
        }
        sWDownloadCandidate.setStatus((short)11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCandidateIgnored(SWDownloadCandidate sWDownloadCandidate, String string) {
        if (sWDownloadCandidate == null) {
            throw new NullPointerException("Candidate is null.");
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            int n = this.goodCandidatesList.indexOf(sWDownloadCandidate);
            if (n >= 0) {
                this.goodCandidatesList.remove(n);
            }
            if ((n = this.mediumCandidatesList.indexOf(sWDownloadCandidate)) >= 0) {
                this.mediumCandidatesList.remove(n);
            }
            if (!this.badCandidatesList.contains(sWDownloadCandidate)) {
                this.badCandidatesList.add(sWDownloadCandidate);
                NLogger.debug("Download_File", (Object)("Moving candidate to bad list: " + sWDownloadCandidate.getHostAddress()));
                sWDownloadCandidate.addToCandidateLog("Moving candidate to bad list (ignoring).");
            }
        }
        sWDownloadCandidate.setStatus((short)10, -1, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void candidateStatusChanged(SWDownloadCandidate sWDownloadCandidate, int n, int n2) {
        Object object = this.candidatesLock;
        synchronized (object) {
            switch (n) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    this.transferCandidatesList.remove(sWDownloadCandidate);
                }
            }
            switch (n2) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    this.transferCandidatesList.add(sWDownloadCandidate);
                }
            }
        }
        this.fireDownloadCandidateChanged(sWDownloadCandidate);
    }

    public void addBadAltLoc(SWDownloadCandidate sWDownloadCandidate) {
        URN uRN = sWDownloadCandidate.getResourceURN();
        if (uRN != null && this.fileURN != null) {
            AlternateLocation alternateLocation = new AlternateLocation(sWDownloadCandidate.getHostAddress(), uRN);
            this.goodAltLocContainer.removeAlternateLocation(alternateLocation);
            this.badAltLocContainer.addAlternateLocation(alternateLocation);
        }
        NLogger.debug("Download_File", (Object)("Adding bad alt loc: " + sWDownloadCandidate.getHostAddress()));
    }

    public void addGoodAltLoc(SWDownloadCandidate sWDownloadCandidate) {
        URN uRN = sWDownloadCandidate.getResourceURN();
        if (uRN != null && this.fileURN != null) {
            AlternateLocation alternateLocation = new AlternateLocation(sWDownloadCandidate.getHostAddress(), uRN);
            this.badAltLocContainer.removeAlternateLocation(alternateLocation);
            this.goodAltLocContainer.addAlternateLocation(alternateLocation);
        }
        NLogger.debug("Download_File", (Object)("Adding good alt loc: " + sWDownloadCandidate.getHostAddress()));
    }

    public BandwidthController getBandwidthController() {
        return this.bandwidthController;
    }

    public void setDownloadThrottlingRate(int n) {
        this.bandwidthController.setThrottlingRate(n);
    }

    public long getDownloadThrottlingRate() {
        return this.bandwidthController.getThrottlingRate();
    }

    public long getTransferSpeed() {
        return this.bandwidthController.getShortTransferAvg().getAverage();
    }

    public int getCandidatesCount() {
        return this.allCandidatesList.size();
    }

    public IntObj getCandidatesCountObject() {
        if (this.candidateCountObj.intValue() != this.allCandidatesList.size()) {
            this.candidateCountObj.setValue(this.allCandidatesList.size());
        }
        return this.candidateCountObj;
    }

    public int getDownloadingCandidatesCount() {
        this.updateCandidateWorkerCounts();
        return this.downloadingCandidateCount;
    }

    public int getQueuedCandidatesCount() {
        this.updateCandidateWorkerCounts();
        return this.queuedCandidateCount;
    }

    public int getConnectingCandidatesCount() {
        this.updateCandidateWorkerCounts();
        return this.connectingCandidateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCandidateWorkerCounts() {
        Object object = this.candidatesLock;
        synchronized (object) {
            long l = System.currentTimeMillis();
            if (this.lastCandidateWorkerCountUpdate + 2000L > l) {
                return;
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            Iterator iterator = this.transferCandidatesList.iterator();
            while (iterator.hasNext()) {
                SWDownloadCandidate sWDownloadCandidate = (SWDownloadCandidate)iterator.next();
                short s = sWDownloadCandidate.getStatus();
                switch (s) {
                    case 20: {
                        ++n;
                        break;
                    }
                    case 18: {
                        ++n2;
                        break;
                    }
                    case 16: {
                        ++n3;
                    }
                }
            }
            this.queuedCandidateCount = n2;
            this.downloadingCandidateCount = n;
            this.connectingCandidateCount = n3;
            this.lastCandidateWorkerCountUpdate = System.currentTimeMillis();
        }
    }

    public int getGoodCandidateCount() {
        return this.goodCandidatesList.size();
    }

    public int getBadCandidateCount() {
        return this.badCandidatesList.size();
    }

    public SWDownloadCandidate getCandidate(int n) {
        if (n < 0 || n >= this.allCandidatesList.size()) {
            return null;
        }
        return (SWDownloadCandidate)this.allCandidatesList.get(n);
    }

    public AltLocContainer getGoodAltLocContainer() {
        return this.goodAltLocContainer;
    }

    public AltLocContainer getBadAltLocContainer() {
        return this.badAltLocContainer;
    }

    public int getTransferCandidateCount() {
        return this.transferCandidatesList.size();
    }

    public SWDownloadCandidate getTransferCandidate(int n) {
        if (n < 0 || n >= this.transferCandidatesList.size()) {
            return null;
        }
        return (SWDownloadCandidate)this.transferCandidatesList.get(n);
    }

    public void setScopeSelectionStrategy(ScopeSelectionStrategy scopeSelectionStrategy) {
        this.scopeSelectionStrategy = scopeSelectionStrategy;
    }

    public ScopeSelectionStrategy getScopeSelectionStrategy() {
        return this.scopeSelectionStrategy;
    }

    public URI getURI() {
        return this.downloadURI;
    }

    public URN getFileURN() {
        return this.fileURN;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    protected void setCreatedDate(Date date) {
        this.createdDate = date;
    }

    public Date getDownloadedDate() {
        return this.modifiedDate;
    }

    protected void setDownloadedDate(Date date) {
        this.modifiedDate = date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPRangeSet createAvailableRangeSet() {
        HTTPRangeSet hTTPRangeSet = new HTTPRangeSet();
        DownloadScopeList downloadScopeList = this.finishedScopeList;
        synchronized (downloadScopeList) {
            Iterator iterator = this.finishedScopeList.getScopeIterator();
            while (iterator.hasNext()) {
                DownloadScope downloadScope = (DownloadScope)iterator.next();
                hTTPRangeSet.addRange(downloadScope.getStart(), downloadScope.getEnd());
            }
        }
        return hTTPRangeSet;
    }

    public ResearchSetting getResearchSetting() {
        return this.researchSetting;
    }

    public void startSearchForCandidates() {
        if (this.isFileCompletedOrMoved()) {
            return;
        }
        this.researchSetting.stopSearch();
        this.researchSetting.startSearch(300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(short s) {
        if (this.status == s) {
            return;
        }
        Object object = this.candidatesLock;
        synchronized (object) {
            NLogger.debug("Download_File", (Object)("DownloadFile Status: " + SWDownloadInfo.getDownloadFileStatusString(s) + " (" + s + ")."));
            switch (s) {
                case 3: {
                    SimpleStatisticProvider simpleStatisticProvider = (SimpleStatisticProvider)StatisticsManager.getInstance().getStatisticProvider("SessionDownloadCountProvider");
                    simpleStatisticProvider.increment(1);
                }
                case 1: 
                case 4: {
                    this.downloadStopNotify();
                    break;
                }
                case 2: {
                    this.downloadStartNotify();
                }
            }
            this.status = s;
            SwarmingManager.getInstance().fireDownloadFileChanged(this);
        }
    }

    public short getStatus() {
        return this.status;
    }

    public boolean isAbleToBeAllocated() {
        return !this.isDownloadStopped() && !this.isFileCompletedOrMoved() && this.workerCount <= ServiceManager.sCfg.maxWorkerPerDownload;
    }

    public void incrementWorkerCount() {
        this.workerCount = (short)(this.workerCount + 1);
    }

    public void decrementWorkerCount() {
        this.workerCount = (short)(this.workerCount - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyStatus() {
        this.forceCollectionOfTransferData();
        Object object = this.candidatesLock;
        synchronized (object) {
            if (!this.isFileCompletedOrMoved() && this.getTransferDataSize() == this.getTransferredDataSize()) {
                this.setStatus((short)3);
                this.researchSetting.stopSearch();
                return;
            }
            Iterator iterator = this.allocatedCandidateWorkerMap.keySet().iterator();
            int n = 12;
            while (iterator.hasNext() && n != 20) {
                SWDownloadCandidate sWDownloadCandidate = (SWDownloadCandidate)iterator.next();
                switch (sWDownloadCandidate.getStatus()) {
                    case 20: {
                        n = 20;
                        break;
                    }
                    case 18: {
                        n = 18;
                    }
                }
            }
            if (!this.isDownloadStopped() && !this.isFileCompletedOrMoved()) {
                switch (n) {
                    case 18: {
                        this.setStatus((short)5);
                        break;
                    }
                    case 20: {
                        this.setStatus((short)2);
                        break;
                    }
                    default: {
                        this.setStatus((short)1);
                    }
                }
            }
        }
    }

    public boolean isFileCompleted() {
        return this.status == 3;
    }

    public boolean isFileCompletedMoved() {
        return this.status == 6;
    }

    public boolean isFileCompletedOrMoved() {
        return this.status == 6 || this.status == 3;
    }

    public boolean isDownloadInProgress() {
        return this.status == 2;
    }

    public boolean isDownloadStopped() {
        return this.status == 4;
    }

    public ManagedFile getIncompleteDownloadFile() throws ManagedFileException, FileHandlingException {
        this.initIncompleteFile();
        return FileManager.getInstance().getReadWriteManagedFile(this.incompleteFile);
    }

    public File getIncompleteFile() {
        return this.incompleteFile;
    }

    public File getDestinationFile() {
        return this.destinationFile;
    }

    public String getDestinationFileName() {
        return this.destinationFile.getName();
    }

    public boolean isDestinationStreamable() {
        return this.isDestStreamable;
    }

    public void setDestinationFile(File file, boolean bl) throws FileHandlingException {
        if (file.compareTo(this.destinationFile) == 0) {
            return;
        }
        if (bl) {
            if (SwarmingManager.getInstance().isNewLocalFilenameUsed(this, file)) {
                throw new FileHandlingException(1);
            }
            this.initIncompleteFile();
            File file2 = SWDownloadFile.createIncompleteFile(file);
            if (this.incompleteFile.exists()) {
                FileUtils.renameLocalFile(this.incompleteFile, file2);
            }
            this.incompleteFile = file2;
            FileUtils.renameLocalFile(this.destinationFile, file);
        }
        this.destinationFile = file;
        this.updateDestinationData();
    }

    private void updateDestinationData() {
        this.isDestStreamable = MediaType.getStreamableMediaType().isFilenameOf(this.getDestinationFileName());
    }

    public File getPreviewFile() {
        if (this.isFileCompletedOrMoved()) {
            return this.destinationFile;
        }
        if (this.finishedScopeList.size() == 0) {
            return null;
        }
        DownloadScope downloadScope = this.finishedScopeList.getScopeAt(0);
        if (downloadScope.getStart() != 0L) {
            return null;
        }
        long l = downloadScope.getEnd();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ServiceManager.sCfg.incompleteDir);
        stringBuffer.append(File.separatorChar);
        stringBuffer.append("PREVIEW");
        stringBuffer.append("-");
        stringBuffer.append(this.destinationFile.getName());
        File file = new File(stringBuffer.toString());
        file.deleteOnExit();
        try {
            FileUtils.copyFile(this.incompleteFile, file, l);
            return file;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean isPreviewPossible() {
        if (this.isFileCompletedOrMoved()) {
            return true;
        }
        if (this.finishedScopeList.size() == 0) {
            return false;
        }
        DownloadScope downloadScope = this.finishedScopeList.getScopeAt(0);
        return downloadScope.getStart() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveToDestinationFile() {
        boolean bl = false;
        DownloadScopeList downloadScopeList = this.missingScopeList;
        synchronized (downloadScopeList) {
            Object object;
            if (this.isFileCompletedMoved()) {
                return;
            }
            if (this.missingScopeList.size() > 0 && this.status == 3) {
                throw new RuntimeException("There must be exactly one download segment (found " + this.missingScopeList.size() + ") and the download must be completed to move to destination file '" + this.destinationFile.getName() + "'");
            }
            File file = this.destinationFile;
            if (!file.isAbsolute()) {
                file = new File(ServiceManager.sCfg.mDownloadDir, this.destinationFile.getName());
            }
            int n = 0;
            while (file.exists()) {
                ++n;
                object = new StringBuffer();
                ((StringBuffer)object).append(this.destinationFile.getParent());
                ((StringBuffer)object).append(File.separatorChar);
                ((StringBuffer)object).append('(');
                ((StringBuffer)object).append(n);
                ((StringBuffer)object).append(") ");
                ((StringBuffer)object).append(this.destinationFile.getName());
                file = new File(((StringBuffer)object).toString());
            }
            NLogger.debug("Download_File", (Object)("Renaming final segment from " + this.incompleteFile.getAbsolutePath() + " to " + file.getAbsoluteFile() + "."));
            bl = this.incompleteFile.renameTo(file);
            if (bl) {
                NLogger.debug("Download_File", (Object)("File " + this.destinationFile.getName() + " has been moved to its final location"));
            } else {
                NLogger.debug("Download_File", (Object)("Renaming from " + this.incompleteFile.getAbsolutePath() + " to " + file.getAbsolutePath() + " failed."));
            }
            this.setStatus((short)6);
            if (bl) {
                object = new Executer(this.destinationFile, ServiceManager.sCfg.completionNotifyMethod);
                ThreadPool.getInstance().addJob((Runnable)object, "DownloadExecuter");
            }
            if (bl && ServiceManager.sCfg.autoReadoutDownloadedMagma && file.getName().endsWith(".magma")) {
                try {
                    SwarmingManager.getInstance().addMagmaToDownload(file);
                }
                catch (IOException iOException) {
                    NLogger.error("MAGMA", (Object)iOException.getMessage(), (Throwable)iOException);
                }
            }
        }
        if (ServiceManager.sCfg.mDownloadAutoRemoveCompleted) {
            SwarmingManager.getInstance().removeDownloadFile(this);
        } else {
            SwarmingManager.getInstance().notifyDownloadListChange();
        }
    }

    public Integer getProgress() {
        long l;
        int n = this.isFileCompletedOrMoved() ? 100 : ((l = this.fileSize) == -1L || l == 0L ? -1 : (int)(this.transferredDataSize * 100L / l));
        if (this.currentProgress != n) {
            this.currentProgress = new Integer(n);
        }
        return this.currentProgress;
    }

    public void startDownload() {
        this.setStatus((short)1);
        this.verifyStatus();
        SwarmingManager.getInstance().notifyWaitingWorkers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDownload(SWDownloadCandidate sWDownloadCandidate) {
        SWDownloadWorker sWDownloadWorker;
        Object object = this.candidatesLock;
        synchronized (object) {
            sWDownloadWorker = (SWDownloadWorker)this.allocatedCandidateWorkerMap.get(sWDownloadCandidate);
        }
        if (sWDownloadWorker != null) {
            sWDownloadWorker.stopWorker();
            sWDownloadWorker.waitTillFinished();
        }
    }

    public void stopDownload() {
        this.setStatus((short)4);
        this.stopAllWorkers(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllWorkers(boolean bl) {
        SWDownloadWorker[] sWDownloadWorkerArray;
        Object object;
        Object object2 = this.candidatesLock;
        synchronized (object2) {
            object = this.allocatedCandidateWorkerMap.values();
            sWDownloadWorkerArray = new SWDownloadWorker[object.size()];
            object.toArray(sWDownloadWorkerArray);
            for (int i = 0; i < sWDownloadWorkerArray.length; ++i) {
                SWDownloadWorker sWDownloadWorker = sWDownloadWorkerArray[i];
                sWDownloadWorker.stopWorker();
            }
        }
        if (!bl) {
            return;
        }
        for (int i = 0; i < sWDownloadWorkerArray.length; ++i) {
            object = sWDownloadWorkerArray[i];
            if (!((SWDownloadWorker)object).isInsideCriticalSection()) continue;
            ((SWDownloadWorker)object).waitTillFinished();
        }
    }

    public void removeIncompleteDownloadFile() {
        boolean bl;
        if (this.isFileCompletedOrMoved()) {
            return;
        }
        if (this.status != 4) {
            NLogger.error("Download_File", "Can't clean temp files of not stopped download file.");
            return;
        }
        this.stopAllWorkers(true);
        if (this.incompleteFile != null && this.incompleteFile.exists() && !(bl = this.incompleteFile.delete())) {
            NLogger.debug("Download.Segment", (Object)("Segment " + this.toString() + ": Failed to delete " + this.incompleteFile + "."));
        }
    }

    private void downloadStartNotify() {
        this.transferStartTime = System.currentTimeMillis();
        this.modifiedDate = new Date(this.transferStartTime);
        this.transferStopTime = 0L;
    }

    private void downloadStopNotify() {
        if (this.transferStopTime == 0L) {
            this.transferStopTime = System.currentTimeMillis();
            if (this.status == 2) {
                this.modifiedDate = new Date(this.transferStopTime);
            }
        }
        SwarmingManager.getInstance().notifyDownloadListChange();
        try {
            this.getIncompleteDownloadFile().closeFile();
        }
        catch (FileHandlingException fileHandlingException) {
            NLogger.error("Download_File", (Object)fileHandlingException, (Throwable)fileHandlingException);
        }
        catch (ManagedFileException managedFileException) {
            if (managedFileException.getCause() instanceof InterruptedException) {
                NLogger.debug("Download_File", (Object)managedFileException);
            }
            NLogger.error("Download_File", (Object)managedFileException, (Throwable)managedFileException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceCollectionOfTransferData() {
        long l = 0L;
        Object object = this.finishedScopeList;
        synchronized (object) {
            l = this.finishedScopeList.getAggregatedLength();
        }
        object = this.transferCandidatesList.iterator();
        while (object.hasNext()) {
            SWDownloadCandidate sWDownloadCandidate = (SWDownloadCandidate)object.next();
            SWDownloadSegment sWDownloadSegment = sWDownloadCandidate.getDownloadSegment();
            if (sWDownloadSegment == null) continue;
            l += sWDownloadSegment.getTransferredDataSize();
        }
        this.transferredDataSize = l;
        this.transferDataUpdateTime = System.currentTimeMillis() + 1000L;
    }

    private void lazyCollectTransferData() {
        long l = System.currentTimeMillis();
        if (this.isFileCompletedOrMoved() || this.transferDataUpdateTime > l) {
            return;
        }
        this.forceCollectionOfTransferData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadScopeList getMissingScopeList() {
        DownloadScopeList downloadScopeList = this.missingScopeList;
        synchronized (downloadScopeList) {
            return this.missingScopeList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadScopeList getFinishedScopeList() {
        DownloadScopeList downloadScopeList = this.finishedScopeList;
        synchronized (downloadScopeList) {
            return this.finishedScopeList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadScopeList getBlockedScopeList() {
        DownloadScopeList downloadScopeList = this.blockedScopeList;
        synchronized (downloadScopeList) {
            return this.blockedScopeList;
        }
    }

    public RatedDownloadScopeList getRatedScopeList() {
        long l = System.currentTimeMillis();
        if (this.ratedScopeListBuildTime + 120000L > l) {
            return this.ratedScopeList;
        }
        if (this.ratedScopeList == null) {
            this.ratedScopeList = new RatedDownloadScopeList();
        } else {
            this.ratedScopeList.clear();
        }
        this.ratedScopeList.addAll(this.missingScopeList);
        this.rateDownloadScopeList(this.ratedScopeList);
        this.ratedScopeListBuildTime = System.currentTimeMillis();
        return this.ratedScopeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rateDownloadScopeList(RatedDownloadScopeList ratedDownloadScopeList) {
        long l = System.currentTimeMillis() - 10800000L;
        Object object = this.candidatesLock;
        synchronized (object) {
            Iterator iterator = this.goodCandidatesList.iterator();
            while (iterator.hasNext()) {
                SWDownloadCandidate sWDownloadCandidate = (SWDownloadCandidate)iterator.next();
                if (sWDownloadCandidate.getLastConnectionTime() == 0L || sWDownloadCandidate.getLastConnectionTime() < l) continue;
                DownloadScopeList downloadScopeList = sWDownloadCandidate.getAvailableScopeList();
                if (downloadScopeList == null) {
                    downloadScopeList = new DownloadScopeList();
                    downloadScopeList.add(new DownloadScope(0L, this.fileSize - 1L));
                }
                ratedDownloadScopeList.rateDownloadScopeList(downloadScopeList, sWDownloadCandidate.getSpeed());
            }
        }
    }

    public DownloadScope allocateDownloadScope(DownloadScopeList downloadScopeList, long l, long l2) {
        boolean bl;
        DownloadScope downloadScope = null;
        do {
            bl = false;
            if (this.fileSize != -1L) {
                downloadScope = this.allocateSegmentForRangeSet(downloadScopeList, l);
                NLogger.debug("Download.Segment.Allocate", (Object)("Allocated: " + downloadScope));
                continue;
            }
            downloadScope = this.allocateSegment(l);
            NLogger.debug("Download.Segment.Allocate", (Object)("Allocated: " + downloadScope));
        } while (bl);
        return downloadScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadScope allocateSegment(long l) {
        NLogger.debug("Download.Segment.Allocate", (Object)("allocateSegment() size:" + l));
        DownloadScopeList downloadScopeList = this.missingScopeList;
        synchronized (downloadScopeList) {
            Iterator iterator = this.missingScopeList.getScopeIterator();
            if (iterator.hasNext()) {
                DownloadScope downloadScope = (DownloadScope)iterator.next();
                this.missingScopeList.remove(downloadScope);
                Object object = downloadScope;
                synchronized (object) {
                    if (this.fileSize != -1L && downloadScope.getLength() > l) {
                        DownloadScope downloadScope2 = new DownloadScope(downloadScope.getStart(), downloadScope.getStart() + l - 1L);
                        DownloadScope downloadScope3 = new DownloadScope(downloadScope.getStart() + l, downloadScope.getEnd());
                        this.missingScopeList.add(downloadScope3);
                        downloadScope = downloadScope2;
                    }
                }
                object = this.blockedScopeList;
                synchronized (object) {
                    this.blockedScopeList.add(downloadScope);
                }
                return downloadScope;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadScope allocateSegmentForRangeSet(DownloadScopeList downloadScopeList, long l) {
        if (!$assertionsDisabled && this.fileSize == -1L) {
            throw new AssertionError((Object)"Cant allocate segment for range set with unknown end.");
        }
        NLogger.debug("Download.Segment.Allocate", (Object)("allocateSegmentForRangeSet() size: " + l));
        if (downloadScopeList == null) {
            downloadScopeList = new DownloadScopeList();
            downloadScopeList.add(new DownloadScope(0L, this.fileSize - 1L));
        }
        DownloadScopeList downloadScopeList2 = this.missingScopeList;
        synchronized (downloadScopeList2) {
            DownloadScopeList downloadScopeList3 = (DownloadScopeList)this.missingScopeList.clone();
            downloadScopeList3.addAll(this.missingScopeList);
            downloadScopeList3.retainAll(downloadScopeList);
            if (downloadScopeList3.size() == 0) {
                return null;
            }
            DownloadScope downloadScope = this.scopeSelectionStrategy.selectDownloadScope(this, downloadScopeList3, l);
            if (downloadScope == null) {
                return null;
            }
            this.missingScopeList.remove(downloadScope);
            DownloadScopeList downloadScopeList4 = this.blockedScopeList;
            synchronized (downloadScopeList4) {
                this.blockedScopeList.add(downloadScope);
            }
            return downloadScope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDownloadScope(DownloadScope downloadScope, SWDownloadSegment sWDownloadSegment) {
        if (downloadScope.getEnd() == Long.MAX_VALUE && this.fileSize != -1L) {
            downloadScope = new DownloadScope(downloadScope.getStart(), this.fileSize - 1L);
        }
        DownloadScope downloadScope2 = null;
        DownloadScope downloadScope3 = null;
        long l = sWDownloadSegment.getTransferredDataSize();
        if (l == 0L) {
            downloadScope3 = downloadScope;
        } else {
            downloadScope2 = new DownloadScope(downloadScope.getStart(), downloadScope.getStart() + l - 1L);
            if (l < downloadScope.getLength()) {
                downloadScope3 = new DownloadScope(downloadScope.getStart() + l, downloadScope.getEnd());
            }
        }
        DownloadScopeList downloadScopeList = this.blockedScopeList;
        synchronized (downloadScopeList) {
            this.blockedScopeList.remove(downloadScope);
        }
        downloadScopeList = this.missingScopeList;
        synchronized (downloadScopeList) {
            if (downloadScope3 != null) {
                this.missingScopeList.add(downloadScope3);
            }
        }
        downloadScopeList = this.finishedScopeList;
        synchronized (downloadScopeList) {
            if (downloadScope2 != null) {
                this.finishedScopeList.add(downloadScope2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAndValidateQueuedCandidate(SWDownloadCandidate sWDownloadCandidate) {
        int n = Math.min(ServiceManager.sCfg.maxTotalDownloadWorker, ServiceManager.sCfg.maxWorkerPerDownload);
        int n2 = (int)Math.max(Math.floor((double)n - (double)n * 0.2), 1.0);
        Object object = this.candidatesLock;
        synchronized (object) {
            int n3 = this.queuedCandidatesSet.size();
            if (n3 < n2) {
                sWDownloadCandidate.addToCandidateLog("Accept queued candidate (" + n3 + "/" + n2 + ")");
                this.queuedCandidatesSet.add(sWDownloadCandidate);
                return true;
            }
            if (this.queuedCandidatesSet.contains(sWDownloadCandidate)) {
                return true;
            }
            SWDownloadCandidate sWDownloadCandidate2 = null;
            int n4 = -1;
            Iterator iterator = this.queuedCandidatesSet.iterator();
            while (iterator.hasNext()) {
                SWDownloadCandidate sWDownloadCandidate3 = (SWDownloadCandidate)iterator.next();
                int n5 = sWDownloadCandidate3.getXQueueParameters().getPosition();
                if (n5 <= n4) continue;
                sWDownloadCandidate2 = sWDownloadCandidate3;
                n4 = n5;
            }
            int n6 = sWDownloadCandidate.getXQueueParameters().getPosition();
            if (sWDownloadCandidate2 != null && n4 > n6) {
                sWDownloadCandidate2.addToCandidateLog("Drop queued candidate - new alternative: " + n4 + " - " + n6 + ")");
                sWDownloadCandidate2.setStatus((short)14, -1);
                SWDownloadWorker sWDownloadWorker = (SWDownloadWorker)this.allocatedCandidateWorkerMap.get(sWDownloadCandidate2);
                if (sWDownloadWorker != null) {
                    sWDownloadWorker.stopWorker();
                }
                this.queuedCandidatesSet.add(sWDownloadCandidate);
                return true;
            }
            sWDownloadCandidate.addToCandidateLog("Drop queued candidate - existing alternative: " + n6 + " - " + n4);
            sWDownloadCandidate.setStatus((short)14, -1);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueuedCandidate(SWDownloadCandidate sWDownloadCandidate) {
        Object object = this.candidatesLock;
        synchronized (object) {
            this.queuedCandidatesSet.remove(sWDownloadCandidate);
        }
    }

    private void initAltLocContainers() {
        this.goodAltLocContainer = new AltLocContainer(this.fileURN);
        this.badAltLocContainer = new AltLocContainer(this.fileURN);
    }

    private void initIncompleteFile() throws FileHandlingException {
        if (this.incompleteFile != null) {
            return;
        }
        File file = this.getDestinationFile();
        try {
            this.incompleteFile = SWDownloadFile.createIncompleteFile(file);
        }
        catch (FileHandlingException fileHandlingException) {
            String string = fileHandlingException.getFileName();
            Throwable throwable = fileHandlingException.getCause();
            String string2 = throwable != null ? throwable.toString() : "Unknown";
            this.stopDownload();
            Environment.getInstance().fireDisplayUserMessage("SegmentCreateIncompleteFileFailed", new String[]{string, string2});
            throw fileHandlingException;
        }
    }

    public static File createIncompleteFile(File file) throws FileHandlingException {
        File file2;
        boolean bl;
        int n = 0;
        IOException iOException = null;
        do {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(ServiceManager.sCfg.incompleteDir);
            stringBuffer.append(File.separatorChar);
            stringBuffer.append("INCOMPLETE");
            if (n > 0) {
                stringBuffer.append('(');
                stringBuffer.append(String.valueOf(n));
                stringBuffer.append(')');
            }
            stringBuffer.append("-");
            stringBuffer.append(file.getName());
            file2 = new File(stringBuffer.toString());
            file2.getParentFile().mkdirs();
            ++n;
            try {
                bl = file2.createNewFile();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                bl = false;
            }
        } while (!bl && n < 50);
        if (iOException != null) {
            NLogger.error("Download", (Object)iOException, (Throwable)iOException);
        }
        if (!bl) {
            NLogger.error("Download", "Tryied " + n + " times to create a segment file. Giving up");
            throw new FileHandlingException(2, file2.getAbsolutePath(), iOException);
        }
        return file2;
    }

    private void createDownloadScopes(XJBSWDownloadFile xJBSWDownloadFile) {
        this.missingScopeList.clear();
        this.blockedScopeList.clear();
        this.finishedScopeList.clear();
        Iterator iterator = xJBSWDownloadFile.getFinishedScopesList().iterator();
        while (iterator.hasNext()) {
            XJBDownloadScope xJBDownloadScope = (XJBDownloadScope)iterator.next();
            DownloadScope downloadScope = new DownloadScope(xJBDownloadScope.getStart(), xJBDownloadScope.getEnd());
            this.finishedScopeList.add(downloadScope);
        }
        if (this.fileSize == -1L) {
            this.missingScopeList.add(new DownloadScope(0L, Long.MAX_VALUE));
        } else {
            this.missingScopeList.add(new DownloadScope(0L, this.fileSize - 1L));
        }
        this.missingScopeList.removeAll(this.finishedScopeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDownloadCandidates(XJBSWDownloadFile xJBSWDownloadFile) {
        Object object = this.candidatesLock;
        synchronized (object) {
            long l = System.currentTimeMillis() - 86400000L;
            this.allCandidatesList.clear();
            this.goodCandidatesList.clear();
            this.mediumCandidatesList.clear();
            this.badCandidatesList.clear();
            Iterator iterator = xJBSWDownloadFile.getCandidateList().iterator();
            while (iterator.hasNext()) {
                try {
                    XJBSWDownloadCandidate xJBSWDownloadCandidate = (XJBSWDownloadCandidate)iterator.next();
                    SWDownloadCandidate sWDownloadCandidate = new SWDownloadCandidate(xJBSWDownloadCandidate, this);
                    NLogger.debug("Download_File", (Object)("Adding download candidate " + sWDownloadCandidate));
                    int n = this.allCandidatesList.size();
                    this.allCandidatesList.add(sWDownloadCandidate);
                    this.fireDownloadCandidateAdded(n);
                    if (xJBSWDownloadCandidate.getConnectionFailedRepetition() >= 3) {
                        this.badCandidatesList.add(sWDownloadCandidate);
                        continue;
                    }
                    if (xJBSWDownloadCandidate.getLastConnectionTime() > l) {
                        this.goodCandidatesList.add(sWDownloadCandidate);
                        continue;
                    }
                    this.mediumCandidatesList.add(sWDownloadCandidate);
                }
                catch (MalformedDestAddressException malformedDestAddressException) {
                    NLogger.warn("Download_File", (Object)malformedDestAddressException, (Throwable)malformedDestAddressException);
                }
                catch (Exception exception) {
                    NLogger.error("Download_File", (Object)"Error loading a download candidate from XML.", (Throwable)exception);
                }
            }
            Collections.sort(this.goodCandidatesList, new InitialCandidatesComparator());
            Collections.sort(this.mediumCandidatesList, new InitialCandidatesComparator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XJBSWDownloadFile createXJBSWDownloadFile() throws JAXBException {
        Object object;
        Object object2;
        List list;
        ObjectFactory objectFactory = new ObjectFactory();
        XJBSWDownloadFile xJBSWDownloadFile = objectFactory.createXJBSWDownloadFile();
        xJBSWDownloadFile.setLocalFileName(this.destinationFile.getName());
        xJBSWDownloadFile.setIncompleteFileName(this.incompleteFile.getAbsolutePath());
        xJBSWDownloadFile.setFileSize(this.fileSize);
        xJBSWDownloadFile.setSearchTerm(this.researchSetting.getSearchTerm());
        xJBSWDownloadFile.setCreatedTime(this.createdDate.getTime());
        xJBSWDownloadFile.setModifiedTime(this.modifiedDate.getTime());
        if (this.fileURN != null) {
            xJBSWDownloadFile.setFileURN(this.fileURN.getAsString());
        }
        xJBSWDownloadFile.setScopeSelectionStrategy(this.scopeSelectionStrategy.getClass().getName());
        xJBSWDownloadFile.setStatus(this.status);
        Object object3 = this.candidatesLock;
        synchronized (object3) {
            XJBSWDownloadCandidate xJBSWDownloadCandidate;
            list = xJBSWDownloadFile.getCandidateList();
            object2 = this.goodCandidatesList.iterator();
            while (object2.hasNext()) {
                object = (SWDownloadCandidate)object2.next();
                xJBSWDownloadCandidate = ((SWDownloadCandidate)object).createXJBSWDownloadCandidate();
                list.add(xJBSWDownloadCandidate);
            }
            object2 = this.mediumCandidatesList.iterator();
            while (object2.hasNext()) {
                object = (SWDownloadCandidate)object2.next();
                xJBSWDownloadCandidate = ((SWDownloadCandidate)object).createXJBSWDownloadCandidate();
                list.add(xJBSWDownloadCandidate);
            }
            object2 = this.badCandidatesList.iterator();
            while (object2.hasNext()) {
                object = (SWDownloadCandidate)object2.next();
                if (((SWDownloadCandidate)object).getStatus() == 10) continue;
                xJBSWDownloadCandidate = ((SWDownloadCandidate)object).createXJBSWDownloadCandidate();
                list.add(xJBSWDownloadCandidate);
            }
        }
        object3 = this.finishedScopeList.getScopeIterator();
        list = xJBSWDownloadFile.getFinishedScopesList();
        while (object3.hasNext()) {
            object2 = (DownloadScope)object3.next();
            object = objectFactory.createXJBDownloadScope();
            object.setStart(((DownloadScope)object2).getStart());
            object.setEnd(((DownloadScope)object2).getEnd());
            list.add(object);
        }
        return xJBSWDownloadFile;
    }

    public void setTransferRateTimestamp(long l) {
        throw new UnsupportedOperationException();
    }

    public int getShortTermTransferRate() {
        throw new UnsupportedOperationException();
    }

    public int getLongTermTransferRate() {
        return (int)this.getTransferSpeed();
    }

    public short getDataTransferStatus() {
        switch (this.status) {
            case 2: {
                return 10;
            }
            case 3: 
            case 6: {
                return 12;
            }
        }
        return 11;
    }

    public long getTransferDataSize() {
        return this.getTotalDataSize();
    }

    public long getTotalDataSize() {
        return this.fileSize;
    }

    public long getTransferredDataSize() {
        this.lazyCollectTransferData();
        return this.transferredDataSize;
    }

    public void addDownloadCandidatesChangeListener(DownloadCandidatesChangeListener downloadCandidatesChangeListener) {
        this.listenerList.add(DownloadCandidatesChangeListener.class, downloadCandidatesChangeListener);
    }

    public void removeDownloadCandidatesChangeListener(DownloadCandidatesChangeListener downloadCandidatesChangeListener) {
        this.listenerList.remove(DownloadCandidatesChangeListener.class, downloadCandidatesChangeListener);
    }

    private void fireDownloadCandidateChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadCandidatesChangeListener == null ? (class$phex$event$DownloadCandidatesChangeListener = SWDownloadFile.class$("phex.event.DownloadCandidatesChangeListener")) : class$phex$event$DownloadCandidatesChangeListener);
                for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                    DownloadCandidatesChangeListener downloadCandidatesChangeListener = (DownloadCandidatesChangeListener)eventListenerArray[i];
                    downloadCandidatesChangeListener.downloadCandidateChanged(n);
                }
            }
        });
    }

    private void fireDownloadCandidateAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadCandidatesChangeListener == null ? (class$phex$event$DownloadCandidatesChangeListener = SWDownloadFile.class$("phex.event.DownloadCandidatesChangeListener")) : class$phex$event$DownloadCandidatesChangeListener);
                for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                    DownloadCandidatesChangeListener downloadCandidatesChangeListener = (DownloadCandidatesChangeListener)eventListenerArray[i];
                    downloadCandidatesChangeListener.downloadCandidateAdded(n);
                }
            }
        });
    }

    private void fireDownloadCandidateRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadCandidatesChangeListener == null ? (class$phex$event$DownloadCandidatesChangeListener = SWDownloadFile.class$("phex.event.DownloadCandidatesChangeListener")) : class$phex$event$DownloadCandidatesChangeListener);
                for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                    DownloadCandidatesChangeListener downloadCandidatesChangeListener = (DownloadCandidatesChangeListener)eventListenerArray[i];
                    downloadCandidatesChangeListener.downloadCandidateRemoved(n);
                }
            }
        });
    }

    public void fireDownloadCandidateChanged(SWDownloadCandidate sWDownloadCandidate) {
        int n = this.allCandidatesList.indexOf(sWDownloadCandidate);
        if (n >= 0) {
            this.fireDownloadCandidateChanged(n);
        }
    }

    public void addDownloadSegmentChangeListener(DownloadSegmentsChangeListener downloadSegmentsChangeListener) {
        this.listenerList.add(DownloadSegmentsChangeListener.class, downloadSegmentsChangeListener);
    }

    public void removeDownloadSegmentChangeListener(DownloadSegmentsChangeListener downloadSegmentsChangeListener) {
        this.listenerList.remove(DownloadSegmentsChangeListener.class, downloadSegmentsChangeListener);
    }

    private void fireDownloadSegmentChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadSegmentsChangeListener == null ? (class$phex$event$DownloadSegmentsChangeListener = SWDownloadFile.class$("phex.event.DownloadSegmentsChangeListener")) : class$phex$event$DownloadSegmentsChangeListener);
                for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                    DownloadSegmentsChangeListener downloadSegmentsChangeListener = (DownloadSegmentsChangeListener)eventListenerArray[i];
                    downloadSegmentsChangeListener.downloadSegmentChanged(n);
                }
            }
        });
    }

    private void fireDownloadSegmentAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadSegmentsChangeListener == null ? (class$phex$event$DownloadSegmentsChangeListener = SWDownloadFile.class$("phex.event.DownloadSegmentsChangeListener")) : class$phex$event$DownloadSegmentsChangeListener);
                for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                    DownloadSegmentsChangeListener downloadSegmentsChangeListener = (DownloadSegmentsChangeListener)eventListenerArray[i];
                    downloadSegmentsChangeListener.downloadSegmentAdded(n);
                }
            }
        });
    }

    private void fireDownloadSegmentRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadSegmentsChangeListener == null ? (class$phex$event$DownloadSegmentsChangeListener = SWDownloadFile.class$("phex.event.DownloadSegmentsChangeListener")) : class$phex$event$DownloadSegmentsChangeListener);
                for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                    DownloadSegmentsChangeListener downloadSegmentsChangeListener = (DownloadSegmentsChangeListener)eventListenerArray[i];
                    downloadSegmentsChangeListener.downloadSegmentRemoved(n);
                }
            }
        });
    }

    static {
        $assertionsDisabled = !SWDownloadFile.class.desiredAssertionStatus();
        random = new Random();
    }

    private static class SWDownloadSegmentComparatorByStartPosition
    implements Comparator {
        private SWDownloadSegmentComparatorByStartPosition() {
        }

        public int compare(Object object, Object object2) {
            XJBSWDownloadSegment xJBSWDownloadSegment = (XJBSWDownloadSegment)object;
            XJBSWDownloadSegment xJBSWDownloadSegment2 = (XJBSWDownloadSegment)object2;
            long l = xJBSWDownloadSegment.getStartPosition() - xJBSWDownloadSegment2.getStartPosition();
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return 0;
        }
    }

    private static class InitialCandidatesComparator
    implements Comparator {
        private InitialCandidatesComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == object2 || object.equals(object2)) {
                return 0;
            }
            SWDownloadCandidate sWDownloadCandidate = (SWDownloadCandidate)object;
            SWDownloadCandidate sWDownloadCandidate2 = (SWDownloadCandidate)object2;
            long l = sWDownloadCandidate.getLastConnectionTime() - sWDownloadCandidate2.getLastConnectionTime();
            if (l < 0L) {
                return 1;
            }
            if (l > 0L) {
                return -1;
            }
            return sWDownloadCandidate.hashCode() - sWDownloadCandidate2.hashCode();
        }
    }
}

