/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import phex.common.TransferDataProvider;
import phex.common.bandwidth.TransferAverage;
import phex.download.swarming.SWDownloadConstants;
import phex.download.swarming.SWDownloadFile;
import phex.utils.NLogger;

public class SWDownloadSegment
implements TransferDataProvider,
SWDownloadConstants {
    private long start;
    private long length;
    private long transferredDataSize;
    private Integer currentProgress;
    private SWDownloadFile downloadFile;
    private long transferStartTime;
    private long transferStopTime;
    private TransferAverage transferAverage;

    public SWDownloadSegment(SWDownloadFile sWDownloadFile, long l, long l2) {
        this.start = l;
        this.length = l2;
        this.downloadFile = sWDownloadFile;
        this.transferredDataSize = 0L;
        this.currentProgress = new Integer(0);
        this.transferAverage = new TransferAverage(1000, 6);
    }

    public long getTransferStartPosition() {
        return this.start + this.transferredDataSize;
    }

    public long getEnd() {
        if (this.length == -1L) {
            return -1L;
        }
        return this.start + this.length - 1L;
    }

    public long getStart() {
        return this.start;
    }

    public long getTransferDataSizeLeft() {
        if (this.length == -1L) {
            return -1L;
        }
        return Math.max(0L, this.length - this.transferredDataSize);
    }

    public void setTransferredDataSize(long l) {
        if (l < this.transferredDataSize) {
            throw new IllegalArgumentException("Transfered data size is not allowed to go down!");
        }
        if (this.length > -1L && l > this.length) {
            throw new IllegalArgumentException("Transfered data size is not to grow beyond segments size!");
        }
        long l2 = l - this.transferredDataSize;
        this.transferAverage.addValue(l2);
        this.transferredDataSize = l;
    }

    public void downloadStartNotify() {
        this.transferStartTime = System.currentTimeMillis();
        this.transferStopTime = 0L;
    }

    public void downloadStopNotify() {
        if (this.transferStopTime == 0L) {
            this.transferStopTime = System.currentTimeMillis();
        }
    }

    public Integer getProgress() {
        long l = this.getTransferDataSize();
        int n = l > 0L ? (int)(this.getTransferredDataSize() * 100L / l) : 0;
        if (this.currentProgress != n) {
            this.currentProgress = new Integer(n);
        }
        return this.currentProgress;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[start: ");
        stringBuffer.append(this.start);
        stringBuffer.append(", so far: ");
        stringBuffer.append(this.transferredDataSize);
        stringBuffer.append(" of ");
        stringBuffer.append(this.length);
        stringBuffer.append("]@");
        stringBuffer.append(this.hashCode());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private void validateTransferredDataSize() {
        if (this.length != -1L && this.transferredDataSize > this.length) {
            NLogger.error("Download", "Transferred data size above transfer data size: " + this.toString());
        }
    }

    public long getTransferSpeed() {
        return this.transferAverage.getAverage();
    }

    public long getTransferredDataSize() {
        return this.transferredDataSize;
    }

    public long getTotalDataSize() {
        return this.getTransferDataSize();
    }

    public long getTransferDataSize() {
        return this.length;
    }

    public void setTransferRateTimestamp(long l) {
        throw new UnsupportedOperationException();
    }

    public int getShortTermTransferRate() {
        throw new UnsupportedOperationException();
    }

    public int getLongTermTransferRate() {
        return (int)this.getTransferSpeed();
    }

    public short getDataTransferStatus() {
        if (this.transferStartTime != 0L && this.transferStopTime == 0L) {
            return 10;
        }
        return 11;
    }
}

