/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import phex.download.DownloadScope;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SWDownloadWorker;
import phex.utils.NLogger;

public class SWDownloadSet {
    private SWDownloadFile downloadFile;
    private DownloadScope downloadScope;
    private SWDownloadSegment downloadSegment;
    private SWDownloadCandidate downloadCandidate;

    public SWDownloadSet(SWDownloadFile sWDownloadFile, SWDownloadCandidate sWDownloadCandidate) {
        this.downloadFile = sWDownloadFile;
        this.downloadCandidate = sWDownloadCandidate;
        this.downloadScope = null;
    }

    public SWDownloadFile getDownloadFile() {
        return this.downloadFile;
    }

    public SWDownloadCandidate getDownloadCandidate() {
        return this.downloadCandidate;
    }

    public SWDownloadSegment allocateDownloadSegment(SWDownloadWorker sWDownloadWorker) {
        NLogger.debug("Download.DownloadSet", (Object)("Allocate segment for: " + sWDownloadWorker + " on set " + this));
        if (this.downloadScope == null) {
            this.downloadScope = this.downloadFile.allocateDownloadScope(this.downloadCandidate.getAvailableScopeList(), this.downloadCandidate.getPreferredSegmentSize(), this.downloadCandidate.getSpeed());
            if (this.downloadScope != null) {
                this.downloadSegment = this.downloadScope.getEnd() == Long.MAX_VALUE ? new SWDownloadSegment(this.downloadFile, this.downloadScope.getStart(), -1L) : new SWDownloadSegment(this.downloadFile, this.downloadScope.getStart(), this.downloadScope.getLength());
                this.downloadCandidate.associateDownloadSegment(this.downloadSegment);
            }
            NLogger.debug("Download.DownloadSet", (Object)("Allocated segment: " + this.downloadSegment + " on set " + this));
        }
        if (this.downloadSegment == null) {
            return null;
        }
        return this.downloadSegment;
    }

    public DownloadScope getDownloadScope() {
        return this.downloadScope;
    }

    public SWDownloadSegment getDownloadSegment() {
        return this.downloadSegment;
    }

    public void releaseDownloadSegment() {
        if (this.downloadSegment != null) {
            NLogger.debug("Download.DownloadSet", (Object)("Release file download segment: " + this.downloadSegment + " on set " + this));
            this.downloadFile.releaseDownloadScope(this.downloadScope, this.downloadSegment);
            this.downloadSegment = null;
            this.downloadScope = null;
        }
        NLogger.debug("Download.DownloadSet", (Object)("Release candidate download segment on set " + this));
        this.downloadCandidate.releaseDownloadSegment();
    }

    public void releaseDownloadSet() {
        NLogger.debug("Download.DownloadSet", (Object)("Release download set on set " + this));
        this.releaseDownloadSegment();
        this.downloadFile.releaseDownloadCandidate(this.downloadCandidate);
        this.downloadFile.decrementWorkerCount();
    }

    public String toString() {
        return "[DownloadSet@" + Integer.toHexString(this.hashCode()) + ": (Segment: " + this.downloadSegment + " - Candidate: " + this.downloadCandidate + " - File: " + this.downloadFile + ")]";
    }
}

