/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.AbstractManager;
import phex.common.Environment;
import phex.common.IPCounter;
import phex.common.ServiceManager;
import phex.common.ThreadTracking;
import phex.common.URN;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.common.log.LogBuffer;
import phex.download.MagnetData;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSet;
import phex.download.swarming.SWDownloadWorker;
import phex.event.AsynchronousDispatcher;
import phex.event.DownloadFilesChangeListener;
import phex.share.SharedFilesService;
import phex.utils.FileUtils;
import phex.utils.MagmaParser;
import phex.utils.NLogger;
import phex.utils.StringUtils;
import phex.utils.SubscriptionDownloader;
import phex.utils.VersionUtils;
import phex.xml.ObjectFactory;
import phex.xml.PhexElement;
import phex.xml.XJBDownloadScope;
import phex.xml.XJBPhex;
import phex.xml.XJBSWDownloadFile;
import phex.xml.XJBSWDownloadList;
import phex.xml.XJBSWDownloadSegment;
import phex.xml.XMLBuilder;

public class SwarmingManager
extends AbstractManager {
    public static final short PRIORITY_MOVE_TO_TOP = 0;
    public static final short PRIORITY_MOVE_UP = 1;
    public static final short PRIORITY_MOVE_DOWN = 2;
    public static final short PRIORITY_MOVE_TO_BOTTOM = 3;
    private boolean isManagerShutingDown = false;
    private ArrayList workerList;
    private ArrayList downloadList;
    private HashMap urnToDownloadMap;
    private IPCounter ipDownloadCounter;
    private SWDownloadWorker temporaryWorker;
    private DownloadWorkerLauncher workerLauncher;
    private static Object saveDownloadListLock;
    private SaveDownloadListJob saveDownloadListJob;
    private boolean downloadListChangedSinceSave = false;
    private LogBuffer downloadCandidateLogBuffer;
    private SharedFilesService sharedFilesService;
    private ArrayList listenerList = new ArrayList(2);
    static final /* synthetic */ boolean $assertionsDisabled;

    private SwarmingManager() {
    }

    public static SwarmingManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        this.workerList = new ArrayList(5);
        this.downloadList = new ArrayList(5);
        this.urnToDownloadMap = new HashMap();
        this.ipDownloadCounter = new IPCounter(ServiceManager.sCfg.maxDownloadsPerIP);
        if (ServiceManager.sCfg.downloadCandidateLogBufferSize > 0L) {
            this.downloadCandidateLogBuffer = new LogBuffer(ServiceManager.sCfg.downloadCandidateLogBufferSize);
        }
        return true;
    }

    public boolean onPostInitialization() {
        LoadDownloadListJob loadDownloadListJob = new LoadDownloadListJob();
        loadDownloadListJob.start();
        return true;
    }

    public void startupCompletedNotify() {
        this.workerLauncher = new DownloadWorkerLauncher();
        this.workerLauncher.setDaemon(true);
        this.workerLauncher.start();
        Environment.getInstance().scheduleTimerTask(new SaveDownloadListTimer(), 20000L, 20000L);
        new SubscriptionDownloader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        SWDownloadWorker[] sWDownloadWorkerArray = this;
        synchronized (this) {
            SWDownloadWorker sWDownloadWorker;
            int n;
            this.isManagerShutingDown = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.workerLauncher != null) {
                this.workerLauncher.triggerCycle();
            }
            sWDownloadWorkerArray = new SWDownloadWorker[this.workerList.size()];
            this.workerList.toArray(sWDownloadWorkerArray);
            for (n = 0; n < sWDownloadWorkerArray.length; ++n) {
                sWDownloadWorker = sWDownloadWorkerArray[n];
                sWDownloadWorker.stopWorker();
            }
            for (n = 0; n < sWDownloadWorkerArray.length; ++n) {
                sWDownloadWorker = sWDownloadWorkerArray[n];
                if (!sWDownloadWorker.isInsideCriticalSection()) continue;
                sWDownloadWorker.waitTillFinished();
            }
            super.shutdownForceSaveDownloadList();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SWDownloadFile addFileToDownload(RemoteFile remoteFile, String string, String string2) {
        int n;
        SWDownloadFile sWDownloadFile = new SWDownloadFile(string, string2, remoteFile.getFileSize(), remoteFile.getURN());
        sWDownloadFile.addDownloadCandidate(remoteFile);
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            n = this.downloadList.size();
            this.downloadList.add(sWDownloadFile);
            URN uRN = sWDownloadFile.getFileURN();
            if (uRN != null) {
                this.urnToDownloadMap.put(uRN, sWDownloadFile);
            }
        }
        this.fireDownloadFileAdded(n);
        sWDownloadFile.setStatus((short)1);
        this.workerLauncher.triggerCycle();
        this.triggerSaveDownloadList(true);
        return sWDownloadFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SWDownloadFile addFileToDownload(URI uRI) throws URIException {
        int n;
        if (NLogger.isDebugEnabled("Download.Manager")) {
            NLogger.debug("Download.Manager", (Object)("Adding new download by URI: " + uRI.toString()));
        }
        SWDownloadFile sWDownloadFile = new SWDownloadFile(uRI);
        URN uRN = sWDownloadFile.getFileURN();
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            n = this.downloadList.size();
            this.downloadList.add(sWDownloadFile);
            if (uRN != null) {
                if (!$assertionsDisabled && this.isURNDownloaded(uRN)) {
                    throw new AssertionError();
                }
                this.urnToDownloadMap.put(uRN, sWDownloadFile);
            }
        }
        this.fireDownloadFileAdded(n);
        sWDownloadFile.setStatus((short)1);
        this.workerLauncher.triggerCycle();
        this.triggerSaveDownloadList(true);
        return sWDownloadFile;
    }

    public synchronized void addMagmaToDownload(File file) throws URIException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        MagmaParser magmaParser = new MagmaParser(bufferedInputStream);
        magmaParser.start();
        List list = magmaParser.getMagnets();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            URI uRI = new URI(string, true);
            MagnetData magnetData = MagnetData.parseFromURI(uRI);
            URN uRN = MagnetData.lookupSHA1URN(magnetData);
            if (this.isURNDownloaded(uRN)) continue;
            SwarmingManager.getInstance().addFileToDownload(uRI);
        }
    }

    public void removeDownloadFile(SWDownloadFile sWDownloadFile) {
        this.removeDownloadFileInternal(sWDownloadFile);
        this.triggerSaveDownloadList(true);
    }

    public void removeDownloadFiles(SWDownloadFile[] sWDownloadFileArray) {
        for (int i = 0; i < sWDownloadFileArray.length; ++i) {
            this.removeDownloadFileInternal(sWDownloadFileArray[i]);
        }
        this.triggerSaveDownloadList(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDownloadFileInternal(SWDownloadFile sWDownloadFile) {
        if (!sWDownloadFile.isFileCompletedOrMoved() && !sWDownloadFile.isDownloadStopped()) {
            sWDownloadFile.stopDownload();
        }
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            URN uRN;
            int n = this.downloadList.indexOf(sWDownloadFile);
            if (n >= 0) {
                this.downloadList.remove(n);
                this.fireDownloadFileRemoved(n);
            }
            if ((uRN = sWDownloadFile.getFileURN()) != null) {
                this.urnToDownloadMap.remove(uRN);
            }
        }
        sWDownloadFile.removeIncompleteDownloadFile();
    }

    public Integer getDownloadPriority(SWDownloadFile sWDownloadFile) {
        int n = this.downloadList.indexOf(sWDownloadFile);
        if (n >= 0) {
            return new Integer(n);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDownloadFilePriorities(SWDownloadFile[] sWDownloadFileArray) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            for (int i = 0; i < sWDownloadFileArray.length; ++i) {
                int n = this.downloadList.indexOf(sWDownloadFileArray[i]);
                if (n < 0) continue;
                int n2 = i;
                if (n2 < 0 || n2 >= this.downloadList.size()) {
                    n2 = n;
                }
                this.downloadList.remove(n);
                this.downloadList.add(n2, sWDownloadFileArray[i]);
                this.fireDownloadFileRemoved(n);
                this.fireDownloadFileAdded(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveDownloadFilePriority(SWDownloadFile sWDownloadFile, short s) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            int n = this.downloadList.indexOf(sWDownloadFile);
            if (n >= 0) {
                int n2 = n;
                switch (s) {
                    case 1: {
                        --n2;
                        break;
                    }
                    case 2: {
                        ++n2;
                        break;
                    }
                    case 0: {
                        n2 = 0;
                        break;
                    }
                    case 3: {
                        n2 = this.downloadList.size() - 1;
                    }
                }
                if (n2 < 0 || n2 >= this.downloadList.size()) {
                    return n;
                }
                this.downloadList.remove(n);
                this.downloadList.add(n2, sWDownloadFile);
                this.fireDownloadFileRemoved(n);
                this.fireDownloadFileAdded(n2);
                return n2;
            }
            return n;
        }
    }

    public int getDownloadFileCount() {
        return this.downloadList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDownloadFileCount(int n) {
        int n2 = 0;
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            Iterator iterator = this.downloadList.iterator();
            while (iterator.hasNext()) {
                SWDownloadFile sWDownloadFile = (SWDownloadFile)iterator.next();
                if (sWDownloadFile.getStatus() != n) continue;
                ++n2;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getActiveDownloadFileCount() {
        int n = 0;
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            Iterator iterator = this.downloadList.iterator();
            block6: while (iterator.hasNext()) {
                SWDownloadFile sWDownloadFile = (SWDownloadFile)iterator.next();
                switch (sWDownloadFile.getStatus()) {
                    case 4: 
                    case 6: {
                        continue block6;
                    }
                }
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile getDownloadFile(int n) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            if (n < 0 || n >= this.downloadList.size()) {
                return null;
            }
            return (SWDownloadFile)this.downloadList.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile[] getDownloadFilesAt(int[] nArray) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            int n = nArray.length;
            SWDownloadFile[] sWDownloadFileArray = new SWDownloadFile[n];
            for (int i = 0; i < n; ++i) {
                sWDownloadFileArray[i] = nArray[i] < 0 || nArray[i] >= this.downloadList.size() ? null : (SWDownloadFile)this.downloadList.get(nArray[i]);
            }
            return sWDownloadFileArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile getDownloadFile(long l, URN uRN) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            SWDownloadFile sWDownloadFile = this.getDownloadFileByURN(uRN);
            if (sWDownloadFile != null && sWDownloadFile.getTotalDataSize() == l) {
                return sWDownloadFile;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadFile getDownloadFileByURN(URN uRN) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            SWDownloadFile sWDownloadFile = (SWDownloadFile)this.urnToDownloadMap.get(uRN);
            return sWDownloadFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isURNDownloaded(URN uRN) {
        if (uRN == null) {
            return false;
        }
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            return this.urnToDownloadMap.containsKey(uRN);
        }
    }

    public void releaseCandidateIP(SWDownloadCandidate sWDownloadCandidate) {
        this.ipDownloadCounter.relaseIP(sWDownloadCandidate.getHostAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List getCompletedDownloadFiles() {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            SWDownloadFile sWDownloadFile = null;
            Iterator iterator = this.downloadList.iterator();
            ArrayList<SWDownloadFile> arrayList2 = new ArrayList<SWDownloadFile>(2);
            while (iterator.hasNext()) {
                sWDownloadFile = (SWDownloadFile)iterator.next();
                if (!sWDownloadFile.isFileCompleted()) continue;
                arrayList2.add(sWDownloadFile);
            }
            return arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SWDownloadSet allocateDownloadSet(SWDownloadWorker sWDownloadWorker) {
        ArrayList arrayList = this.downloadList;
        synchronized (arrayList) {
            SWDownloadFile sWDownloadFile = null;
            SWDownloadCandidate sWDownloadCandidate = null;
            Iterator iterator = this.downloadList.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                sWDownloadFile = (SWDownloadFile)iterator.next();
                if (!sWDownloadFile.isAbleToBeAllocated() || !(bl = sWDownloadFile.isScopeAllocateable(null)) || (sWDownloadCandidate = sWDownloadFile.allocateDownloadCandidate(sWDownloadWorker)) == null) continue;
                this.ipDownloadCounter.setMaxCount(ServiceManager.sCfg.maxDownloadsPerIP);
                boolean bl2 = this.ipDownloadCounter.validateAndCountIP(sWDownloadCandidate.getHostAddress());
                if (!bl2) {
                    sWDownloadFile.releaseDownloadCandidate(sWDownloadCandidate);
                    continue;
                }
                boolean bl3 = sWDownloadFile.isScopeAllocateable(sWDownloadCandidate.getAvailableScopeList());
                if (!bl3) {
                    sWDownloadFile.releaseDownloadCandidate(sWDownloadCandidate);
                    continue;
                }
                sWDownloadFile.incrementWorkerCount();
                SWDownloadSet sWDownloadSet = new SWDownloadSet(sWDownloadFile, sWDownloadCandidate);
                if (sWDownloadWorker == this.temporaryWorker) {
                    this.unsetTemporaryWorker();
                }
                return sWDownloadSet;
            }
        }
        return null;
    }

    public boolean isNewLocalFilenameUsed(SWDownloadFile sWDownloadFile, File file) {
        int n = this.downloadList.size();
        for (int i = 0; i < n; ++i) {
            SWDownloadFile sWDownloadFile2 = (SWDownloadFile)this.downloadList.get(i);
            if (sWDownloadFile != null && sWDownloadFile2 == sWDownloadFile || sWDownloadFile2.getDestinationFile().compareTo(file) != 0) continue;
            return true;
        }
        return false;
    }

    public LogBuffer getCandidateLogBuffer() {
        return this.downloadCandidateLogBuffer;
    }

    public void notifyDownloadListChange() {
        this.downloadListChangedSinceSave = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerSaveDownloadList(boolean bl) {
        if (!bl && !this.downloadListChangedSinceSave) {
            return;
        }
        NLogger.debug("Download.Manager", (Object)"Trigger save download list...");
        Object object = saveDownloadListLock;
        synchronized (object) {
            if (this.saveDownloadListJob != null) {
                this.saveDownloadListJob.triggerFollowUpSave();
            } else {
                this.saveDownloadListJob = new SaveDownloadListJob();
                this.saveDownloadListJob.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownForceSaveDownloadList() {
        NLogger.debug("Download.Manager", (Object)"Force save download list...");
        Object object = saveDownloadListLock;
        synchronized (object) {
            if (this.saveDownloadListJob == null) {
                this.saveDownloadListJob = new SaveDownloadListJob();
                this.saveDownloadListJob.start();
            } else {
                this.saveDownloadListJob.triggerFollowUpSave();
            }
        }
        try {
            if (this.saveDownloadListJob != null) {
                try {
                    this.saveDownloadListJob.setPriority(10);
                    this.saveDownloadListJob.join();
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        catch (InterruptedException interruptedException) {
            NLogger.error("Download.Manager", (Object)interruptedException, (Throwable)interruptedException);
        }
    }

    private synchronized void unsetTemporaryWorker() {
        this.temporaryWorker.setTemporaryWorker(false);
        this.temporaryWorker = null;
        this.workerLauncher.triggerCycle();
    }

    public synchronized void notifyWaitingWorkers() {
        this.notifyAll();
    }

    public synchronized void waitForNotify() throws InterruptedException {
        this.wait(2000L);
    }

    private int getRequiredDownloadWorkerCount() {
        return Math.min(this.getActiveDownloadFileCount() * ServiceManager.sCfg.maxWorkerPerDownload, ServiceManager.sCfg.maxTotalDownloadWorker);
    }

    public synchronized boolean checkToStopWorker(SWDownloadWorker sWDownloadWorker) {
        int n = this.getRequiredDownloadWorkerCount();
        if (this.isManagerShutingDown || this.workerList.size() > n) {
            if (sWDownloadWorker.isRunning()) {
                sWDownloadWorker.stopWorker();
                this.workerList.remove(sWDownloadWorker);
                if (sWDownloadWorker.isTemporaryWorker()) {
                    this.temporaryWorker = null;
                }
            }
            return true;
        }
        return Thread.interrupted();
    }

    public void notifyWorkerShoutdown(SWDownloadWorker sWDownloadWorker, boolean bl) {
        NLogger.debug("Download.Manager", (Object)("Worker shutdown: " + sWDownloadWorker + ", expected: " + bl));
        sWDownloadWorker.stopWorker();
        this.workerList.remove(sWDownloadWorker);
        if (sWDownloadWorker.isTemporaryWorker()) {
            this.temporaryWorker = null;
        }
        this.workerLauncher.triggerCycle();
    }

    public void addDownloadFilesChangeListener(DownloadFilesChangeListener downloadFilesChangeListener) {
        this.listenerList.add(downloadFilesChangeListener);
    }

    public void removeDownloadFilesChangeListener(DownloadFilesChangeListener downloadFilesChangeListener) {
        this.listenerList.remove(downloadFilesChangeListener);
    }

    private void fireDownloadFileChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SwarmingManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    DownloadFilesChangeListener downloadFilesChangeListener = (DownloadFilesChangeListener)objectArray[i];
                    downloadFilesChangeListener.downloadFileChanged(n);
                }
            }
        });
    }

    private void fireDownloadFileAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SwarmingManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    DownloadFilesChangeListener downloadFilesChangeListener = (DownloadFilesChangeListener)objectArray[i];
                    downloadFilesChangeListener.downloadFileAdded(n);
                }
            }
        });
    }

    private void fireDownloadFileRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SwarmingManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    DownloadFilesChangeListener downloadFilesChangeListener = (DownloadFilesChangeListener)objectArray[i];
                    downloadFilesChangeListener.downloadFileRemoved(n);
                }
            }
        });
    }

    public void fireDownloadFileChanged(SWDownloadFile sWDownloadFile) {
        int n = this.downloadList.indexOf(sWDownloadFile);
        if (n >= 0) {
            this.fireDownloadFileChanged(n);
        }
    }

    static {
        $assertionsDisabled = !SwarmingManager.class.desiredAssertionStatus();
        saveDownloadListLock = new Object();
    }

    private static class SWDownloadSegmentComparatorByStartPosition
    implements Comparator {
        private SWDownloadSegmentComparatorByStartPosition() {
        }

        public int compare(Object object, Object object2) {
            XJBSWDownloadSegment xJBSWDownloadSegment = (XJBSWDownloadSegment)object;
            XJBSWDownloadSegment xJBSWDownloadSegment2 = (XJBSWDownloadSegment)object2;
            long l = xJBSWDownloadSegment.getStartPosition() - xJBSWDownloadSegment2.getStartPosition();
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return 0;
        }
    }

    private class SaveDownloadListJob
    extends Thread {
        private boolean isFollowUpSaveTriggered;

        public SaveDownloadListJob() {
            super(ThreadTracking.rootThreadGroup, "SaveDownloadListJob");
            this.setPriority(1);
        }

        public void triggerFollowUpSave() {
            this.isFollowUpSaveTriggered = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            do {
                NLogger.debug("Download.Manager", (Object)"Start saving download list...");
                SwarmingManager.this.downloadListChangedSinceSave = false;
                this.isFollowUpSaveTriggered = false;
                try {
                    object = new ObjectFactory();
                    PhexElement phexElement = ((ObjectFactory)object).createPhexElement();
                    XJBSWDownloadList xJBSWDownloadList = this.createXJBSWDownloadList();
                    phexElement.setSWDownloadList(xJBSWDownloadList);
                    phexElement.setPhexVersion(VersionUtils.getFullProgramVersion());
                    File file = Environment.getInstance().getPhexConfigFile("phexdownload.xml");
                    File file2 = new File(file.getAbsolutePath() + ".bak");
                    ManagedFile managedFile = FileManager.getInstance().getReadWriteManagedFile(file2);
                    XMLBuilder.saveToFile(managedFile, phexElement);
                    FileUtils.copyFile(file2, file);
                }
                catch (JAXBException jAXBException) {
                    NLogger.error("Download.Manager", (Object)jAXBException, (Throwable)jAXBException);
                    Environment.getInstance().fireDisplayUserMessage("DownloadSettingsSaveFailed", new String[]{jAXBException.toString()});
                }
                catch (ManagedFileException managedFileException) {
                    NLogger.error("Download.Manager", (Object)managedFileException, (Throwable)managedFileException);
                    Environment.getInstance().fireDisplayUserMessage("DownloadSettingsSaveFailed", new String[]{managedFileException.toString()});
                }
                catch (IOException iOException) {
                    NLogger.error("Download.Manager", (Object)iOException, (Throwable)iOException);
                    Environment.getInstance().fireDisplayUserMessage("DownloadSettingsSaveFailed", new String[]{iOException.toString()});
                }
            } while (this.isFollowUpSaveTriggered);
            NLogger.debug("Download.Manager", (Object)"Finished saving download list...");
            object = saveDownloadListLock;
            synchronized (object) {
                SwarmingManager.this.saveDownloadListJob = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private XJBSWDownloadList createXJBSWDownloadList() throws JAXBException {
            ObjectFactory objectFactory = new ObjectFactory();
            XJBSWDownloadList xJBSWDownloadList = objectFactory.createXJBSWDownloadList();
            ArrayList arrayList = SwarmingManager.this.downloadList;
            synchronized (arrayList) {
                Iterator iterator = SwarmingManager.this.downloadList.iterator();
                List list = xJBSWDownloadList.getSWDownloadFileList();
                while (iterator.hasNext()) {
                    SWDownloadFile sWDownloadFile = (SWDownloadFile)iterator.next();
                    list.add(sWDownloadFile.createXJBSWDownloadFile());
                }
            }
            return xJBSWDownloadList;
        }
    }

    private class SaveDownloadListTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 20000L;

        private SaveDownloadListTimer() {
        }

        public void run() {
            try {
                SwarmingManager.this.triggerSaveDownloadList(false);
            }
            catch (Throwable throwable) {
                NLogger.error("Download.Manager", (Object)throwable, throwable);
            }
        }
    }

    private class LoadDownloadListJob
    extends Thread {
        public LoadDownloadListJob() {
            super(ThreadTracking.rootThreadGroup, "LoadDownloadListJob");
        }

        public void run() {
            try {
                this.loadDownloadList();
            }
            catch (Throwable throwable) {
                NLogger.error("Download.Manager", (Object)throwable, throwable);
            }
        }

        private void loadDownloadList() {
            NLogger.debug("Download.Manager", (Object)"Loading download list...");
            File file = Environment.getInstance().getPhexConfigFile("phexdownload.xml");
            File file2 = new File(file.getAbsolutePath() + ".bak");
            if (!file.exists() && !file2.exists()) {
                NLogger.debug("Download.Manager", (Object)"No download list file found.");
                return;
            }
            try {
                Object object;
                NLogger.debug("Download.Manager", (Object)"Try to load from default download list.");
                FileManager fileManager = FileManager.getInstance();
                ManagedFile managedFile = fileManager.getReadWriteManagedFile(file);
                XJBPhex xJBPhex = XMLBuilder.loadXJBPhexFromFile(managedFile);
                if (xJBPhex == null) {
                    NLogger.debug("Download.Manager", (Object)"Try to load from backup download list.");
                    object = fileManager.getReadWriteManagedFile(file2);
                    xJBPhex = XMLBuilder.loadXJBPhexFromFile((ManagedFile)object);
                }
                if (xJBPhex == null) {
                    NLogger.debug("Download.Manager", (Object)"No download settings file found.");
                    return;
                }
                object = xJBPhex.getSWDownloadList();
                if (object != null) {
                    String string = xJBPhex.getPhexVersion();
                    if (VersionUtils.compare("2.6.4.89", string) >= 0) {
                        this.load2_6_4_89SWDownloadList((XJBSWDownloadList)object);
                    } else {
                        this.loadXJBSWDownloadList((XJBSWDownloadList)object);
                    }
                } else {
                    NLogger.debug("Download.Manager", (Object)"No SWDownloadList found.");
                }
                SwarmingManager.this.notifyWaitingWorkers();
            }
            catch (JAXBException jAXBException) {
                Throwable throwable = jAXBException.getLinkedException();
                if (throwable != null) {
                    NLogger.error("Download.Manager", (Object)throwable, throwable);
                }
                NLogger.error("Download.Manager", (Object)jAXBException, (Throwable)jAXBException);
                Environment.getInstance().fireDisplayUserMessage("DownloadSettingsLoadFailed", new String[]{jAXBException.toString()});
                return;
            }
            catch (ManagedFileException managedFileException) {
                NLogger.error("Download.Manager", (Object)managedFileException, (Throwable)managedFileException);
                Environment.getInstance().fireDisplayUserMessage("DownloadSettingsLoadFailed", new String[]{managedFileException.toString()});
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadXJBSWDownloadList(XJBSWDownloadList xJBSWDownloadList) {
            ArrayList arrayList = SwarmingManager.this.downloadList;
            synchronized (arrayList) {
                NLogger.debug("Download.Manager", (Object)"Loading SWDownload xml");
                SwarmingManager.this.downloadList.clear();
                SwarmingManager.this.urnToDownloadMap.clear();
                Iterator iterator = xJBSWDownloadList.getSWDownloadFileList().iterator();
                while (iterator.hasNext()) {
                    try {
                        XJBSWDownloadFile xJBSWDownloadFile = (XJBSWDownloadFile)iterator.next();
                        SWDownloadFile sWDownloadFile = new SWDownloadFile(xJBSWDownloadFile);
                        int n = SwarmingManager.this.downloadList.size();
                        SwarmingManager.this.downloadList.add(sWDownloadFile);
                        URN uRN = sWDownloadFile.getFileURN();
                        if (uRN != null) {
                            SwarmingManager.this.urnToDownloadMap.put(uRN, sWDownloadFile);
                        }
                        NLogger.debug("Download.Manager", (Object)("Loaded SWDownloadFile: " + sWDownloadFile));
                        SwarmingManager.this.fireDownloadFileAdded(n);
                    }
                    catch (Exception exception) {
                        NLogger.error("Download.Manager", (Object)"Error loading a download file from XML.", (Throwable)exception);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void load2_6_4_89SWDownloadList(XJBSWDownloadList xJBSWDownloadList) {
            ArrayList arrayList = SwarmingManager.this.downloadList;
            synchronized (arrayList) {
                NLogger.debug("Download.Manager", (Object)"Loading old download xml.");
                ObjectFactory objectFactory = new ObjectFactory();
                SwarmingManager.this.downloadList.clear();
                SwarmingManager.this.urnToDownloadMap.clear();
                Iterator iterator = xJBSWDownloadList.getSWDownloadFileList().iterator();
                while (iterator.hasNext()) {
                    try {
                        XJBSWDownloadFile xJBSWDownloadFile = (XJBSWDownloadFile)iterator.next();
                        String string = ServiceManager.sCfg.mDownloadDir + File.separator + xJBSWDownloadFile.getLocalFileName();
                        File file = new File(string);
                        File file2 = SWDownloadFile.createIncompleteFile(file);
                        RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rwd");
                        XJBSWDownloadFile xJBSWDownloadFile2 = objectFactory.createXJBSWDownloadFile();
                        xJBSWDownloadFile2.setIncompleteFileName(file2.getAbsolutePath());
                        xJBSWDownloadFile2.setCreatedTime(xJBSWDownloadFile.getCreatedTime());
                        xJBSWDownloadFile2.setFileSize(xJBSWDownloadFile.getFileSize());
                        xJBSWDownloadFile2.setFileURN(xJBSWDownloadFile.getFileURN());
                        xJBSWDownloadFile2.setLocalFileName(xJBSWDownloadFile.getLocalFileName());
                        xJBSWDownloadFile2.setModifiedTime(xJBSWDownloadFile.getModifiedTime());
                        xJBSWDownloadFile2.setSearchTerm(xJBSWDownloadFile.getSearchTerm());
                        xJBSWDownloadFile2.setStatus(xJBSWDownloadFile.getStatus());
                        xJBSWDownloadFile2.getCandidateList().addAll(xJBSWDownloadFile.getCandidateList());
                        ArrayList arrayList2 = new ArrayList();
                        Iterator iterator2 = xJBSWDownloadFile.getSegmentList().iterator();
                        while (iterator2.hasNext()) {
                            arrayList2.add(iterator2.next());
                        }
                        Collections.sort(arrayList2, new SWDownloadSegmentComparatorByStartPosition());
                        iterator2 = arrayList2.iterator();
                        while (iterator2.hasNext()) {
                            try {
                                int n;
                                File file3;
                                XJBSWDownloadSegment xJBSWDownloadSegment = (XJBSWDownloadSegment)iterator2.next();
                                long l = xJBSWDownloadSegment.getLength();
                                long l2 = xJBSWDownloadSegment.getStartPosition();
                                long l3 = 0L;
                                String string2 = xJBSWDownloadSegment.getIncompleteFileName();
                                if (StringUtils.isEmpty(string2) || !(file3 = new File(xJBSWDownloadSegment.getIncompleteFileName())).exists() || (l3 = file3.length()) == 0L) continue;
                                if (l != -1L && l3 > l) {
                                    try {
                                        FileUtils.truncateFile(file3, l);
                                        l3 = l;
                                    }
                                    catch (IOException iOException) {
                                        NLogger.error("Download", (Object)iOException, (Throwable)iOException);
                                    }
                                }
                                randomAccessFile.setLength(l2 + l3);
                                randomAccessFile.seek(l2);
                                FileInputStream fileInputStream = new FileInputStream(file3);
                                byte[] byArray = new byte[16384];
                                while ((n = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
                                    randomAccessFile.write(byArray, 0, n);
                                }
                                fileInputStream.close();
                                file3.delete();
                                XJBDownloadScope xJBDownloadScope = objectFactory.createXJBDownloadScope();
                                xJBDownloadScope.setStart(l2);
                                xJBDownloadScope.setEnd(l2 + l3 - 1L);
                                xJBSWDownloadFile2.getFinishedScopesList().add(xJBDownloadScope);
                            }
                            catch (Throwable throwable) {
                                NLogger.error("Download.Manager", (Object)"Failed to convert segment.", throwable);
                            }
                        }
                        randomAccessFile.close();
                        SWDownloadFile sWDownloadFile = new SWDownloadFile(xJBSWDownloadFile2);
                        int n = SwarmingManager.this.downloadList.size();
                        SwarmingManager.this.downloadList.add(sWDownloadFile);
                        URN uRN = sWDownloadFile.getFileURN();
                        if (uRN != null) {
                            SwarmingManager.this.urnToDownloadMap.put(uRN, sWDownloadFile);
                        }
                        NLogger.debug("Download.Manager", (Object)("Converted SWDownloadFile: " + sWDownloadFile));
                        SwarmingManager.this.fireDownloadFileAdded(n);
                    }
                    catch (Exception exception) {
                        NLogger.error("Download.Manager", (Object)"Failed to convert a download file from XML.", (Throwable)exception);
                    }
                }
            }
        }
    }

    private class DownloadWorkerLauncher
    extends Thread {
        public DownloadWorkerLauncher() {
            super(ThreadTracking.rootThreadGroup, "DownloadWorkerLauncher");
        }

        public void run() {
            while (!SwarmingManager.this.isManagerShutingDown) {
                try {
                    this.createRequiredWorker();
                    this.waitForNextCycle();
                }
                catch (Throwable throwable) {
                    NLogger.error("Download.Manager", (Object)throwable, throwable);
                }
            }
        }

        public synchronized void triggerCycle() {
            this.notify();
        }

        private synchronized void waitForNextCycle() throws InterruptedException {
            this.wait(2000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void createRequiredWorker() {
            SwarmingManager swarmingManager = SwarmingManager.this;
            synchronized (swarmingManager) {
                int n = SwarmingManager.this.getRequiredDownloadWorkerCount();
                if (SwarmingManager.this.temporaryWorker == null && SwarmingManager.this.workerList.size() < n) {
                    SwarmingManager.this.temporaryWorker = new SWDownloadWorker();
                    SwarmingManager.this.temporaryWorker.setTemporaryWorker(true);
                    SwarmingManager.this.temporaryWorker.startWorker();
                    SwarmingManager.this.workerList.add(SwarmingManager.this.temporaryWorker);
                    NLogger.debug("Download.Manager", (Object)("Creating new worker: " + SwarmingManager.this.temporaryWorker + " for a total of: " + SwarmingManager.this.workerList.size()));
                }
            }
        }
    }

    private static class Holder {
        protected static final SwarmingManager manager = new SwarmingManager();

        private Holder() {
        }
    }
}

