/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JMenu;
import phex.common.ExpiryDate;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.gui.actions.FWAction;
import phex.gui.common.GUIRegistry;
import phex.gui.dialogs.SecurityRuleConfigDialog;
import phex.security.PhexSecurityManager;
import phex.utils.Localizer;
import phex.utils.NLogger;

public abstract class BanHostActionUtils
extends FWAction {
    public static BanHostActionMenu createActionMenu(BanHostActionProvider banHostActionProvider) {
        FWAction[] fWActionArray = new FWAction[4];
        JMenu jMenu = new JMenu(Localizer.getString("BanHostAction_BanHost"));
        jMenu.setIcon(GUIRegistry.getInstance().getIconFactory().getIcon("Ban"));
        BanHostAction banHostAction = new BanHostAction(Localizer.getString("BanHostAction_1Day"), banHostActionProvider, ExpiryDate.getExpiryDate(System.currentTimeMillis() + 86400000L));
        fWActionArray[0] = banHostAction;
        jMenu.add(banHostAction);
        banHostAction = new BanHostAction(Localizer.getString("BanHostAction_7Days"), banHostActionProvider, ExpiryDate.getExpiryDate(System.currentTimeMillis() + 604800000L));
        fWActionArray[1] = banHostAction;
        jMenu.add(banHostAction);
        banHostAction = new BanHostAction(Localizer.getString("BanHostAction_Unlimited"), banHostActionProvider, ExpiryDate.getExpiryDate(Long.MAX_VALUE));
        fWActionArray[2] = banHostAction;
        jMenu.add(banHostAction);
        banHostAction = new BanHostAction(Localizer.getString("BanHostAction_Custom"), banHostActionProvider, null);
        fWActionArray[3] = banHostAction;
        jMenu.add(banHostAction);
        BanHostActionMenu banHostActionMenu = new BanHostActionMenu();
        banHostActionMenu.menu = jMenu;
        banHostActionMenu.actions = fWActionArray;
        return banHostActionMenu;
    }

    public static FWAction createToolBarAction(BanHostActionProvider banHostActionProvider) {
        BanHostAction banHostAction = new BanHostAction(Localizer.getString("BanHostAction_BanHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Ban"), Localizer.getString("BanHostAction_TTTBanHost7Days"), banHostActionProvider, ExpiryDate.getExpiryDate(System.currentTimeMillis() + 604800000L));
        return banHostAction;
    }

    private static void banHosts(DestAddress[] destAddressArray, ExpiryDate expiryDate) {
        PhexSecurityManager phexSecurityManager = PhexSecurityManager.getInstance();
        for (int i = 0; i < destAddressArray.length; ++i) {
            IpAddress ipAddress = destAddressArray[i].getIpAddress();
            if (ipAddress == null) continue;
            phexSecurityManager.createIPAccessRule(Localizer.getString("UserBanned"), true, (byte)1, ipAddress.getHostIP(), null, false, expiryDate, true);
        }
    }

    private static class BanHostAction
    extends FWAction {
        private BanHostActionProvider addressProvider;
        private ExpiryDate expiryDate;

        private BanHostAction(String string, BanHostActionProvider banHostActionProvider, ExpiryDate expiryDate) {
            this(string, null, null, banHostActionProvider, expiryDate);
        }

        private BanHostAction(String string, Icon icon, String string2, BanHostActionProvider banHostActionProvider, ExpiryDate expiryDate) {
            super(string, icon, string2);
            this.addressProvider = banHostActionProvider;
            this.expiryDate = expiryDate;
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (this.expiryDate == null) {
                    DestAddress[] destAddressArray = this.addressProvider.getBanHostAddresses();
                    IpAddress ipAddress = destAddressArray[0].getIpAddress();
                    if (ipAddress == null) {
                        return;
                    }
                    SecurityRuleConfigDialog securityRuleConfigDialog = new SecurityRuleConfigDialog();
                    securityRuleConfigDialog.customPrefillBanSingleIp(Localizer.getString("UserBanned"), ipAddress.getHostIP());
                    securityRuleConfigDialog.show();
                } else {
                    final DestAddress[] destAddressArray = this.addressProvider.getBanHostAddresses();
                    Runnable runnable = new Runnable(){

                        public void run() {
                            try {
                                BanHostActionUtils.banHosts(destAddressArray, expiryDate);
                            }
                            catch (Throwable throwable) {
                                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
                            }
                        }
                    };
                    ThreadPool.getInstance().addJob(runnable, "BanHostsAction");
                }
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }

        public void refreshActionState() {
            this.setEnabled(this.addressProvider.isBanHostActionEnabled(this.expiryDate != null));
        }
    }

    public static interface BanHostActionProvider {
        public DestAddress[] getBanHostAddresses();

        public boolean isBanHostActionEnabled(boolean var1);
    }

    public static class BanHostActionMenu {
        public FWAction[] actions;
        public JMenu menu;
    }
}

