/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.actions;

import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.gui.common.GUIRegistry;
import phex.gui.common.MainFrame;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.SearchTab;
import phex.host.FavoritesContainer;
import phex.host.HostManager;
import phex.query.BrowseHostResults;
import phex.query.QueryManager;
import phex.query.SearchContainer;
import phex.share.FileRescanRunner;

public class GUIActionPerformer {
    public static void browseHost(DestAddress destAddress) {
        SearchContainer searchContainer = QueryManager.getInstance().getSearchContainer();
        BrowseHostResults browseHostResults = searchContainer.createBrowseHostSearch(destAddress, null);
        SearchResultsDataModel searchResultsDataModel = SearchResultsDataModel.registerNewSearch(browseHostResults);
        MainFrame mainFrame = GUIRegistry.getInstance().getMainFrame();
        SearchTab searchTab = (SearchTab)mainFrame.getTab(1101);
        mainFrame.setSelectedTab(1101);
        searchTab.setDisplayedSearch(searchResultsDataModel);
    }

    public static void addHostsToFavorites(DestAddress[] destAddressArray) {
        HostManager hostManager = HostManager.getInstance();
        FavoritesContainer favoritesContainer = hostManager.getFavoritesContainer();
        favoritesContainer.addFavorites(destAddressArray);
    }

    public static void rescanSharedFiles() {
        Runnable runnable = new Runnable(){

            public void run() {
                FileRescanRunner.rescan(true, true);
            }
        };
        ThreadPool.getInstance().addJob(runnable, "SharedFilesRescanExecute");
    }
}

