/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.actions;

import java.awt.event.ActionEvent;
import phex.gui.actions.FWToggleAction;
import phex.gui.common.GUIRegistry;
import phex.gui.tabs.FWTab;
import phex.utils.Localizer;

public class ToggleTabViewAction
extends FWToggleAction {
    private FWTab tab;

    public ToggleTabViewAction(FWTab fWTab) {
        this.tab = fWTab;
        Object[] objectArray = new Object[]{this.tab.getName()};
        this.setName(Localizer.getFormatedString("ToggleTabAction", objectArray));
        this.setSmallIcon(this.tab.getIcon());
        this.putValue("MnemonicKey", new Integer(this.tab.getMnemonic()));
        this.putValue("AcceleratorKey", this.tab.getAccelerator());
        this.setSelected(this.tab.getParent() != null);
        this.updateTooltip();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.tab.isShowing() || !this.tab.isDisplayable()) {
            boolean bl = !this.isSelected();
            this.setSelected(bl);
            GUIRegistry.getInstance().getMainFrame().setTabVisible(this.tab, bl);
            this.updateTooltip();
        } else {
            boolean bl = !this.isSelected();
            this.setSelected(bl);
            this.setSelected(!bl);
            GUIRegistry.getInstance().getMainFrame().setSelectedTab(this.tab);
        }
    }

    private void updateTooltip() {
        Object[] objectArray = new Object[]{this.tab.getName()};
        if (this.isSelected()) {
            this.setToolTipText(Localizer.getFormatedString("TTTToggleTabActionHide", objectArray));
        } else {
            this.setToolTipText(Localizer.getFormatedString("TTTToggleTabActionShow", objectArray));
        }
    }

    public void refreshActionState() {
    }
}

