/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.chat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import phex.chat.ChatEngine;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.MainFrame;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class ChatFrame
extends JFrame {
    private static final int MAX_CHAT_LENGTH = 51200;
    private ChatEngine chatEngine;
    private JTextArea chatTextArea;
    private JTextField sendTextField;

    public ChatFrame(ChatEngine chatEngine) {
        this.chatEngine = chatEngine;
        Object[] objectArray = new Object[]{this.chatEngine.getHostAddress().getHostName()};
        this.setTitle(Localizer.getFormatedString("ChattingWith", objectArray));
        this.setSize(400, 200);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ChatFrame.this.chatEngine.stopChat();
                ChatFrame.this.closeChatFrame();
            }
        });
        Icon icon = GUIRegistry.getInstance().getIconFactory().getIcon("Phex16");
        if (icon != null) {
            this.setIconImage(((ImageIcon)icon).getImage());
        }
        MainFrame mainFrame = GUIRegistry.getInstance().getMainFrame();
        GUIUtils.setWindowLocationRelativeTo(this, mainFrame);
        this.prepareComponent();
    }

    private void prepareComponent() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.chatTextArea = new JTextArea(10, 40);
        this.chatTextArea.setEditable(false);
        this.chatTextArea.setLineWrap(true);
        this.chatTextArea.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        jPanel.add((Component)new JScrollPane(this.chatTextArea), gridBagConstraints);
        this.sendTextField = new JTextField(40);
        this.sendTextField.registerKeyboardAction(new SendTextActionHandler(), KeyStroke.getKeyStroke(10, 0), 0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 3, 6);
        jPanel.add((Component)this.sendTextField, gridBagConstraints);
        this.getContentPane().add("Center", jPanel);
    }

    public void addChatMessage(String string) {
        string = '<' + this.chatEngine.getChatNick() + "> " + string + '\n';
        try {
            Document document = this.chatTextArea.getDocument();
            document.insertString(document.getLength(), string, null);
            if (document.getLength() > 51200) {
                document.remove(0, document.getLength() - 51200);
            }
        }
        catch (BadLocationException badLocationException) {
            NLogger.warn(ChatFrame.class, (Object)badLocationException, (Throwable)badLocationException);
        }
    }

    public void addInfoMessage(String string) {
        try {
            Document document = this.chatTextArea.getDocument();
            document.insertString(document.getLength(), string, null);
            if (document.getLength() > 51200) {
                document.remove(0, document.getLength() - 51200);
            }
        }
        catch (BadLocationException badLocationException) {
            NLogger.warn(ChatFrame.class, (Object)badLocationException, (Throwable)badLocationException);
        }
    }

    private void closeChatFrame() {
        this.setVisible(false);
        this.dispose();
    }

    private class SendTextActionHandler
    implements ActionListener {
        private SendTextActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ChatFrame.this.sendTextField.getText();
            if (string.length() == 0) {
                return;
            }
            if (!ChatFrame.this.chatEngine.isConnected()) {
                ChatFrame.this.addInfoMessage(Localizer.getString("NotConnected"));
                return;
            }
            Document document = ChatFrame.this.sendTextField.getDocument();
            try {
                document.remove(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                NLogger.warn(class$phex$gui$chat$ChatFrame == null ? (class$phex$gui$chat$ChatFrame = ChatFrame.class$("phex.gui.chat.ChatFrame")) : class$phex$gui$chat$ChatFrame, (Object)badLocationException, (Throwable)badLocationException);
            }
            String string2 = '<' + Localizer.getString("You") + "> " + string + '\n';
            try {
                document = ChatFrame.this.chatTextArea.getDocument();
                document.insertString(document.getLength(), string2, null);
            }
            catch (BadLocationException badLocationException) {
                NLogger.warn(class$phex$gui$chat$ChatFrame == null ? (class$phex$gui$chat$ChatFrame = ChatFrame.class$("phex.gui.chat.ChatFrame")) : class$phex$gui$chat$ChatFrame, (Object)badLocationException, (Throwable)badLocationException);
            }
            ChatFrame.this.chatEngine.sendChatMessage(string);
        }
    }
}

