/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.PhexColors;

public class DialogBanner
extends JPanel {
    private String headerText;
    private String subHeaderText;
    private Icon image;
    private JLabel titleLabel;
    private static Rectangle viewRect = new Rectangle();

    public DialogBanner(String string, String string2) {
        this.headerText = string;
        this.subHeaderText = string2;
        this.image = GUIRegistry.getInstance().getIconFactory().getIcon("PhexWizard");
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("4dlu, 2dlu, d:grow", "3dlu, d, 3dlu, d, 3dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        this.setBackground(Color.WHITE);
        Font font = UIManager.getFont("TitledBorder.font");
        font = font.deriveFont(1, font.getSize() + 2);
        this.titleLabel = new JLabel(this.headerText);
        this.titleLabel.setFont(font);
        panelBuilder.add((Component)this.titleLabel, cellConstraints.xywh(2, 2, 2, 1));
        font = UIManager.getFont("Label.font");
        font = font.deriveFont(0, font.getSize() - 1);
        JLabel jLabel = new JLabel(this.subHeaderText);
        jLabel.setFont(font);
        panelBuilder.add((Component)jLabel, cellConstraints.xy(3, 4));
    }

    public void setImageIcon(String string) {
        this.image = string != null ? (this.image = GUIRegistry.getInstance().getIconFactory().getIcon(string)) : null;
    }

    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Insets insets = this.getInsets();
        DialogBanner.viewRect.x = insets.left;
        DialogBanner.viewRect.y = insets.top;
        DialogBanner.viewRect.width = this.getWidth() - (insets.right + DialogBanner.viewRect.x);
        DialogBanner.viewRect.height = this.getHeight() - (insets.bottom + DialogBanner.viewRect.y);
        Graphics2D graphics2D = (Graphics2D)graphics;
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, PhexColors.getBoxHeaderGradientTo(), this.getWidth() / 2, 0.0f, this.getBackground());
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(DialogBanner.viewRect.x, DialogBanner.viewRect.y, DialogBanner.viewRect.width, DialogBanner.viewRect.height);
        if (this.image != null) {
            int n = Math.max(0, this.getWidth() - 7 - this.image.getIconWidth());
            int n2 = 7;
            this.image.paintIcon(this, graphics2D, n, n2);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int n = 0;
        int n2 = 0;
        if (this.image != null) {
            n = this.image.getIconHeight() + 14;
            n2 = this.image.getIconWidth() + 14;
        }
        dimension.height = Math.max(dimension.height, n);
        dimension.width += n2;
        return dimension;
    }

    public static void main(String[] stringArray) {
        PhexColors.updateColors();
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.setSize(400, 300);
        jFrame.getContentPane().setLayout(new BorderLayout());
        DialogBanner dialogBanner = new DialogBanner("New Download", "Add a new download from Magnet URI or URL");
        jFrame.getContentPane().add((Component)dialogBanner, "North");
        jFrame.setVisible(true);
    }
}

