/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import phex.gui.common.GradientPanel;
import phex.gui.common.PhexColors;

public class FWElegantPanel
extends JPanel {
    private JLabel titleLabel;
    private JPanel headerPanel = new ElegantHeaderPanel(PhexColors.getBoxHeaderGradientFrom(), PhexColors.getBoxHeaderGradientTo());

    public FWElegantPanel(String string) {
        this(string, null);
    }

    public FWElegantPanel(String string, Component component) {
        super(new BorderLayout());
        this.headerPanel.add((Component)this.getTitleLabel(), "Center");
        this.add((Component)this.headerPanel, "North");
        if (component != null) {
            this.add(component, "Center");
        }
        this.setTitle(string);
    }

    public String getTitle() {
        return this.getTitleLabel().getText();
    }

    private JLabel getTitleLabel() {
        if (this.titleLabel != null) {
            return this.titleLabel;
        }
        this.titleLabel = new JLabel();
        Font font = this.titleLabel.getFont();
        this.titleLabel.setFont(font.deriveFont(1, font.getSize() + 2));
        this.titleLabel.setBorder(new EmptyBorder(6, 6, 6, 4));
        return this.titleLabel;
    }

    public void setTitle(String string) {
        if (string == null) {
            string = "";
        }
        string = string.trim();
        this.getTitleLabel().setText(string);
    }

    public void addHeaderPanelComponent(Component component, String string) {
        this.headerPanel.add(component, string);
    }

    private static class ElegantHeaderPanel
    extends GradientPanel {
        private static Rectangle viewRect = new Rectangle();

        public ElegantHeaderPanel(Color color, Color color2) {
            super(color, color2);
            this.setLayout(new BorderLayout());
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Insets insets = this.getInsets();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            Insets insets2 = this.getInsets();
            ElegantHeaderPanel.viewRect.x = insets2.left;
            ElegantHeaderPanel.viewRect.y = insets2.top;
            ElegantHeaderPanel.viewRect.width = this.getWidth() - (insets2.right + ElegantHeaderPanel.viewRect.x) - 1;
            ElegantHeaderPanel.viewRect.height = this.getHeight() - (insets2.bottom + ElegantHeaderPanel.viewRect.y);
            Graphics2D graphics2D = (Graphics2D)graphics;
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.fromColor, 0.0f, ElegantHeaderPanel.viewRect.height, this.toColor);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(ElegantHeaderPanel.viewRect.x, ElegantHeaderPanel.viewRect.y, ElegantHeaderPanel.viewRect.width, ElegantHeaderPanel.viewRect.height);
            graphics.setColor(PhexColors.getBoxPanelBorderColor());
            graphics.drawLine(insets.left, insets.top, ElegantHeaderPanel.viewRect.width, insets.top);
            graphics.drawLine(insets.left, insets.top, insets.left, ElegantHeaderPanel.viewRect.height);
            graphics.drawLine(ElegantHeaderPanel.viewRect.width, insets.top, ElegantHeaderPanel.viewRect.width, ElegantHeaderPanel.viewRect.height);
        }
    }
}

