/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Point;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.SystemUtils;
import phex.gui.common.SlideInWindow;
import phex.gui.macosx.MacOsxGUIUtils;
import phex.utils.DirectoryOnlyFileFilter;

public class FileDialogHandler {
    public static File[] openMultipleDirectoryChooser(Component component, String string, String string2, char c, File file) {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return new File[]{FileDialogHandler.openMacDirectoryChooser(string, null, null)};
        }
        return FileDialogHandler.openDefaultChooser(component, string, string2, c, new DirectoryOnlyFileFilter(), 1, file, null, null);
    }

    public static File[] openMultipleDirectoryChooser(Component component, String string, String string2, char c, File file, String string3, String string4) {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return new File[]{FileDialogHandler.openMacDirectoryChooser(string, string3, string4)};
        }
        return FileDialogHandler.openDefaultChooser(component, string, string2, c, new DirectoryOnlyFileFilter(), 1, file, string3, string4);
    }

    private static File openMacDirectoryChooser(String string, String string2, String string3) {
        FileDialog fileDialog = MacOsxGUIUtils.createFolderDialog();
        fileDialog.setTitle(string);
        DirectoryOnlyFileFilter directoryOnlyFileFilter = new DirectoryOnlyFileFilter();
        fileDialog.setFilenameFilter(new FileFilterWrapper(directoryOnlyFileFilter));
        fileDialog.setVisible(true);
        String string4 = fileDialog.getDirectory();
        String string5 = fileDialog.getFile();
        if (string4 == null || string5 == null) {
            return null;
        }
        File file = new File(string4, string5);
        if (directoryOnlyFileFilter != null && !directoryOnlyFileFilter.accept(file)) {
            return null;
        }
        return file;
    }

    private static File[] openDefaultChooser(Component component, String string, String string2, char c, FileFilter fileFilter, int n, File file, String string3, String string4) {
        JFileChooser jFileChooser = new JFileChooser();
        if (string3 != null || string4 != null) {
            FileDialogHandler.displayNotificationPopup(jFileChooser, string3, string4);
        }
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        if (fileFilter != null) {
            jFileChooser.setFileFilter(fileFilter);
        }
        jFileChooser.setFileSelectionMode(n);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setApproveButtonText(string2);
        jFileChooser.setApproveButtonMnemonic(c);
        jFileChooser.setMultiSelectionEnabled(true);
        int n2 = jFileChooser.showOpenDialog(component);
        if (n2 == 0) {
            return jFileChooser.getSelectedFiles();
        }
        return null;
    }

    private static void displayNotificationPopup(JComponent jComponent, String string, String string2) {
        final SlideInWindow slideInWindow = new SlideInWindow(string, 0L);
        slideInWindow.setShortMessage(string2, true);
        slideInWindow.setHideBtnShown(false);
        slideInWindow.initializeComponent();
        slideInWindow.setSize(200, 150);
        jComponent.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                slideInWindow.setVisible(true);
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                slideInWindow.setVisible(false);
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
                Container container = ancestorEvent.getAncestor();
                Point point = container.getLocationOnScreen();
                int n = point.x + container.getWidth() + 5;
                int n2 = point.y + container.getHeight() - slideInWindow.getHeight();
                slideInWindow.setLocation(n, n2);
            }
        });
    }

    private static class FileFilterWrapper
    implements FilenameFilter {
        private FileFilter filter;

        public FileFilterWrapper(FileFilter fileFilter) {
            this.filter = fileFilter;
        }

        public boolean accept(File file, String string) {
            return this.filter.accept(new File(file, string));
        }
    }
}

