/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.EventQueue;
import phex.event.UserMessageListener;
import phex.gui.common.SlideInWindow;
import phex.utils.Localizer;

public class GUIUserMessageListener
implements UserMessageListener {
    private static final long DEFAULT_AUTO_CLOSE_DELAY = 30000L;

    public void displayUserMessage(final String string, final String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                String string3 = GUIUserMessageListener.this.determineUserMsgTitle(string);
                String string2 = GUIUserMessageListener.this.determineUserMsgShortMessage(string, stringArray);
                long l = GUIUserMessageListener.this.determineUserMsgAutoCloseDelay(string);
                SlideInWindow slideInWindow = new SlideInWindow(string3, l);
                slideInWindow.setShortMessage(string2, false);
                slideInWindow.initializeComponent();
                slideInWindow.slideIn();
            }
        });
    }

    private String determineUserMsgTitle(String string) {
        return Localizer.getString("UserMsg_" + string + "_Title");
    }

    private String determineUserMsgShortMessage(String string, String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            return Localizer.getFormatedString("UserMsg_" + string + "_ShortMessage", stringArray);
        }
        return Localizer.getString("UserMsg_" + string + "_ShortMessage");
    }

    private long determineUserMsgAutoCloseDelay(String string) {
        try {
            return Long.parseLong(Localizer.getString("UserMsg_" + string + "_AutoCloseDelay"));
        }
        catch (NumberFormatException numberFormatException) {
            return 30000L;
        }
    }
}

