/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Hashtable;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import phex.utils.Logger;
import phex.utils.NLogger;

public class IconFactory {
    private static final ImageIcon MISSING_IMAGE = new ImageIcon(IconFactory.class.getResource("/phex/gui/resources/image-failed.gif"));
    public static final ImageIcon EMPTY_IMAGE_16;
    private Hashtable table = new Hashtable();
    private ResourceBundle resource;

    public IconFactory(String string) {
        this.resource = PropertyResourceBundle.getBundle(string);
    }

    public Icon getIcon(String string) {
        TKIcon tKIcon = (TKIcon)this.table.get(string);
        if (tKIcon == null) {
            tKIcon = new TKIcon(string);
            this.table.put(string, tKIcon);
        }
        return tKIcon;
    }

    static {
        BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
        EMPTY_IMAGE_16 = new ImageIcon(bufferedImage);
    }

    class TKIcon
    extends ImageIcon {
        private String key;
        private boolean loaded;

        TKIcon(String string) {
            this.key = string;
            this.loaded = false;
        }

        public Image getImage() {
            this.loadIcon();
            return super.getImage();
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.loadIcon();
            super.paintIcon(component, graphics, n, n2);
        }

        public int getIconWidth() {
            this.loadIcon();
            return super.getIconWidth();
        }

        public int getIconHeight() {
            this.loadIcon();
            return super.getIconHeight();
        }

        private void loadIcon() {
            if (this.loaded) {
                return;
            }
            try {
                if (this.key != null) {
                    String string = this.key.startsWith("Flag_") ? "/phex/gui/resources/flags/" + this.key.substring(5).toLowerCase() + ".png" : IconFactory.this.resource.getString(this.key);
                    URL uRL = null;
                    if (string != null) {
                        uRL = (class$phex$gui$common$IconFactory == null ? (class$phex$gui$common$IconFactory = IconFactory.class$("phex.gui.common.IconFactory")) : class$phex$gui$common$IconFactory).getResource(string);
                    }
                    Image image = null;
                    if (uRL != null) {
                        image = Toolkit.getDefaultToolkit().createImage(uRL);
                    }
                    if (image == null) {
                        Logger.logMessage(Logger.WARNING, (short)32, "Can't find image for key: " + this.key + " URL: " + string);
                        image = MISSING_IMAGE.getImage();
                    }
                    super.setImage(image);
                    this.loaded = true;
                }
            }
            catch (Exception exception) {
                NLogger.error("USER_INTERFACE", (Object)exception, (Throwable)exception);
            }
        }
    }
}

