/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.lang.SystemUtils;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.LookAndFeelFailedException;
import phex.utils.ClassUtils;
import phex.utils.NLogger;

public class LookAndFeelUtils {
    private static ThemeInfo[] plasticThemes;

    public static UIManager.LookAndFeelInfo[] getAvailableLAFs() {
        Class<?> clazz;
        ArrayList<UIManager.LookAndFeelInfo> arrayList = new ArrayList<UIManager.LookAndFeelInfo>();
        if (SystemUtils.IS_OS_MAC_OSX) {
            arrayList.add(new UIManager.LookAndFeelInfo("Macintosh", UIManager.getSystemLookAndFeelClassName()));
        }
        arrayList.add(new UIManager.LookAndFeelInfo("PlasticXP (default)", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel"));
        arrayList.add(new UIManager.LookAndFeelInfo("Metal", "javax.swing.plaf.metal.MetalLookAndFeel"));
        if (SystemUtils.IS_OS_WINDOWS) {
            arrayList.add(new UIManager.LookAndFeelInfo("Windows", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel"));
        }
        try {
            clazz = Class.forName("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        if (clazz != null) {
            arrayList.add(new UIManager.LookAndFeelInfo("GTK", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel"));
        }
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = new UIManager.LookAndFeelInfo[arrayList.size()];
        arrayList.toArray(lookAndFeelInfoArray);
        return lookAndFeelInfoArray;
    }

    public static ThemeInfo[] getAvailableThemes(String string) {
        if (string.equals("com.jgoodies.looks.plastic.PlasticXPLookAndFeel")) {
            LookAndFeelUtils.initPlasticThemes();
            return plasticThemes;
        }
        return new ThemeInfo[0];
    }

    public static ThemeInfo getCurrentTheme(String string) {
        if ("com.jgoodies.looks.plastic.PlasticXPLookAndFeel".equals(string)) {
            PlasticTheme plasticTheme = PlasticLookAndFeel.getMyCurrentTheme();
            if (plasticTheme == null) {
                return null;
            }
            Class<?> clazz = plasticTheme.getClass();
            String string2 = clazz.getName();
            return new ThemeInfo(string2, string2);
        }
        return null;
    }

    public static void setCurrentTheme(String string, Object object) {
        if (string.equals("com.jgoodies.looks.plastic.PlasticXPLookAndFeel")) {
            PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)object);
            try {
                UIManager.setLookAndFeel(UIManager.getLookAndFeel());
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                NLogger.error("USER_INTERFACE", (Object)unsupportedLookAndFeelException, (Throwable)unsupportedLookAndFeelException);
            }
        }
        GUIUtils.updateComponentsUI();
    }

    public static LookAndFeel determineLAF(String string) {
        String string2 = string;
        LookAndFeel lookAndFeel = (LookAndFeel)ClassUtils.newInstanceQuitly(ClassUtils.classForNameQuitly(string2));
        if (lookAndFeel != null && lookAndFeel.isSupportedLookAndFeel()) {
            return lookAndFeel;
        }
        string2 = LookAndFeelUtils.getDefaultLAFClassName();
        lookAndFeel = (LookAndFeel)ClassUtils.newInstanceQuitly(ClassUtils.classForNameQuitly(string2));
        if (lookAndFeel != null && lookAndFeel.isSupportedLookAndFeel()) {
            return lookAndFeel;
        }
        string2 = UIManager.getCrossPlatformLookAndFeelClassName();
        lookAndFeel = (LookAndFeel)ClassUtils.newInstanceQuitly(ClassUtils.classForNameQuitly(string2));
        return lookAndFeel;
    }

    private static String getDefaultLAFClassName() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        return "com.jgoodies.looks.plastic.PlasticXPLookAndFeel";
    }

    public static void setLookAndFeel(String string) throws LookAndFeelFailedException {
        try {
            Class<?> clazz = Class.forName(string);
            LookAndFeelUtils.setLookAndFeel((LookAndFeel)clazz.newInstance());
        }
        catch (ClassNotFoundException classNotFoundException) {
            NLogger.error("USER_INTERFACE", (Object)("Class not found: " + string), (Throwable)classNotFoundException);
            JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), "Error loading Look & Feel " + classNotFoundException, "Error", 0);
            throw new LookAndFeelFailedException("Class not found: " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            NLogger.error("USER_INTERFACE", (Object)("Illegal access: " + string), (Throwable)illegalAccessException);
            JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), "Error loading Look & Feel " + illegalAccessException, "Error", 0);
            throw new LookAndFeelFailedException("Illegal access: " + string);
        }
        catch (InstantiationException instantiationException) {
            NLogger.error("USER_INTERFACE", (Object)("Instantiation failed: " + string), (Throwable)instantiationException);
            JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), "Error loading Look & Feel " + instantiationException, "Error", 0);
            throw new LookAndFeelFailedException("Instantiation faield: " + string);
        }
        catch (Throwable throwable) {
            NLogger.error("USER_INTERFACE", (Object)("Error loading LAF: " + string), throwable);
            JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), "Error loading Look & Feel " + throwable, "Error", 0);
        }
    }

    public static void setLookAndFeel(LookAndFeel lookAndFeel) throws LookAndFeelFailedException {
        try {
            if (lookAndFeel.getID().equals(UIManager.getLookAndFeel().getID())) {
                return;
            }
            UIManager.setLookAndFeel(lookAndFeel);
            GUIUtils.updateComponentsUI();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            NLogger.error("USER_INTERFACE", (Object)("Instantiation faield: " + lookAndFeel.getName()), (Throwable)unsupportedLookAndFeelException);
            throw new LookAndFeelFailedException("Instantiation faield: " + lookAndFeel.getName());
        }
    }

    private static void initPlasticThemes() {
        if (plasticThemes == null) {
            String string = "com.jgoodies.looks.plastic.theme.";
            plasticThemes = new ThemeInfo[18];
            LookAndFeelUtils.plasticThemes[0] = new ThemeInfo("BrownSugar", string + "BrownSugar");
            LookAndFeelUtils.plasticThemes[1] = new ThemeInfo("DarkStar", string + "DarkStar");
            LookAndFeelUtils.plasticThemes[2] = new ThemeInfo("DesertBlue", string + "DesertBlue");
            LookAndFeelUtils.plasticThemes[3] = !LookUtils.IS_LAF_WINDOWS_XP_ENABLED && LookUtils.IS_OS_WINDOWS_MODERN ? new ThemeInfo("DesertBluer (default)", string + "DesertBluer") : new ThemeInfo("DesertBluer", string + "DesertBluer");
            LookAndFeelUtils.plasticThemes[4] = new ThemeInfo("DesertGreen", string + "DesertGreen");
            LookAndFeelUtils.plasticThemes[5] = new ThemeInfo("DesertRed", string + "DesertRed");
            LookAndFeelUtils.plasticThemes[6] = new ThemeInfo("DesertYellow", string + "DesertYellow");
            LookAndFeelUtils.plasticThemes[7] = LookUtils.IS_LAF_WINDOWS_XP_ENABLED ? new ThemeInfo("ExperienceBlue (default)", string + "ExperienceBlue") : new ThemeInfo("ExperienceBlue", string + "ExperienceBlue");
            LookAndFeelUtils.plasticThemes[8] = new ThemeInfo("ExperienceGreen", string + "ExperienceGreen");
            LookAndFeelUtils.plasticThemes[9] = new ThemeInfo("Silver", string + "Silver");
            LookAndFeelUtils.plasticThemes[10] = !LookUtils.IS_OS_WINDOWS_XP && !LookUtils.IS_OS_WINDOWS_MODERN ? new ThemeInfo("SkyBlue (default)", string + "SkyBlue") : new ThemeInfo("SkyBlue", string + "SkyBlue");
            LookAndFeelUtils.plasticThemes[11] = new ThemeInfo("SkyBluer", string + "SkyBluer");
            LookAndFeelUtils.plasticThemes[13] = new ThemeInfo("SkyGreen", string + "SkyGreen");
            LookAndFeelUtils.plasticThemes[14] = new ThemeInfo("SkyKrupp", string + "SkyKrupp");
            LookAndFeelUtils.plasticThemes[15] = new ThemeInfo("SkyPink", string + "SkyPink");
            LookAndFeelUtils.plasticThemes[16] = new ThemeInfo("SkyRed", string + "SkyRed");
            LookAndFeelUtils.plasticThemes[17] = new ThemeInfo("SkyYellow", string + "SkyYellow");
        }
    }

    public static class ThemeInfo {
        private String name;
        private String className;

        public ThemeInfo(String string, String string2) {
            this.name = string;
            this.className = string2;
        }

        public String getClassName() {
            return this.className;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ThemeInfo)) {
                return false;
            }
            return this.className.equals(((ThemeInfo)object).className);
        }
    }
}

