/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import com.jgoodies.looks.HeaderStyle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.connection.NetworkManager;
import phex.gui.actions.ExitPhexAction;
import phex.gui.actions.FWToggleAction;
import phex.gui.common.DesktopIndicator;
import phex.gui.common.DesktopIndicatorListener;
import phex.gui.common.FWLogoPanel;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.MainMenuBar;
import phex.gui.common.SplashWindow;
import phex.gui.common.statusbar.MainStatusBar;
import phex.gui.dialogs.RespectCopyrightDialog;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.SecurityTab;
import phex.gui.tabs.StatisticsTab;
import phex.gui.tabs.UploadTab;
import phex.gui.tabs.download.SWDownloadTab;
import phex.gui.tabs.library.LibraryTab;
import phex.gui.tabs.network.NetworkTab;
import phex.gui.tabs.search.SearchTab;
import phex.gui.tabs.search.monitor.ResultMonitorTab;
import phex.gui.tabs.search.monitor.SearchMonitorTab;
import phex.utils.NLogger;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTab;

public class MainFrame
extends JFrame {
    public static final int NETWORK_TAB_ID = 1000;
    public static final int SEARCH_TAB_ID = 1101;
    public static final int DOWNLOAD_TAB_ID = 1003;
    public static final int UPLOAD_TAB_ID = 1004;
    public static final int SECURITY_TAB_ID = 1005;
    public static final int STATISTICS_TAB_ID = 1006;
    public static final int LIBRARY_TAB_ID = 1007;
    public static final int SEARCH_MONITOR_TAB_ID = 1008;
    public static final int RESULT_MONITOR_TAB_ID = 1009;
    public static final int NETWORK_TAB_INDEX = 0;
    public static final int SEARCH_TAB_INDEX = 1;
    public static final int DOWNLOAD_TAB_INDEX = 2;
    public static final int UPLOAD_TAB_INDEX = 3;
    public static final int LIBRARY_TAB_INDEX = 4;
    public static final int SECURITY_TAB_INDEX = 5;
    public static final int STATISTICS_TAB_INDEX = 6;
    public static final int SEARCH_MONITOR_TAB_INDEX = 7;
    public static final int RESULT_MONITOR_TAB_INDEX = 8;
    private JTabbedPane tabbedPane;
    private JPanel logoPanel;
    private Timer refresher;
    private FWToolBar toolbar;
    private NetworkTab networkTab;
    private SearchTab searchTab;
    private UploadTab uploadTab;
    private LibraryTab libraryTab;
    private SWDownloadTab swDownloadTab;
    private SecurityTab securityTab;
    private StatisticsTab statisticsTab;
    private SearchMonitorTab searchMonitorTab;
    private ResultMonitorTab resultMonitorTab;
    private MainStatusBar statusBar;

    public MainFrame(SplashWindow splashWindow, DGuiSettings dGuiSettings) {
        Icon icon = GUIRegistry.getInstance().getIconFactory().getIcon("Phex16");
        if (icon != null) {
            this.setIconImage(((ImageIcon)icon).getImage());
        }
        this.setupComponents(dGuiSettings);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler());
        DesktopIndicator desktopIndicator = GUIRegistry.getInstance().getDesktopIndicator();
        if (desktopIndicator != null) {
            desktopIndicator.addDesktopIndicatorListener(new DesktopIndicatorHandler());
        }
        this.pack();
        this.initFrameSize(dGuiSettings);
        this.setTitle();
        this.refresher = new Timer(1000, new RefreshHandler());
        this.refresher.start();
    }

    private void initFrameSize(DGuiSettings dGuiSettings) {
        int n;
        GUIUtils.centerAndSizeWindow(this, 7, 8);
        if (dGuiSettings == null) {
            return;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = this.getBounds();
        if (dGuiSettings.isSetWindowWidth()) {
            rectangle.width = Math.min(dimension.width, dGuiSettings.getWindowWidth());
        }
        if (dGuiSettings.isSetWindowHeight()) {
            rectangle.height = Math.min(dimension.height, dGuiSettings.getWindowHeight());
        }
        if (dGuiSettings.isSetWindowPosX()) {
            n = dGuiSettings.getWindowPosX();
            rectangle.x = Math.max(0, Math.min(n + rectangle.width, (int)dimension.getWidth()) - rectangle.width);
        }
        if (dGuiSettings.isSetWindowPosY()) {
            n = dGuiSettings.getWindowPosY();
            rectangle.y = Math.max(0, Math.min(n + rectangle.height, (int)dimension.getHeight()) - rectangle.height);
        }
        NLogger.debug(MainFrame.class, (Object)("Frame position: " + rectangle));
        this.setBounds(rectangle);
    }

    private void setupComponents(DGuiSettings dGuiSettings) {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setMinimumSize(new Dimension(50, 50));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Component component = MainFrame.this.tabbedPane.getSelectedComponent();
                if (component instanceof FWTab) {
                    ((FWTab)component).tabSelectedNotify();
                }
            }
        });
        this.networkTab = new NetworkTab(this);
        this.networkTab.initComponent(dGuiSettings);
        this.initializeTab(this.networkTab, 1000, dGuiSettings);
        this.searchTab = new SearchTab();
        this.searchTab.initComponent(dGuiSettings);
        this.initializeTab(this.searchTab, 1101, dGuiSettings);
        this.swDownloadTab = new SWDownloadTab(this);
        this.swDownloadTab.initComponent(dGuiSettings);
        this.initializeTab(this.swDownloadTab, 1003, dGuiSettings);
        this.uploadTab = new UploadTab(this);
        this.uploadTab.initComponent(dGuiSettings);
        this.initializeTab(this.uploadTab, 1004, dGuiSettings);
        this.libraryTab = new LibraryTab();
        this.libraryTab.initComponent(dGuiSettings);
        this.initializeTab(this.libraryTab, 1007, dGuiSettings);
        this.securityTab = new SecurityTab();
        this.securityTab.initComponent(dGuiSettings);
        this.initializeTab(this.securityTab, 1005, dGuiSettings);
        this.statisticsTab = new StatisticsTab();
        this.statisticsTab.initComponent(dGuiSettings);
        this.initializeTab(this.statisticsTab, 1006, dGuiSettings);
        this.searchMonitorTab = new SearchMonitorTab();
        this.searchMonitorTab.initComponent(dGuiSettings);
        this.initializeTab(this.searchMonitorTab, 1008, dGuiSettings);
        this.resultMonitorTab = new ResultMonitorTab();
        this.resultMonitorTab.initComponent(dGuiSettings);
        this.initializeTab(this.resultMonitorTab, 1009, dGuiSettings);
        if (this.tabbedPane.getTabCount() == 0) {
            this.getContentPane().add("Center", this.getLogoPanel());
        } else {
            this.tabbedPane.setSelectedIndex(0);
            this.getContentPane().add("Center", this.tabbedPane);
        }
        MainMenuBar mainMenuBar = new MainMenuBar(this, dGuiSettings);
        this.setJMenuBar(mainMenuBar);
        mainMenuBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
        boolean bl = true;
        if (dGuiSettings != null && dGuiSettings.isSetToolbarVisible()) {
            bl = dGuiSettings.isToolbarVisible();
        }
        if (bl) {
            this.setToolbarVisible(true);
        }
        boolean bl2 = true;
        if (dGuiSettings != null && dGuiSettings.isSetStatusbarVisible()) {
            bl2 = dGuiSettings.isStatusbarVisible();
        }
        if (bl2) {
            this.setStatusbarVisible(true);
        }
    }

    public void setTitle() {
        StringBuffer stringBuffer = new StringBuffer(Environment.getPhexVendor());
        NetworkManager networkManager = NetworkManager.getInstance();
        if (networkManager.isNetworkJoined()) {
            stringBuffer.append(" - ");
            stringBuffer.append(networkManager.getGnutellaNetwork().getName());
        }
        if (ServiceManager.sCfg.mProxyUse) {
            stringBuffer.append("  (via Proxy Server)");
        }
        super.setTitle(stringBuffer.toString());
    }

    public void setTabVisible(FWTab fWTab, boolean bl) {
        if (bl) {
            int n;
            int n2 = this.tabbedPane.getTabCount();
            int n3 = fWTab.getIndex();
            if (n2 == 0) {
                n = 0;
            } else {
                n = n2;
                FWTab fWTab2 = (FWTab)this.tabbedPane.getComponentAt(n - 1);
                int n4 = fWTab2.getIndex();
                while (n4 > n3 && --n != 0) {
                    fWTab2 = (FWTab)this.tabbedPane.getComponentAt(n - 1);
                    n4 = fWTab2.getIndex();
                }
            }
            int n5 = this.tabbedPane.getTabCount();
            if (n5 == 0) {
                this.getContentPane().remove(this.getLogoPanel());
                this.getContentPane().add("Center", this.tabbedPane);
                this.tabbedPane.setVisible(true);
                this.getContentPane().invalidate();
                this.getContentPane().repaint();
            }
            this.tabbedPane.insertTab(fWTab.getName(), fWTab.getIcon(), fWTab, fWTab.getToolTip(), n);
            this.tabbedPane.setSelectedIndex(n);
            if (n5 == 0) {
                fWTab.setVisible(true);
            }
        } else {
            this.tabbedPane.remove(fWTab);
            if (this.tabbedPane.getTabCount() == 0) {
                this.getContentPane().remove(this.tabbedPane);
                this.getContentPane().add("Center", this.getLogoPanel());
                this.getContentPane().invalidate();
                this.getContentPane().repaint();
                this.tabbedPane.setVisible(false);
            }
        }
    }

    public void setSelectedTab(int n) {
        FWTab fWTab = this.getTab(n);
        this.setSelectedTab(fWTab);
    }

    public FWTab getSelectedTab() {
        if (this.tabbedPane.getTabCount() == 0) {
            return null;
        }
        return (FWTab)this.tabbedPane.getSelectedComponent();
    }

    public void setSelectedTab(FWTab fWTab) {
        if (fWTab == null) {
            return;
        }
        FWToggleAction fWToggleAction = fWTab.getToggleTabViewAction();
        if (!fWToggleAction.isSelected()) {
            fWToggleAction.actionPerformed(new ActionEvent(this, 0, null));
        }
        this.tabbedPane.setSelectedComponent(fWTab);
    }

    public FWTab getTab(int n) {
        switch (n) {
            case 1000: {
                return this.networkTab;
            }
            case 1101: {
                return this.searchTab;
            }
            case 1003: {
                return this.swDownloadTab;
            }
            case 1005: {
                return this.securityTab;
            }
            case 1006: {
                return this.statisticsTab;
            }
            case 1004: {
                return this.uploadTab;
            }
            case 1007: {
                return this.libraryTab;
            }
            case 1008: {
                return this.searchMonitorTab;
            }
            case 1009: {
                return this.resultMonitorTab;
            }
        }
        NLogger.warn(MainFrame.class, (Object)("Unknown tab id: " + n));
        return null;
    }

    public void saveGUISettings(DGuiSettings dGuiSettings) {
        Rectangle rectangle = this.getBounds();
        dGuiSettings.setWindowHeight(rectangle.height);
        dGuiSettings.setWindowWidth(rectangle.width);
        dGuiSettings.setWindowPosX(rectangle.x);
        dGuiSettings.setWindowPosY(rectangle.y);
        dGuiSettings.setToolbarVisible(this.toolbar != null);
        this.networkTab.appendDGuiSettings(dGuiSettings);
        this.searchTab.appendDGuiSettings(dGuiSettings);
        this.swDownloadTab.appendDGuiSettings(dGuiSettings);
        this.uploadTab.appendDGuiSettings(dGuiSettings);
        this.libraryTab.appendDGuiSettings(dGuiSettings);
        this.securityTab.appendDGuiSettings(dGuiSettings);
        this.statisticsTab.appendDGuiSettings(dGuiSettings);
        this.searchMonitorTab.appendDGuiSettings(dGuiSettings);
        this.resultMonitorTab.appendDGuiSettings(dGuiSettings);
    }

    private void initializeTab(FWTab fWTab, int n, DGuiSettings dGuiSettings) {
        DTab dTab = GUIUtils.getDGuiTabById(dGuiSettings, n);
        boolean bl = fWTab.isVisibleByDefault();
        if (dTab != null && dTab.isSetVisible()) {
            bl = dTab.isVisible();
        }
        this.setTabVisible(fWTab, bl);
    }

    private JPanel getLogoPanel() {
        if (this.logoPanel == null) {
            ImageIcon imageIcon = new ImageIcon(MainFrame.class.getResource("/phex/resources/splash.jpg"));
            Image image = imageIcon.getImage();
            this.logoPanel = new FWLogoPanel(image);
            this.logoPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        }
        return this.logoPanel;
    }

    public boolean isToolbarVisible() {
        return this.toolbar != null;
    }

    public void setToolbarVisible(boolean bl) {
        if (bl) {
            if (this.toolbar != null) {
                return;
            }
            this.toolbar = new FWToolBar(0);
            this.toolbar.setShowText(false);
            this.toolbar.addAction(GUIRegistry.getInstance().getGlobalAction("ExitPhexAction"));
            this.toolbar.addSeparator();
            this.toolbar.addAction(GUIRegistry.getInstance().getGlobalAction("ConnectNetworkAction"));
            this.toolbar.addAction(GUIRegistry.getInstance().getGlobalAction("DisconnectNetworkAction"));
            this.toolbar.addSeparator();
            this.toolbar.addAction(this.networkTab.getToggleTabViewAction());
            this.toolbar.addAction(this.searchTab.getToggleTabViewAction());
            this.toolbar.addAction(this.swDownloadTab.getToggleTabViewAction());
            this.toolbar.addAction(this.uploadTab.getToggleTabViewAction());
            this.toolbar.addAction(this.libraryTab.getToggleTabViewAction());
            this.toolbar.addAction(this.securityTab.getToggleTabViewAction());
            this.toolbar.addAction(this.statisticsTab.getToggleTabViewAction());
            this.toolbar.addAction(this.searchMonitorTab.getToggleTabViewAction());
            this.toolbar.addAction(this.resultMonitorTab.getToggleTabViewAction());
            this.toolbar.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
            this.getJMenuBar().putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
            this.getContentPane().add("North", this.toolbar);
            this.getContentPane().validate();
        } else {
            this.getContentPane().remove(this.toolbar);
            this.getContentPane().validate();
            this.toolbar = null;
        }
    }

    public void setStatusbarVisible(boolean bl) {
        if (bl) {
            if (this.statusBar != null) {
                return;
            }
            this.statusBar = new MainStatusBar();
            this.getContentPane().add("South", this.statusBar);
            this.getContentPane().validate();
        } else {
            this.getContentPane().remove(this.statusBar);
            this.getContentPane().validate();
            this.statusBar = null;
        }
    }

    private class RefreshHandler
    implements ActionListener {
        private RefreshHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.networkTab.refresh();
        }
    }

    private class DesktopIndicatorHandler
    implements DesktopIndicatorListener {
        private DesktopIndicatorHandler() {
        }

        public void onDesktopIndicatorClicked(DesktopIndicator desktopIndicator) {
            MainFrame.this.setVisible(true);
            desktopIndicator.hideIndicator();
            if (MainFrame.this.getState() != 0) {
                MainFrame.this.setState(0);
            }
            MainFrame.this.requestFocus();
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ExitPhexAction.performCloseGUIAction();
        }

        public void windowOpened(WindowEvent windowEvent) {
            if (GUIRegistry.getInstance().isRespectCopyrightNoticeShown()) {
                RespectCopyrightDialog respectCopyrightDialog = new RespectCopyrightDialog();
                respectCopyrightDialog.setVisible(true);
            }
        }
    }
}

