/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.UIManager;
import phex.download.DownloadScope;
import phex.download.DownloadScopeList;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.gui.common.PhexColors;

public class MultiScopeProgressBar
extends JPanel {
    private long fileSize;
    public DownloadScopeList primaryScopeList;
    public DownloadScopeList secondaryScopeList;
    private static Rectangle viewRect = new Rectangle();
    private boolean isPreferredSizeSet = false;
    private boolean isMaximumSizeSet = false;
    private boolean isMinimumSizeSet = false;

    public MultiScopeProgressBar() {
        this.setBackground(PhexColors.getScopeProgressBarBackground());
        this.setForeground(PhexColors.getScopeProgressBarForeground());
        this.setBorder(UIManager.getBorder("ProgressBar.border"));
    }

    public void setDownloadFile(SWDownloadFile sWDownloadFile) {
        if (sWDownloadFile == null) {
            this.fileSize = 0L;
            this.primaryScopeList = null;
            this.secondaryScopeList = null;
        } else {
            this.fileSize = sWDownloadFile.getTotalDataSize();
            this.primaryScopeList = sWDownloadFile.getFinishedScopeList();
            this.secondaryScopeList = sWDownloadFile.getBlockedScopeList();
        }
        this.repaint();
    }

    public void setCandidate(SWDownloadCandidate sWDownloadCandidate) {
        this.fileSize = sWDownloadCandidate.getDownloadFile().getTotalDataSize();
        this.primaryScopeList = sWDownloadCandidate.getAvailableScopeList();
        this.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Insets insets = this.getInsets();
        MultiScopeProgressBar.viewRect.x = insets.left;
        MultiScopeProgressBar.viewRect.y = insets.top;
        MultiScopeProgressBar.viewRect.width = this.getWidth() - (insets.right + MultiScopeProgressBar.viewRect.x);
        MultiScopeProgressBar.viewRect.height = this.getHeight() - (insets.bottom + MultiScopeProgressBar.viewRect.y);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.primaryScopeList != null) {
            this.paintScopeList(this.primaryScopeList, this.getForeground(), graphics2D);
        }
        if (this.secondaryScopeList != null) {
            this.paintScopeList(this.secondaryScopeList, PhexColors.getScopeProgressBarSecondaryForeground(), graphics2D);
        }
    }

    private void paintScopeList(DownloadScopeList downloadScopeList, Color color, Graphics2D graphics2D) {
        float f = (this.fileSize - 1L) / (long)MultiScopeProgressBar.viewRect.width;
        Iterator iterator = downloadScopeList.getScopeIterator();
        while (iterator.hasNext()) {
            DownloadScope downloadScope = (DownloadScope)iterator.next();
            float f2 = (float)downloadScope.getStart() / f;
            float f3 = (float)downloadScope.getEnd() / f;
            float f4 = f3 - f2;
            int n = (int)Math.min(245.0f * f4, 245.0f) + 10;
            Color color2 = n < 255 ? new Color(color.getRed(), color.getGreen(), color.getBlue(), n) : color;
            graphics2D.setColor(color2);
            int n2 = (int)Math.max(f4, 1.0f);
            graphics2D.fillRect(MultiScopeProgressBar.viewRect.x + (int)f2, MultiScopeProgressBar.viewRect.y, n2, MultiScopeProgressBar.viewRect.height);
        }
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return this.computePreferredSize();
    }

    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        return this.computeMaximumSize();
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        return this.computeMinimumSize();
    }

    public boolean isPreferredSizeSet() {
        return this.isPreferredSizeSet;
    }

    public void setPreferredSize(Dimension dimension) {
        this.isPreferredSizeSet = dimension != null;
        super.setPreferredSize(dimension);
    }

    public boolean isMaximumSizeSet() {
        return this.isMaximumSizeSet;
    }

    public void setMaximumSize(Dimension dimension) {
        this.isMaximumSizeSet = dimension != null;
        super.setMaximumSize(dimension);
    }

    public boolean isMinimumSizeSet() {
        return this.isMinimumSizeSet;
    }

    public void setMinimumSize(Dimension dimension) {
        this.isMinimumSizeSet = dimension != null;
        super.setMinimumSize(dimension);
    }

    protected Dimension computePreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = 25;
        return dimension;
    }

    protected Dimension computeMaximumSize() {
        return this.computePreferredSize();
    }

    protected Dimension computeMinimumSize() {
        return this.computePreferredSize();
    }
}

