/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import phex.gui.common.GUIRegistry;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTableColumn;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.renderer.DefaultPhexCellRenderers;

public class FWTable
extends JTable {
    private int visibleRowCount = 18;
    private boolean isColumnResizeToFitEnabled = false;
    private boolean isColumnSortingEnabled = false;
    private JPopupMenu headerPopup;

    public FWTable(TableModel tableModel, FWTableColumnModel fWTableColumnModel) {
        super(tableModel, fWTableColumnModel);
        this.tableHeader.addMouseListener(new MouseHandler());
        DefaultPhexCellRenderers.setDefaultPhexCellRenderers(this);
    }

    public FWTable(TableModel tableModel) {
        this(tableModel, null);
    }

    public void setVisibleRowCount(int n) {
        this.visibleRowCount = n;
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = super.getPreferredScrollableViewportSize();
        if (dimension.getWidth() == 450.0 && dimension.getHeight() == 400.0) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            int n = tableColumnModel.getColumnCount();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                n2 += tableColumn.getPreferredWidth();
            }
            dimension.width = n2;
            JTableHeader jTableHeader = this.getTableHeader();
            int n3 = this.getVisibleRowCount();
            dimension.height = n3 * this.getRowHeight() + (jTableHeader != null ? jTableHeader.getPreferredSize().height : 0);
            this.setPreferredScrollableViewportSize(dimension);
        }
        return dimension;
    }

    public void updateUI() {
        super.updateUI();
        GUIRegistry gUIRegistry = GUIRegistry.getInstance();
        boolean bl = gUIRegistry.getShowTableHorizontalLines();
        boolean bl2 = gUIRegistry.getShowTableVerticalLines();
        this.setShowHorizontalLines(bl);
        this.setShowVerticalLines(bl2);
        int n = bl2 ? 1 : 0;
        int n2 = bl ? 1 : 0;
        this.setIntercellSpacing(new Dimension(n, n2));
    }

    public void scrollRowToVisible(int n) {
        Rectangle rectangle = this.getCellRect(n, 0, false);
        Rectangle rectangle2 = this.getVisibleRect();
        rectangle.x = rectangle2.x;
        rectangle.width = rectangle2.width;
        this.scrollRectToVisible(rectangle);
    }

    public static JScrollPane createFWTableScrollPane(JTable jTable) {
        JScrollPane jScrollPane = new JScrollPane(jTable);
        FWTable.updateFWTableScrollPane(jScrollPane);
        return jScrollPane;
    }

    public static void updateFWTableScrollPane(JScrollPane jScrollPane) {
        Color color = (Color)UIManager.getDefaults().get("window");
        Color color2 = new Color(color.getRGB());
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setBackground(color2);
        jViewport.setOpaque(true);
    }

    public void activateAllHeaderActions() {
        this.activateHeaderPopupMenu();
        this.activateColumnResizeToFit();
        this.activateColumnSorting();
    }

    public void activateColumnSorting() {
        this.setColumnSelectionAllowed(false);
        this.isColumnSortingEnabled = true;
        FWSortedTableModel fWSortedTableModel = (FWSortedTableModel)this.dataModel;
        fWSortedTableModel.setTableHeader(this.tableHeader);
    }

    public List getColumns() {
        return Collections.list(this.getColumnModel().getColumns());
    }

    public List getColumns(boolean bl) {
        if (bl && this.getColumnModel() instanceof FWTableColumnModel) {
            return ((FWTableColumnModel)this.getColumnModel()).getColumns(bl);
        }
        return this.getColumns();
    }

    public void activateColumnResizeToFit() {
        this.isColumnResizeToFitEnabled = true;
    }

    public void activateHeaderPopupMenu() {
        this.headerPopup = new JPopupMenu();
        PopupMenuActionHandler popupMenuActionHandler = new PopupMenuActionHandler();
        Iterator iterator = ((FWTableColumnModel)this.columnModel).createAllColumnsIterator();
        while (iterator.hasNext()) {
            FWTableColumn fWTableColumn = (FWTableColumn)iterator.next();
            ColumnCheckBoxMenuItem columnCheckBoxMenuItem = new ColumnCheckBoxMenuItem(fWTableColumn);
            columnCheckBoxMenuItem.setEnabled(fWTableColumn.isHideable());
            columnCheckBoxMenuItem.addActionListener(popupMenuActionHandler);
            this.headerPopup.add(columnCheckBoxMenuItem);
        }
    }

    public int convertRowIndexToModel(int n) {
        if (this.isColumnSortingEnabled) {
            return ((FWSortedTableModel)this.dataModel).getModelIndex(n);
        }
        return n;
    }

    public int[] convertRowIndicesToModel(int[] nArray) {
        if (this.isColumnSortingEnabled) {
            FWSortedTableModel fWSortedTableModel = (FWSortedTableModel)this.dataModel;
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = fWSortedTableModel.getModelIndex(nArray[i]);
            }
            return nArray2;
        }
        return nArray;
    }

    public int convertRowIndexToView(int n) {
        if (this.isColumnSortingEnabled) {
            return ((FWSortedTableModel)this.dataModel).getViewIndex(n);
        }
        return n;
    }

    public FWTableColumn getResizingColumn(Point point) {
        int n;
        int n2 = this.tableHeader.columnAtPoint(point);
        if (n2 == -1) {
            return null;
        }
        Rectangle rectangle = this.tableHeader.getHeaderRect(n2);
        rectangle.grow(-3, 0);
        if (rectangle.contains(point)) {
            return null;
        }
        int n3 = rectangle.x + rectangle.width / 2;
        if (this.tableHeader.getComponentOrientation().isLeftToRight()) {
            n = point.x < n3 ? n2 - 1 : n2;
        } else {
            int n4 = n = point.x < n3 ? n2 : n2 - 1;
        }
        if (n == -1) {
            return null;
        }
        return (FWTableColumn)this.tableHeader.getColumnModel().getColumn(n);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        Rectangle rectangle;
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1) {
            super.tableChanged(tableModelEvent);
            return;
        }
        if (tableModelEvent.getType() == 1 || tableModelEvent.getType() == -1) {
            super.tableChanged(tableModelEvent);
            return;
        }
        int n = tableModelEvent.getColumn();
        int n2 = tableModelEvent.getFirstRow();
        int n3 = tableModelEvent.getLastRow();
        if (n == -1) {
            rectangle = new Rectangle(0, n2 * this.getRowHeight(), this.getColumnModel().getTotalColumnWidth(), 0);
        } else {
            int n4 = this.convertColumnIndexToView(n);
            rectangle = this.getCellRect(n2, n4, false);
        }
        if (n3 != Integer.MAX_VALUE) {
            rectangle.height = (n3 - n2 + 1) * this.getRowHeight();
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.resizeAndRepaint();
        }
    }

    private class ColumnCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        private FWTableColumn column;

        public ColumnCheckBoxMenuItem(FWTableColumn fWTableColumn) {
            super((String)fWTableColumn.getHeaderValue(), fWTableColumn.isVisible());
            this.column = fWTableColumn;
        }

        public FWTableColumn getTableColumn() {
            return this.column;
        }
    }

    private class PopupMenuActionHandler
    implements ActionListener {
        private PopupMenuActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ColumnCheckBoxMenuItem columnCheckBoxMenuItem = (ColumnCheckBoxMenuItem)actionEvent.getSource();
            FWTableColumn fWTableColumn = columnCheckBoxMenuItem.getTableColumn();
            if (columnCheckBoxMenuItem.getState()) {
                ((FWTableColumnModel)FWTable.this.columnModel).showColumn(fWTableColumn);
            } else {
                ((FWTableColumnModel)FWTable.this.columnModel).hideColumn(fWTableColumn);
            }
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            FWTableColumn fWTableColumn = FWTable.this.getResizingColumn(mouseEvent.getPoint());
            int n = mouseEvent.getClickCount();
            if (n >= 2) {
                this.handleColumnResizeToFit(fWTableColumn);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void handleColumnResizeToFit(FWTableColumn fWTableColumn) {
            if (!FWTable.this.isColumnResizeToFitEnabled) {
                return;
            }
            if (fWTableColumn != null) {
                fWTableColumn.sizeWidthToFitData(FWTable.this, FWTable.this.dataModel);
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (FWTable.this.headerPopup != null) {
                FWTable.this.headerPopup.show(component, n, n2);
            }
        }
    }
}

