/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.treetable;

import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import phex.gui.common.table.FWTableModel;
import phex.gui.common.treetable.JTreeTable;
import phex.gui.common.treetable.TreeTableModel;
import phex.gui.models.ISortableModel;

public class TreeTableModelAdapter
extends FWTableModel
implements ISortableModel {
    private TreeTableModel model;
    private final JTree tree;
    private JTreeTable treeTable = null;
    private TreeModelListener treeModelListener;
    static final /* synthetic */ boolean $assertionsDisabled;

    TreeTableModelAdapter(TreeTableModel treeTableModel, JTree jTree) {
        if (!$assertionsDisabled && treeTableModel == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && jTree == null) {
            throw new AssertionError();
        }
        this.tree = jTree;
        this.setTreeTableModel(treeTableModel);
        jTree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }

    public void setTreeTableModel(TreeTableModel treeTableModel) {
        TreeTableModel treeTableModel2 = this.getTreeTableModel();
        if (treeTableModel2 != null) {
            treeTableModel2.removeTreeModelListener(this.getTreeModelListener());
        }
        this.model = treeTableModel;
        treeTableModel.addTreeModelListener(this.getTreeModelListener());
        this.fireTableStructureChanged();
    }

    private TreeModelListener getTreeModelListener() {
        if (this.treeModelListener == null) {
            this.treeModelListener = new TreeModelListener(){

                public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged(treeModelEvent, 0);
                }

                public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged(treeModelEvent, 1);
                }

                public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged(treeModelEvent, 2);
                }

                public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged();
                }
            };
        }
        return this.treeModelListener;
    }

    public TreeTableModel getTreeTableModel() {
        return this.model;
    }

    protected JTreeTable getTreeTable() {
        return this.treeTable;
    }

    protected final void bind(JTreeTable jTreeTable) {
        if (jTreeTable == null) {
            throw new IllegalArgumentException("null treeTable");
        }
        if (this.treeTable != null) {
            throw new IllegalArgumentException("adapter already bound");
        }
        this.treeTable = jTreeTable;
    }

    public Class getColumnClass(int n) {
        return this.model.getColumnClass(n);
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.model.getColumnName(n);
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    public Object getValueAt(int n, int n2) {
        return this.model.getValueAt(this.nodeForRow(n), n2);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.model.isCellEditable(this.nodeForRow(n), n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.model.setValueAt(object, this.nodeForRow(n), n2);
    }

    protected Object nodeForRow(int n) {
        return this.tree.getPathForRow(n).getLastPathComponent();
    }

    private void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }

    private void delayedFireTableDataChanged(final TreeModelEvent treeModelEvent, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int[] nArray = treeModelEvent.getChildIndices();
                TreePath treePath = treeModelEvent.getTreePath();
                if (nArray != null) {
                    if (TreeTableModelAdapter.this.tree.isExpanded(treePath)) {
                        int n4 = TreeTableModelAdapter.this.tree.getRowForPath(treePath) + 1;
                        int n2 = Integer.MAX_VALUE;
                        int n3 = Integer.MIN_VALUE;
                        for (int i = 0; i < nArray.length; ++i) {
                            if (nArray[i] < n2) {
                                n2 = nArray[i];
                            }
                            if (nArray[i] <= n3) continue;
                            n3 = nArray[i];
                        }
                        switch (n) {
                            case 0: {
                                TreeTableModelAdapter.this.fireTableRowsUpdated(n4 + n2, n4 + n3);
                                break;
                            }
                            case 1: {
                                TreeTableModelAdapter.this.fireTableRowsInserted(n4 + n2, n4 + n3);
                                break;
                            }
                            case 2: {
                                TreeTableModelAdapter.this.fireTableRowsDeleted(n4 + n2, n4 + n3);
                            }
                        }
                    } else {
                        int n5 = TreeTableModelAdapter.this.tree.getRowForPath(treePath);
                        if (n5 >= 0) {
                            TreeTableModelAdapter.this.fireTableRowsUpdated(n5, n5);
                        }
                    }
                } else {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            }
        });
    }

    public Comparator getColumnComparator(int n) {
        return this.model.getColumnComparator(n);
    }

    public Object getComparableValueAt(int n, int n2) {
        return this.model.getComparableValueAt(this.nodeForRow(n), n2);
    }

    public int mapColumnIDToModelIndex(int n) {
        return this.model.mapColumnIDToModelIndex(n);
    }

    public boolean isColumnHideable(int n) {
        return this.model.isColumnHideable(n);
    }

    public void fireTableDataChanged() {
        super.fireTableDataChanged();
    }

    public int getSortByColumn() {
        if (this.model instanceof ISortableModel) {
            return ((ISortableModel)((Object)this.model)).getSortByColumn();
        }
        throw new UnsupportedOperationException("TreeTableModel not an ISortableModel.");
    }

    public boolean isSortedAscending() {
        if (this.model instanceof ISortableModel) {
            return ((ISortableModel)((Object)this.model)).isSortedAscending();
        }
        throw new UnsupportedOperationException("TreeTableModel not an ISortableModel.");
    }

    public void sortByColumn(int n, boolean bl) {
        if (!(this.model instanceof ISortableModel)) {
            throw new UnsupportedOperationException("TreeTableModel not an ISortableModel.");
        }
        ((ISortableModel)((Object)this.model)).sortByColumn(n, bl);
    }

    static {
        $assertionsDisabled = !TreeTableModelAdapter.class.desiredAssertionStatus();
    }
}

