/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import phex.common.ServiceManager;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.DialogBanner;
import phex.gui.common.GUIRegistry;
import phex.gui.models.CollectionsListModel;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.utils.StringUtils;

public class FilterLibraryDialog
extends JDialog {
    private CollectionsListModel filterListModel;
    private JList filterList;

    public FilterLibraryDialog() throws HeadlessException {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("FilterLibraryDialog_DialogTitle"), false);
        this.prepareComponent();
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FilterLibraryDialog.this.closeDialog();
            }
        });
        CellConstraints cellConstraints = new CellConstraints();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        container.add((Component)jPanel, "Center");
        FormLayout formLayout = new FormLayout("4dlu, fill:d:grow, 4dlu, d, 4dlu", "p, 10dlu, p, 3dlu, p, 3dlu, p, fill:p:grow, 10dlu, p, 6dlu, p, 3dlu, p, 3dlu, p, 10dlu, p, 3dlu, p 6dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        int n = formLayout.getColumnCount();
        int n2 = formLayout.getRowCount();
        DialogBanner dialogBanner = new DialogBanner(Localizer.getString("FilterLibraryDialog_BannerHeader"), Localizer.getString("FilterLibraryDialog_BannerSubHeader"));
        panelBuilder.add((Component)dialogBanner, cellConstraints.xywh(1, 1, n, 1));
        this.filterListModel = new CollectionsListModel();
        this.filterListModel.addAll((Collection)ServiceManager.sCfg.libraryExclusionRegExList);
        this.filterList = new JList(this.filterListModel);
        panelBuilder.add((Component)new JScrollPane(this.filterList), cellConstraints.xywh(2, 3, 1, 6));
        JButton jButton = new JButton(Localizer.getString("FilterLibraryDialog_Add"));
        jButton.addActionListener(new AddBtnListener());
        panelBuilder.add((Component)jButton, cellConstraints.xy(4, 3));
        JButton jButton2 = new JButton(Localizer.getString("FilterLibraryDialog_Edit"));
        jButton2.addActionListener(new EditBtnListener());
        panelBuilder.add((Component)jButton2, cellConstraints.xy(4, 5));
        JButton jButton3 = new JButton(Localizer.getString("FilterLibraryDialog_Remove"));
        jButton3.addActionListener(new RemoveBtnListener());
        panelBuilder.add((Component)jButton3, cellConstraints.xy(4, 7));
        panelBuilder.addSeparator(Localizer.getString("FilterLibraryDialog_Examples"), cellConstraints.xywh(2, 10, 3, 1));
        panelBuilder.addLabel(Localizer.getString("FilterLibraryDialog_Example1"), cellConstraints.xywh(2, 12, 3, 1));
        panelBuilder.addLabel(Localizer.getString("FilterLibraryDialog_Example2"), cellConstraints.xywh(2, 14, 3, 1));
        panelBuilder.addLabel(Localizer.getString("FilterLibraryDialog_Example3"), cellConstraints.xywh(2, 16, 3, 1));
        panelBuilder.add((Component)new JSeparator(), cellConstraints.xywh(1, n2 - 3, n, 1));
        JButton jButton4 = new JButton(Localizer.getString("Cancel"));
        jButton4.addActionListener(new CancelBtnListener());
        JButton jButton5 = new JButton(Localizer.getString("OK"));
        jButton5.addActionListener(new OkBtnListener());
        JPanel jPanel2 = ButtonBarFactory.buildOKCancelBar(jButton5, jButton4);
        panelBuilder.add((Component)jPanel2, cellConstraints.xywh(2, n2 - 1, n - 2, 1));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void addFilter(String string) {
        if (!this.filterListModel.contains(string)) {
            this.filterListModel.add(string);
        }
    }

    private void updateFilter(String string, String string2) {
        if (this.filterListModel.contains(string2)) {
            this.filterListModel.remove(string);
        } else {
            int n = this.filterListModel.indexOf(string);
            this.filterListModel.set(n, string2);
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public class EditFilterDialog
    extends JDialog {
        private JTextField filterField;
        private JLabel errorLabel;
        private String editFilter;

        public EditFilterDialog() throws HeadlessException {
            super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("FilterLibraryDialogAdd_DialogTitle"), false);
            this.editFilter = null;
            this.prepareComponent();
        }

        public EditFilterDialog(String string) throws HeadlessException {
            super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("FilterLibraryDialogAdd_DialogTitle"), false);
            this.editFilter = string;
            this.prepareComponent();
        }

        private void prepareComponent() {
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ EditFilterDialog this$1;
                {
                    this.this$1 = editFilterDialog;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    EditFilterDialog.access$800(this.this$1);
                }
            });
            CellConstraints cellConstraints = new CellConstraints();
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            container.add((Component)jPanel, "Center");
            FormLayout formLayout = new FormLayout("4dlu, d, 3dlu, fill:d:grow, 4dlu", "p, 10dlu, p, 2dlu, p, 10dlu, p, 6dlu, p, 3dlu, p, 3dlu, p, 10dlu, p, 3dlu, p 6dlu");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
            int n = formLayout.getColumnCount();
            int n2 = formLayout.getRowCount();
            DialogBanner dialogBanner = new DialogBanner(Localizer.getString("FilterLibraryDialogAdd_BannerHeader"), Localizer.getString("FilterLibraryDialogAdd_BannerSubHeader"));
            panelBuilder.add((Component)dialogBanner, cellConstraints.xywh(1, 1, n, 1));
            panelBuilder.addLabel(Localizer.getString("FilterLibraryDialogAdd_Filter"), cellConstraints.xy(2, 3));
            this.filterField = new JTextField(40);
            if (this.editFilter != null) {
                this.filterField.setText(this.editFilter);
            }
            panelBuilder.add((Component)this.filterField, cellConstraints.xy(4, 3));
            this.errorLabel = new JLabel(" ");
            panelBuilder.add((Component)this.errorLabel, cellConstraints.xy(4, 5));
            panelBuilder.addSeparator(Localizer.getString("FilterLibraryDialog_Examples"), cellConstraints.xywh(2, 7, 3, 1));
            panelBuilder.addLabel(Localizer.getString("FilterLibraryDialog_Example1"), cellConstraints.xywh(2, 9, 3, 1));
            panelBuilder.addLabel(Localizer.getString("FilterLibraryDialog_Example2"), cellConstraints.xywh(2, 11, 3, 1));
            panelBuilder.addLabel(Localizer.getString("FilterLibraryDialog_Example3"), cellConstraints.xywh(2, 13, 3, 1));
            panelBuilder.add((Component)new JSeparator(), cellConstraints.xywh(1, n2 - 3, n, 1));
            JButton jButton = new JButton(Localizer.getString("Cancel"));
            jButton.addActionListener(new CancelBtnListener());
            JButton jButton2 = new JButton(Localizer.getString("OK"));
            jButton2.addActionListener(new OkBtnListener());
            JPanel jPanel2 = ButtonBarFactory.buildOKCancelBar(jButton2, jButton);
            panelBuilder.add((Component)jPanel2, cellConstraints.xywh(2, n2 - 1, n - 2, 1));
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }

        private void showErrorLabel(String string) {
            this.errorLabel.setText(string);
            this.errorLabel.setIcon(GUIRegistry.getInstance().getIconFactory().getIcon("Error"));
        }

        private void closeDialog() {
            this.setVisible(false);
            this.dispose();
        }

        private final class CancelBtnListener
        implements ActionListener {
            private CancelBtnListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    EditFilterDialog.this.closeDialog();
                }
                catch (Throwable throwable) {
                    NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
                }
            }
        }

        private final class OkBtnListener
        implements ActionListener {
            private OkBtnListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = EditFilterDialog.this.filterField.getText();
                    if (StringUtils.isEmpty(string)) {
                        EditFilterDialog.this.closeDialog();
                        return;
                    }
                    boolean bl = this.validate(string);
                    if (bl) {
                        if (EditFilterDialog.this.editFilter == null) {
                            FilterLibraryDialog.this.addFilter(string);
                        } else {
                            FilterLibraryDialog.this.updateFilter(EditFilterDialog.this.editFilter, string);
                        }
                        EditFilterDialog.this.closeDialog();
                    } else {
                        EditFilterDialog.this.showErrorLabel(Localizer.getString("FilterLibraryDialogAdd_InvalidRegExp"));
                    }
                }
                catch (Throwable throwable) {
                    NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
                }
            }

            private boolean validate(String string) {
                try {
                    Pattern pattern = Pattern.compile(string);
                    return true;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
            }
        }
    }

    private final class CancelBtnListener
    implements ActionListener {
        private CancelBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FilterLibraryDialog.this.closeDialog();
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }
    }

    private final class OkBtnListener
    implements ActionListener {
        private OkBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                LinkedHashSet linkedHashSet = new LinkedHashSet();
                linkedHashSet.addAll(FilterLibraryDialog.this.filterListModel);
                ServiceManager.sCfg.libraryExclusionRegExList.clear();
                ServiceManager.sCfg.libraryExclusionRegExList.addAll(linkedHashSet);
                FilterLibraryDialog.this.closeDialog();
                ServiceManager.sCfg.save();
                GUIActionPerformer.rescanSharedFiles();
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }
    }

    private final class RemoveBtnListener
    implements ActionListener {
        private RemoveBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                int n = FilterLibraryDialog.this.filterList.getSelectedIndex();
                FilterLibraryDialog.this.filterListModel.remove(n);
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }
    }

    private final class EditBtnListener
    implements ActionListener {
        private EditBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = (String)FilterLibraryDialog.this.filterList.getSelectedValue();
                if (StringUtils.isEmpty(string)) {
                    return;
                }
                EditFilterDialog editFilterDialog = new EditFilterDialog(string);
                editFilterDialog.show();
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }
    }

    private final class AddBtnListener
    implements ActionListener {
        private AddBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                EditFilterDialog editFilterDialog = new EditFilterDialog();
                editFilterDialog.show();
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }
    }
}

