/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import org.apache.commons.lang.SystemUtils;
import phex.common.log.LogRecord;
import phex.gui.common.DialogBanner;
import phex.gui.common.GUIRegistry;
import phex.utils.Localizer;

public class LogBufferDialog
extends JDialog {
    private Collection logEntries;
    private DateFormat dateFormat;

    public LogBufferDialog(Collection collection) {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("LogBufferDialog_DialogTitle"), false);
        this.logEntries = collection;
        this.dateFormat = new SimpleDateFormat("yyMMdd HH:mm:ss,SSSS");
        this.prepareComponent();
    }

    private void prepareComponent() {
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        container.add((Component)jPanel, "Center");
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("4dlu, fill:d:grow, 4dlu", "p, p, 2dlu, fill:p:grow, 4dlu, p, 4dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        DialogBanner dialogBanner = new DialogBanner(Localizer.getString("LogBufferDialog_Log"), Localizer.getString("LogBufferDialog_DisplayLog"));
        panelBuilder.add((Component)dialogBanner, cellConstraints.xywh(1, 1, 3, 1));
        panelBuilder.add((Component)new JSeparator(), cellConstraints.xywh(1, 2, 3, 1));
        JTextArea jTextArea = new JTextArea(40, 100);
        jTextArea.setEditable(false);
        panelBuilder.add((Component)new JScrollPane(jTextArea), cellConstraints.xy(2, 4));
        JButton jButton = new JButton(Localizer.getString("Close"));
        jButton.addActionListener(closeEventHandler);
        panelBuilder.add((Component)ButtonBarFactory.buildCloseBar(jButton), cellConstraints.xy(2, 6));
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.logEntries.iterator();
        while (iterator.hasNext()) {
            LogRecord logRecord = (LogRecord)iterator.next();
            stringBuffer.append(this.dateFormat.format(new Date(logRecord.getTimestamp()))).append("::").append(logRecord.getMessage()).append(SystemUtils.LINE_SEPARATOR);
        }
        jTextArea.setText(stringBuffer.toString());
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            LogBufferDialog.this.closeDialog();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LogBufferDialog.this.closeDialog();
        }
    }
}

