/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import phex.gui.common.GUIRegistry;
import phex.gui.common.HTMLMultiLinePanel;
import phex.utils.Localizer;

public class RespectCopyrightDialog
extends JDialog {
    private HTMLMultiLinePanel textPane;
    private JCheckBox dontShowAgainChkbx;

    public RespectCopyrightDialog() {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("RespectCopyrightDialog_DialogTitle"), false);
        this.prepareComponent();
    }

    private void prepareComponent() {
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        container.add((Component)jPanel, "Center");
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("4dlu, 200dlu, 4dlu", "4dlu, p, 4dlu, p, 4dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        this.textPane = new HTMLMultiLinePanel(Localizer.getString("RespectCopyrightDialog_Text"));
        panelBuilder.add((Component)this.textPane, cellConstraints.xy(2, 2));
        this.dontShowAgainChkbx = new JCheckBox(Localizer.getString("RespectCopyrightDialog_DontShowAgain"));
        JButton jButton = new JButton(Localizer.getString("OK"));
        jButton.addActionListener(closeEventHandler);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGridded(this.dontShowAgainChkbx);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addGriddedButtons(new JButton[]{jButton});
        panelBuilder.add((Component)buttonBarBuilder.getPanel(), cellConstraints.xy(2, 4));
        this.pack();
        this.textPane.getPreferredSize();
        this.setSize(this.getPreferredSize());
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.handleClose();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.handleClose();
        }

        private void handleClose() {
            boolean bl = RespectCopyrightDialog.this.dontShowAgainChkbx.isSelected();
            if (bl) {
                GUIRegistry.getInstance().setRespectCopyrightNoticeShown(!bl);
            }
            RespectCopyrightDialog.this.closeDialog();
        }
    }
}

