/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.apache.commons.httpclient.URIException;
import phex.gui.common.DialogBanner;
import phex.gui.common.GUIRegistry;
import phex.update.UpdateCheckRunner;
import phex.update.UpdateDownloader;
import phex.utils.Localizer;
import phex.utils.VersionUtils;

public class UpdateNotificationDialog
extends JDialog {
    private UpdateCheckRunner updateChecker;
    private JCheckBox dontDisplayAgainChkBox;

    public UpdateNotificationDialog(UpdateCheckRunner updateCheckRunner) {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("UpdateNotification_DialogTitle"), false);
        this.updateChecker = updateCheckRunner;
        this.prepareComponent();
    }

    private void prepareComponent() {
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        container.add((Component)jPanel, "Center");
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "p, p, 16dlu, fill:p:grow, 16dlu,p, 2dlu, p 4dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        int n = formLayout.getColumnCount();
        int n2 = formLayout.getRowCount();
        DialogBanner dialogBanner = new DialogBanner(Localizer.getString("UpdateNotification_BannerHeader"), Localizer.getString("UpdateNotification_BannerSubHeader"));
        panelBuilder.add((Component)dialogBanner, cellConstraints.xywh(1, 1, n, 1));
        panelBuilder.add((Component)new JSeparator(), cellConstraints.xywh(1, 2, n, 1));
        JPanel jPanel2 = this.buildNotificationPanel();
        panelBuilder.add((Component)jPanel2, cellConstraints.xy(2, 4, "center, center"));
        panelBuilder.add((Component)new JSeparator(), cellConstraints.xywh(1, n2 - 3, n, 1));
        JButton jButton = new JButton(Localizer.getString("Close"));
        jButton.addActionListener(closeEventHandler);
        JButton jButton2 = new JButton(Localizer.getString("Download"));
        jButton2.setDefaultCapable(true);
        jButton2.setRequestFocusEnabled(true);
        jButton2.addActionListener(new DownloadBtnListener());
        JPanel jPanel3 = ButtonBarFactory.buildOKCancelBar(jButton2, jButton);
        panelBuilder.add((Component)jPanel3, cellConstraints.xywh(2, n2 - 1, n - 2, 1));
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(jButton2);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel buildNotificationPanel() {
        JPanel jPanel = new JPanel();
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("16dlu, d, 8dlu, right:d, 16dlu", "p, 8dlu, p");
        formLayout.setRowGroups(new int[][]{{1, 3}});
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        panelBuilder.addLabel(Localizer.getString("UpdateNotification_YourVersion"), cellConstraints.xy(2, 1));
        panelBuilder.addLabel(VersionUtils.getFullProgramVersion(), cellConstraints.xy(4, 1));
        String string = this.updateChecker.getReleaseVersion();
        String string2 = this.updateChecker.getBetaVersion();
        if (string != null) {
            panelBuilder.addLabel(Localizer.getString("UpdateNotification_AvailableStableVersion"), cellConstraints.xy(2, 3));
            JLabel jLabel = panelBuilder.addLabel(string, cellConstraints.xy(4, 3));
            jLabel.setFont(jLabel.getFont().deriveFont(1));
        } else if (string2 != null) {
            panelBuilder.addLabel(Localizer.getString("UpdateNotification_AvailableBetaVersion"), cellConstraints.xy(2, 3));
            JLabel jLabel = panelBuilder.addLabel(string2, cellConstraints.xy(4, 3));
            jLabel.setFont(jLabel.getFont().deriveFont(1));
        }
        return jPanel;
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            UpdateNotificationDialog.this.closeDialog();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UpdateNotificationDialog.this.closeDialog();
        }
    }

    private final class DownloadBtnListener
    implements ActionListener {
        private DownloadBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                UpdateDownloader.createUpdateDownload();
            }
            catch (URIException uRIException) {
                // empty catch block
            }
            UpdateNotificationDialog.this.closeDialog();
        }
    }
}

