/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import phex.gui.actions.FWAction;
import phex.gui.actions.FWActionGroup;
import phex.gui.common.DialogBanner;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.dialogs.filter.RuleDescOwnerDialog;
import phex.gui.dialogs.filter.RuleDescriptionPanel;
import phex.gui.dialogs.filter.RuleEditWrapper;
import phex.gui.dialogs.filter.SearchFilterRulesEditModel;
import phex.gui.dialogs.filter.wizard.FilterWizardDialog;
import phex.rules.Rule;
import phex.utils.Localizer;
import phex.utils.NLogger;

public class AdvSearchRulesDialog
extends JDialog
implements RuleDescOwnerDialog {
    private FWActionGroup actionGroup = new FWActionGroup();
    private SearchFilterRulesEditModel editModel = new SearchFilterRulesEditModel();
    private JList ruleList;
    private RuleDescriptionPanel ruleDescPanel;

    public AdvSearchRulesDialog() {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("AdvSearchRules_DialogTitle"), false);
        this.prepareComponent();
    }

    private void prepareComponent() {
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        container.add((Component)jPanel, "Center");
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("4dlu, fill:d:grow, 4dlu", "p, p, 4dlu, p, p, 8dlu, p, 2dlu, fill:90dlu:grow, 8dlu, fill:p:grow, 12dlu,p, 2dlu, p 4dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        int n = formLayout.getColumnCount();
        int n2 = formLayout.getRowCount();
        DialogBanner dialogBanner = new DialogBanner(Localizer.getString("AdvSearchRules_BannerHeader"), Localizer.getString("AdvSearchRules_BannerSubHeader"));
        panelBuilder.add((Component)dialogBanner, cellConstraints.xywh(1, 1, n, 1));
        panelBuilder.add((Component)new JSeparator(), cellConstraints.xywh(1, 2, n, 1));
        FWToolBar fWToolBar = new FWToolBar(0);
        fWToolBar.setBorderPainted(false);
        fWToolBar.setFloatable(false);
        fWToolBar.setShowText(true);
        panelBuilder.add((Component)fWToolBar, cellConstraints.xywh(2, 4, 1, 1));
        panelBuilder.add((Component)new JSeparator(), cellConstraints.xywh(2, 5, 1, 1));
        JLabel jLabel = new JLabel(Localizer.getString("AdvSearchRules_RuleListDescription"));
        panelBuilder.add((Component)jLabel, cellConstraints.xywh(2, 7, 1, 1));
        this.ruleList = new JList();
        this.ruleList.setModel(this.editModel);
        this.ruleList.setCellRenderer(new RuleListCellRenderer());
        this.ruleList.getSelectionModel().addListSelectionListener(new RuleListSelectionListener());
        panelBuilder.add((Component)new JScrollPane(this.ruleList), cellConstraints.xywh(2, 9, 1, 1));
        this.ruleDescPanel = new RuleDescriptionPanel(this);
        panelBuilder.add((Component)this.ruleDescPanel, cellConstraints.xywh(2, 11, 1, 1));
        panelBuilder.add((Component)new JSeparator(), cellConstraints.xywh(1, n2 - 3, n, 1));
        JButton jButton = new JButton(Localizer.getString("OK"));
        jButton.setDefaultCapable(true);
        jButton.setRequestFocusEnabled(true);
        jButton.addActionListener(new OkBtnListener());
        JButton jButton2 = new JButton(Localizer.getString("Cancel"));
        jButton2.addActionListener(closeEventHandler);
        JButton jButton3 = new JButton(Localizer.getString("Apply"));
        jButton3.addActionListener(new ApplyBtnListener());
        JPanel jPanel2 = ButtonBarFactory.buildOKCancelApplyBar(jButton, jButton2, jButton3);
        panelBuilder.add((Component)jPanel2, cellConstraints.xywh(2, n2 - 1, n - 2, 1));
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(jButton);
        FWAction fWAction = new NewRuleAction();
        this.actionGroup.addAction(fWAction);
        fWToolBar.addAction(fWAction);
        fWToolBar.addSeparator();
        fWAction = new ChangeRuleAction();
        this.actionGroup.addAction(fWAction);
        fWToolBar.addAction(fWAction);
        fWAction = new CopyRuleAction();
        this.actionGroup.addAction(fWAction);
        fWToolBar.addAction(fWAction);
        fWAction = new DeleteRuleAction();
        this.actionGroup.addAction(fWAction);
        fWToolBar.addAction(fWAction);
        fWToolBar.addSeparator();
        fWAction = new MoveRuleAction(true);
        this.actionGroup.addAction(fWAction);
        fWToolBar.addAction(fWAction);
        fWAction = new MoveRuleAction(false);
        this.actionGroup.addAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.pack();
        int n3 = this.getHeight();
        this.setSize(n3 * 6 / 5, n3);
        this.setLocationRelativeTo(this.getParent());
    }

    public Rule getEditRule() {
        int n = this.ruleList.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return this.editModel.getDisplayRuleAt(n);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public class RuleListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof Rule) {
                this.setText(((Rule)object).getName());
            } else if (object instanceof RuleEditWrapper) {
                this.setText(((RuleEditWrapper)object).getName());
            }
            return this;
        }
    }

    public class RuleListSelectionListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            AdvSearchRulesDialog.this.actionGroup.refreshActions();
            AdvSearchRulesDialog.this.ruleDescPanel.updateRuleData();
        }
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            AdvSearchRulesDialog.this.closeDialog();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AdvSearchRulesDialog.this.closeDialog();
        }
    }

    private final class OkBtnListener
    implements ActionListener {
        private OkBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                AdvSearchRulesDialog.this.editModel.applyChangesToQueryManager();
                AdvSearchRulesDialog.this.closeDialog();
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }
    }

    private final class ApplyBtnListener
    implements ActionListener {
        private ApplyBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                AdvSearchRulesDialog.this.editModel.applyChangesToQueryManager();
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }
    }

    class MoveRuleAction
    extends FWAction {
        private static final boolean MOVE_UP = true;
        private static final boolean MOVE_DOWN = false;
        private boolean moveUp;

        MoveRuleAction(boolean bl) {
            this.moveUp = bl;
            if (this.moveUp) {
                this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("MoveUp"));
                this.setToolTipText(Localizer.getString("AdvSearchRules_TTTMoveUp"));
            } else {
                this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("MoveDown"));
                this.setToolTipText(Localizer.getString("AdvSearchRules_TTTMoveDown"));
            }
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                int n = AdvSearchRulesDialog.this.ruleList.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                int n2 = AdvSearchRulesDialog.this.editModel.moveRule(n, this.moveUp);
                AdvSearchRulesDialog.this.ruleList.setSelectedIndex(n2);
            }
            catch (Throwable throwable) {
                NLogger.error("USER_INTERFACE", (Object)throwable, throwable);
            }
        }

        public void refreshActionState() {
            int n = AdvSearchRulesDialog.this.ruleList.getSelectedIndex();
            if (n < 0) {
                this.setEnabled(false);
            } else if (this.moveUp && n == 0) {
                this.setEnabled(false);
            } else if (!this.moveUp && n == AdvSearchRulesDialog.this.editModel.getSize() - 1) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class DeleteRuleAction
    extends FWAction {
        public DeleteRuleAction() {
            super(Localizer.getString("AdvSearchRules_DeleteRule"), null, Localizer.getString("AdvSearchRules_TTTDeleteRule"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = AdvSearchRulesDialog.this.ruleList.getSelectedIndex();
            if (n < 0) {
                return;
            }
            AdvSearchRulesDialog.this.editModel.removeRule(n);
            AdvSearchRulesDialog.this.ruleDescPanel.updateRuleData();
        }

        public void refreshActionState() {
            this.setEnabled(!AdvSearchRulesDialog.this.ruleList.isSelectionEmpty());
        }
    }

    private class ChangeRuleAction
    extends FWAction {
        public ChangeRuleAction() {
            super(Localizer.getString("AdvSearchRules_ChangeRule"), null, Localizer.getString("AdvSearchRules_TTTChangeRule"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = AdvSearchRulesDialog.this.ruleList.getSelectedIndex();
            if (n < 0) {
                return;
            }
            Rule rule = AdvSearchRulesDialog.this.editModel.getDisplayRuleAt(n);
            FilterWizardDialog filterWizardDialog = new FilterWizardDialog(rule, AdvSearchRulesDialog.this);
            filterWizardDialog.show();
            Rule rule2 = filterWizardDialog.getEditRule();
            if (rule2 != null) {
                AdvSearchRulesDialog.this.editModel.updateRule(n, rule2);
            }
            AdvSearchRulesDialog.this.ruleDescPanel.updateRuleData();
        }

        public void refreshActionState() {
            this.setEnabled(!AdvSearchRulesDialog.this.ruleList.isSelectionEmpty());
        }
    }

    private class CopyRuleAction
    extends FWAction {
        public CopyRuleAction() {
            super(Localizer.getString("AdvSearchRules_CopyRule"), null, Localizer.getString("AdvSearchRules_TTTCopyRule"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = AdvSearchRulesDialog.this.ruleList.getSelectedIndex();
            if (n < 0) {
                return;
            }
            Rule rule = AdvSearchRulesDialog.this.editModel.getDisplayRuleAt(n);
            Rule rule2 = (Rule)rule.clone();
            rule2.setName(Localizer.getString("RuleVisualization_CopyOf") + " " + rule.getName());
            rule2.setDefaultRule(false);
            AdvSearchRulesDialog.this.editModel.addNewRule(rule2);
        }

        public void refreshActionState() {
            this.setEnabled(!AdvSearchRulesDialog.this.ruleList.isSelectionEmpty());
        }
    }

    private class NewRuleAction
    extends FWAction {
        public NewRuleAction() {
            super(Localizer.getString("AdvSearchRules_NewRule"), null, Localizer.getString("AdvSearchRules_TTTNewRule"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FilterWizardDialog filterWizardDialog = new FilterWizardDialog(AdvSearchRulesDialog.this);
            filterWizardDialog.show();
            Rule rule = filterWizardDialog.getEditRule();
            if (rule != null) {
                AdvSearchRulesDialog.this.editModel.addNewRule(rule);
                AdvSearchRulesDialog.this.actionGroup.refreshActions();
            }
        }

        public void refreshActionState() {
        }
    }
}

